/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.core.spec.SoundboardSoundCreateSpecGenerator;
import discord4j.discordjson.json.EmojiData;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class SoundboardSoundCreateSpec
implements SoundboardSoundCreateSpecGenerator {
    @reactor.util.annotation.Nullable
    private final String reason;
    private final String name;
    private final String sound;
    private final Double volume_value;
    private final boolean volume_absent;
    private final EmojiData emoji_value;
    private final boolean emoji_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private SoundboardSoundCreateSpec(String name, String sound) {
        this.name = Objects.requireNonNull(name, "name");
        this.sound = Objects.requireNonNull(sound, "sound");
        this.reason = null;
        Possible volume$impl = Possible.absent();
        Possible emoji$impl = Possible.absent();
        this.volume_value = Possible.flatOpt((Possible)volume$impl).orElse(null);
        this.volume_absent = volume$impl.isAbsent();
        this.emoji_value = Possible.flatOpt((Possible)emoji$impl).orElse(null);
        this.emoji_absent = emoji$impl.isAbsent();
        this.initShim = null;
    }

    private SoundboardSoundCreateSpec(@reactor.util.annotation.Nullable String reason, String name, String sound, Possible<Optional<Double>> volume, Possible<Optional<EmojiData>> emoji) {
        this.reason = reason;
        this.name = name;
        this.sound = sound;
        Possible<Optional<Double>> volume$impl = volume;
        Possible<Optional<EmojiData>> emoji$impl = emoji;
        this.volume_value = Possible.flatOpt(volume$impl).orElse(null);
        this.volume_absent = volume$impl.isAbsent();
        this.emoji_value = Possible.flatOpt(emoji$impl).orElse(null);
        this.emoji_absent = emoji$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @reactor.util.annotation.Nullable
    public String reason() {
        return this.reason;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String sound() {
        return this.sound;
    }

    @Override
    public Possible<Optional<Double>> volume() {
        return this.volume_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.volume_value));
    }

    @Override
    public Possible<Optional<EmojiData>> emoji() {
        return this.emoji_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.emoji_value));
    }

    public final SoundboardSoundCreateSpec withReason(@reactor.util.annotation.Nullable String value) {
        if (Objects.equals(this.reason, value)) {
            return this;
        }
        return new SoundboardSoundCreateSpec(value, this.name, this.sound, this.volume(), this.emoji());
    }

    public final SoundboardSoundCreateSpec withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new SoundboardSoundCreateSpec(this.reason, newValue, this.sound, this.volume(), this.emoji());
    }

    public final SoundboardSoundCreateSpec withSound(String value) {
        String newValue = Objects.requireNonNull(value, "sound");
        if (this.sound.equals(newValue)) {
            return this;
        }
        return new SoundboardSoundCreateSpec(this.reason, this.name, newValue, this.volume(), this.emoji());
    }

    public SoundboardSoundCreateSpec withVolume(Possible<Optional<Double>> value) {
        Possible<Optional<Double>> newValue = Objects.requireNonNull(value);
        return new SoundboardSoundCreateSpec(this.reason, this.name, this.sound, newValue, this.emoji());
    }

    @Deprecated
    public SoundboardSoundCreateSpec withVolume(@Nullable Double value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new SoundboardSoundCreateSpec(this.reason, this.name, this.sound, (Possible<Optional<Double>>)newValue, this.emoji());
    }

    public SoundboardSoundCreateSpec withVolumeOrNull(@Nullable Double value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new SoundboardSoundCreateSpec(this.reason, this.name, this.sound, (Possible<Optional<Double>>)newValue, this.emoji());
    }

    public SoundboardSoundCreateSpec withEmoji(Possible<Optional<EmojiData>> value) {
        Possible<Optional<EmojiData>> newValue = Objects.requireNonNull(value);
        return new SoundboardSoundCreateSpec(this.reason, this.name, this.sound, this.volume(), newValue);
    }

    @Deprecated
    public SoundboardSoundCreateSpec withEmoji(@Nullable EmojiData value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new SoundboardSoundCreateSpec(this.reason, this.name, this.sound, this.volume(), (Possible<Optional<EmojiData>>)newValue);
    }

    public SoundboardSoundCreateSpec withEmojiOrNull(@Nullable EmojiData value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new SoundboardSoundCreateSpec(this.reason, this.name, this.sound, this.volume(), (Possible<Optional<EmojiData>>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SoundboardSoundCreateSpec && this.equalTo(0, (SoundboardSoundCreateSpec)another);
    }

    private boolean equalTo(int synthetic, SoundboardSoundCreateSpec another) {
        return Objects.equals(this.reason, another.reason) && this.name.equals(another.name) && this.sound.equals(another.sound) && this.volume().equals(another.volume()) && this.emoji().equals(another.emoji());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.reason);
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.sound.hashCode();
        h += (h << 5) + this.volume().hashCode();
        h += (h << 5) + this.emoji().hashCode();
        return h;
    }

    public String toString() {
        return "SoundboardSoundCreateSpec{reason=" + this.reason + ", name=" + this.name + ", sound=" + this.sound + ", volume=" + this.volume().toString() + ", emoji=" + this.emoji().toString() + "}";
    }

    public static SoundboardSoundCreateSpec of(String name, String sound) {
        return new SoundboardSoundCreateSpec(name, sound);
    }

    public static SoundboardSoundCreateSpec copyOf(SoundboardSoundCreateSpecGenerator instance) {
        if (instance instanceof SoundboardSoundCreateSpec) {
            return (SoundboardSoundCreateSpec)instance;
        }
        return SoundboardSoundCreateSpec.builder().from(instance).build();
    }

    public boolean isVolumePresent() {
        return !this.volume_absent;
    }

    public Double volumeOrElse(Double defaultValue) {
        return !this.volume_absent ? this.volume_value : defaultValue;
    }

    public boolean isEmojiPresent() {
        return !this.emoji_absent;
    }

    public EmojiData emojiOrElse(EmojiData defaultValue) {
        return !this.emoji_absent ? this.emoji_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_SOUND = 2L;
        private long initBits = 3L;
        private Possible<Optional<Double>> volume_possible = Possible.absent();
        private Possible<Optional<EmojiData>> emoji_possible = Possible.absent();
        @Nullable
        private String reason;
        @Nullable
        private String name;
        @Nullable
        private String sound;

        private Builder() {
        }

        public final Builder from(SoundboardSoundCreateSpecGenerator instance) {
            Objects.requireNonNull(instance, "instance");
            String reasonValue = instance.reason();
            if (reasonValue != null) {
                this.reason(reasonValue);
            }
            this.name(instance.name());
            this.sound(instance.sound());
            this.volume(instance.volume());
            this.emoji(instance.emoji());
            return this;
        }

        public final Builder reason(@reactor.util.annotation.Nullable String reason) {
            this.reason = reason;
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder sound(String sound) {
            this.sound = Objects.requireNonNull(sound, "sound");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder volume(Possible<Optional<Double>> value) {
            this.volume_possible = value;
            return this;
        }

        @Deprecated
        public Builder volume(@Nullable Double value) {
            this.volume_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public Builder volumeOrNull(@Nullable Double value) {
            this.volume_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public Builder emoji(Possible<Optional<EmojiData>> value) {
            this.emoji_possible = value;
            return this;
        }

        @Deprecated
        public Builder emoji(@Nullable EmojiData value) {
            this.emoji_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public Builder emojiOrNull(@Nullable EmojiData value) {
            this.emoji_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public SoundboardSoundCreateSpec build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new SoundboardSoundCreateSpec(this.reason, this.name, this.sound, this.volume_build(), this.emoji_build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("sound");
            }
            return "Cannot build SoundboardSoundCreateSpec, some of required attributes are not set " + attributes;
        }

        private Possible<Optional<Double>> volume_build() {
            return this.volume_possible;
        }

        private Possible<Optional<EmojiData>> emoji_build() {
            return this.emoji_possible;
        }
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build SoundboardSoundCreateSpec, attribute initializers form cycle " + attributes;
        }
    }
}

