/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.core.object.entity.poll.Poll;
import discord4j.core.object.entity.poll.PollAnswer;
import discord4j.core.spec.PollCreateSpecGenerator;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;

public final class PollCreateSpec
implements PollCreateSpecGenerator {
    private final String question_value;
    private final boolean question_absent;
    private final List<PollAnswer> answers_value;
    private final boolean answers_absent;
    private final Integer duration_value;
    private final boolean duration_absent;
    private final Boolean allowMultiselect_value;
    private final boolean allowMultiselect_absent;
    private final Poll.PollLayoutType layoutType_value;
    private final boolean layoutType_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private PollCreateSpec(Possible<String> question, Possible<List<PollAnswer>> answers, Possible<Integer> duration, Possible<Boolean> allowMultiselect, Possible<Poll.PollLayoutType> layoutType) {
        Possible<String> question$impl = question;
        Possible<List<PollAnswer>> answers$impl = answers;
        Possible<Integer> duration$impl = duration;
        Possible<Boolean> allowMultiselect$impl = allowMultiselect;
        Possible<Poll.PollLayoutType> layoutType$impl = layoutType;
        this.question_value = question$impl.toOptional().orElse(null);
        this.question_absent = question$impl.isAbsent();
        this.answers_value = answers$impl.toOptional().orElse(null);
        this.answers_absent = answers$impl.isAbsent();
        this.duration_value = duration$impl.toOptional().orElse(null);
        this.duration_absent = duration$impl.isAbsent();
        this.allowMultiselect_value = allowMultiselect$impl.toOptional().orElse(null);
        this.allowMultiselect_absent = allowMultiselect$impl.isAbsent();
        this.layoutType_value = layoutType$impl.toOptional().orElse(null);
        this.layoutType_absent = layoutType$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    public Possible<String> question() {
        return this.question_absent ? Possible.absent() : Possible.of((Object)this.question_value);
    }

    @Override
    public Possible<List<PollAnswer>> answers() {
        return this.answers_absent ? Possible.absent() : Possible.of(this.answers_value);
    }

    @Override
    public Possible<Integer> duration() {
        return this.duration_absent ? Possible.absent() : Possible.of((Object)this.duration_value);
    }

    @Override
    public Possible<Boolean> allowMultiselect() {
        return this.allowMultiselect_absent ? Possible.absent() : Possible.of((Object)this.allowMultiselect_value);
    }

    @Override
    public Possible<Poll.PollLayoutType> layoutType() {
        return this.layoutType_absent ? Possible.absent() : Possible.of((Object)((Object)this.layoutType_value));
    }

    public PollCreateSpec withQuestion(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return new PollCreateSpec(newValue, this.answers(), this.duration(), this.allowMultiselect(), this.layoutType());
    }

    public PollCreateSpec withQuestion(String value) {
        Possible newValue = Possible.of((Object)value);
        return new PollCreateSpec((Possible<String>)newValue, this.answers(), this.duration(), this.allowMultiselect(), this.layoutType());
    }

    public PollCreateSpec withAnswers(Possible<List<PollAnswer>> possible) {
        Possible<List<PollAnswer>> newValue = Objects.requireNonNull(possible);
        return new PollCreateSpec(this.question(), newValue, this.duration(), this.allowMultiselect(), this.layoutType());
    }

    public PollCreateSpec withAnswers(Iterable<PollAnswer> elements) {
        Possible newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return new PollCreateSpec(this.question(), (Possible<List<PollAnswer>>)newValue, this.duration(), this.allowMultiselect(), this.layoutType());
    }

    @SafeVarargs
    public final PollCreateSpec withAnswers(PollAnswer ... elements) {
        Possible newValue = Possible.of(Arrays.asList(elements));
        return new PollCreateSpec(this.question(), (Possible<List<PollAnswer>>)newValue, this.duration(), this.allowMultiselect(), this.layoutType());
    }

    public PollCreateSpec withDuration(Possible<Integer> value) {
        Possible<Integer> newValue = Objects.requireNonNull(value);
        return new PollCreateSpec(this.question(), this.answers(), newValue, this.allowMultiselect(), this.layoutType());
    }

    public PollCreateSpec withDuration(Integer value) {
        Possible newValue = Possible.of((Object)value);
        return new PollCreateSpec(this.question(), this.answers(), (Possible<Integer>)newValue, this.allowMultiselect(), this.layoutType());
    }

    public PollCreateSpec withAllowMultiselect(Possible<Boolean> value) {
        Possible<Boolean> newValue = Objects.requireNonNull(value);
        return new PollCreateSpec(this.question(), this.answers(), this.duration(), newValue, this.layoutType());
    }

    public PollCreateSpec withAllowMultiselect(Boolean value) {
        Possible newValue = Possible.of((Object)value);
        return new PollCreateSpec(this.question(), this.answers(), this.duration(), (Possible<Boolean>)newValue, this.layoutType());
    }

    public PollCreateSpec withLayoutType(Possible<Poll.PollLayoutType> value) {
        Possible<Poll.PollLayoutType> newValue = Objects.requireNonNull(value);
        return new PollCreateSpec(this.question(), this.answers(), this.duration(), this.allowMultiselect(), newValue);
    }

    public PollCreateSpec withLayoutType(Poll.PollLayoutType value) {
        Possible newValue = Possible.of((Object)((Object)value));
        return new PollCreateSpec(this.question(), this.answers(), this.duration(), this.allowMultiselect(), (Possible<Poll.PollLayoutType>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof PollCreateSpec && this.equalTo(0, (PollCreateSpec)another);
    }

    private boolean equalTo(int synthetic, PollCreateSpec another) {
        return this.question().equals(another.question()) && Objects.equals(this.answers_value, another.answers_value) && this.duration().equals(another.duration()) && this.allowMultiselect().equals(another.allowMultiselect()) && this.layoutType().equals(another.layoutType());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.question().hashCode();
        h += (h << 5) + Objects.hashCode(this.answers_value);
        h += (h << 5) + this.duration().hashCode();
        h += (h << 5) + this.allowMultiselect().hashCode();
        h += (h << 5) + this.layoutType().hashCode();
        return h;
    }

    public String toString() {
        return "PollCreateSpec{question=" + this.question().toString() + ", answers=" + Objects.toString(this.answers_value) + ", duration=" + this.duration().toString() + ", allowMultiselect=" + this.allowMultiselect().toString() + ", layoutType=" + this.layoutType().toString() + "}";
    }

    public static PollCreateSpec copyOf(PollCreateSpecGenerator instance) {
        if (instance instanceof PollCreateSpec) {
            return (PollCreateSpec)instance;
        }
        return PollCreateSpec.builder().from(instance).build();
    }

    public boolean isQuestionPresent() {
        return !this.question_absent;
    }

    public String questionOrElse(String defaultValue) {
        return !this.question_absent ? this.question_value : defaultValue;
    }

    public boolean isAnswersPresent() {
        return !this.answers_absent;
    }

    public List<PollAnswer> answersOrElse(List<PollAnswer> defaultValue) {
        return !this.answers_absent ? this.answers_value : defaultValue;
    }

    public boolean isDurationPresent() {
        return !this.duration_absent;
    }

    public Integer durationOrElse(Integer defaultValue) {
        return !this.duration_absent ? this.duration_value : defaultValue;
    }

    public boolean isAllowMultiselectPresent() {
        return !this.allowMultiselect_absent;
    }

    public Boolean allowMultiselectOrElse(Boolean defaultValue) {
        return !this.allowMultiselect_absent ? this.allowMultiselect_value : defaultValue;
    }

    public boolean isLayoutTypePresent() {
        return !this.layoutType_absent;
    }

    public Poll.PollLayoutType layoutTypeOrElse(Poll.PollLayoutType defaultValue) {
        return !this.layoutType_absent ? this.layoutType_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Possible<String> question_possible = Possible.absent();
        private List<PollAnswer> answers_list = null;
        private Possible<Integer> duration_possible = Possible.absent();
        private Possible<Boolean> allowMultiselect_possible = Possible.absent();
        private Possible<Poll.PollLayoutType> layoutType_possible = Possible.absent();

        private Builder() {
        }

        public final Builder from(PollCreateSpecGenerator instance) {
            Objects.requireNonNull(instance, "instance");
            this.question(instance.question());
            this.answers(instance.answers());
            this.duration(instance.duration());
            this.allowMultiselect(instance.allowMultiselect());
            this.layoutType(instance.layoutType());
            return this;
        }

        public Builder question(Possible<String> value) {
            this.question_possible = value;
            return this;
        }

        public Builder question(String value) {
            this.question_possible = Possible.of((Object)value);
            return this;
        }

        public Builder addAnswer(PollAnswer element) {
            this.answers_getOrCreate().add(element);
            return this;
        }

        public Builder addAllAnswers(List<PollAnswer> elements) {
            this.answers_getOrCreate().addAll(elements);
            return this;
        }

        public Builder answers(Possible<List<PollAnswer>> elements) {
            this.answers_list = null;
            elements.toOptional().ifPresent(e -> this.answers_getOrCreate().addAll((Collection<PollAnswer>)e));
            return this;
        }

        public Builder answers(List<PollAnswer> elements) {
            this.answers_list = new ArrayList<PollAnswer>(elements);
            return this;
        }

        public Builder answers(Iterable<PollAnswer> elements) {
            this.answers_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
            return this;
        }

        public Builder duration(Possible<Integer> value) {
            this.duration_possible = value;
            return this;
        }

        public Builder duration(Integer value) {
            this.duration_possible = Possible.of((Object)value);
            return this;
        }

        public Builder allowMultiselect(Possible<Boolean> value) {
            this.allowMultiselect_possible = value;
            return this;
        }

        public Builder allowMultiselect(Boolean value) {
            this.allowMultiselect_possible = Possible.of((Object)value);
            return this;
        }

        public Builder layoutType(Possible<Poll.PollLayoutType> value) {
            this.layoutType_possible = value;
            return this;
        }

        public Builder layoutType(Poll.PollLayoutType value) {
            this.layoutType_possible = Possible.of((Object)((Object)value));
            return this;
        }

        public PollCreateSpec build() {
            return new PollCreateSpec(this.question_build(), this.answers_build(), this.duration_build(), this.allowMultiselect_build(), this.layoutType_build());
        }

        private Possible<String> question_build() {
            return this.question_possible;
        }

        private Possible<List<PollAnswer>> answers_build() {
            return this.answers_list == null ? Possible.absent() : Possible.of(this.answers_list);
        }

        private List<PollAnswer> answers_getOrCreate() {
            if (this.answers_list == null) {
                this.answers_list = new ArrayList<PollAnswer>();
            }
            return this.answers_list;
        }

        private Possible<Integer> duration_build() {
            return this.duration_possible;
        }

        private Possible<Boolean> allowMultiselect_build() {
            return this.allowMultiselect_possible;
        }

        private Possible<Poll.PollLayoutType> layoutType_build() {
            return this.layoutType_possible;
        }
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build PollCreateSpec, attribute initializers form cycle " + attributes;
        }
    }
}

