/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.core.object.entity.channel.MessageChannel;
import discord4j.core.object.entity.poll.Poll;
import discord4j.core.object.entity.poll.PollAnswer;
import discord4j.core.spec.PollCreateMonoGenerator;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;

public final class PollCreateMono
extends PollCreateMonoGenerator {
    private final String question_value;
    private final boolean question_absent;
    private final List<PollAnswer> answers_value;
    private final boolean answers_absent;
    private final Integer duration_value;
    private final boolean duration_absent;
    private final Boolean allowMultiselect_value;
    private final boolean allowMultiselect_absent;
    private final Poll.PollLayoutType layoutType_value;
    private final boolean layoutType_absent;
    private final MessageChannel channel;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private PollCreateMono(MessageChannel channel) {
        this.channel = Objects.requireNonNull(channel, "channel");
        Possible question$impl = Possible.absent();
        Possible answers$impl = Possible.absent();
        Possible duration$impl = Possible.absent();
        Possible allowMultiselect$impl = Possible.absent();
        Possible layoutType$impl = Possible.absent();
        this.question_value = question$impl.toOptional().orElse(null);
        this.question_absent = question$impl.isAbsent();
        this.answers_value = answers$impl.toOptional().orElse(null);
        this.answers_absent = answers$impl.isAbsent();
        this.duration_value = duration$impl.toOptional().orElse(null);
        this.duration_absent = duration$impl.isAbsent();
        this.allowMultiselect_value = allowMultiselect$impl.toOptional().orElse(null);
        this.allowMultiselect_absent = allowMultiselect$impl.isAbsent();
        this.layoutType_value = layoutType$impl.toOptional().orElse(null);
        this.layoutType_absent = layoutType$impl.isAbsent();
        this.initShim = null;
    }

    private PollCreateMono(Possible<String> question, Possible<List<PollAnswer>> answers, Possible<Integer> duration, Possible<Boolean> allowMultiselect, Possible<Poll.PollLayoutType> layoutType, MessageChannel channel) {
        Possible<String> question$impl = question;
        Possible<List<PollAnswer>> answers$impl = answers;
        Possible<Integer> duration$impl = duration;
        Possible<Boolean> allowMultiselect$impl = allowMultiselect;
        Possible<Poll.PollLayoutType> layoutType$impl = layoutType;
        this.channel = channel;
        this.question_value = question$impl.toOptional().orElse(null);
        this.question_absent = question$impl.isAbsent();
        this.answers_value = answers$impl.toOptional().orElse(null);
        this.answers_absent = answers$impl.isAbsent();
        this.duration_value = duration$impl.toOptional().orElse(null);
        this.duration_absent = duration$impl.isAbsent();
        this.allowMultiselect_value = allowMultiselect$impl.toOptional().orElse(null);
        this.allowMultiselect_absent = allowMultiselect$impl.isAbsent();
        this.layoutType_value = layoutType$impl.toOptional().orElse(null);
        this.layoutType_absent = layoutType$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    public Possible<String> question() {
        return this.question_absent ? Possible.absent() : Possible.of((Object)this.question_value);
    }

    @Override
    public Possible<List<PollAnswer>> answers() {
        return this.answers_absent ? Possible.absent() : Possible.of(this.answers_value);
    }

    @Override
    public Possible<Integer> duration() {
        return this.duration_absent ? Possible.absent() : Possible.of((Object)this.duration_value);
    }

    @Override
    public Possible<Boolean> allowMultiselect() {
        return this.allowMultiselect_absent ? Possible.absent() : Possible.of((Object)this.allowMultiselect_value);
    }

    @Override
    public Possible<Poll.PollLayoutType> layoutType() {
        return this.layoutType_absent ? Possible.absent() : Possible.of((Object)((Object)this.layoutType_value));
    }

    @Override
    public MessageChannel channel() {
        return this.channel;
    }

    public PollCreateMono withQuestion(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return new PollCreateMono(newValue, this.answers(), this.duration(), this.allowMultiselect(), this.layoutType(), this.channel);
    }

    public PollCreateMono withQuestion(String value) {
        Possible newValue = Possible.of((Object)value);
        return new PollCreateMono((Possible<String>)newValue, this.answers(), this.duration(), this.allowMultiselect(), this.layoutType(), this.channel);
    }

    public PollCreateMono withAnswers(Possible<List<PollAnswer>> possible) {
        Possible<List<PollAnswer>> newValue = Objects.requireNonNull(possible);
        return new PollCreateMono(this.question(), newValue, this.duration(), this.allowMultiselect(), this.layoutType(), this.channel);
    }

    public PollCreateMono withAnswers(Iterable<PollAnswer> elements) {
        Possible newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return new PollCreateMono(this.question(), (Possible<List<PollAnswer>>)newValue, this.duration(), this.allowMultiselect(), this.layoutType(), this.channel);
    }

    @SafeVarargs
    public final PollCreateMono withAnswers(PollAnswer ... elements) {
        Possible newValue = Possible.of(Arrays.asList(elements));
        return new PollCreateMono(this.question(), (Possible<List<PollAnswer>>)newValue, this.duration(), this.allowMultiselect(), this.layoutType(), this.channel);
    }

    public PollCreateMono withDuration(Possible<Integer> value) {
        Possible<Integer> newValue = Objects.requireNonNull(value);
        return new PollCreateMono(this.question(), this.answers(), newValue, this.allowMultiselect(), this.layoutType(), this.channel);
    }

    public PollCreateMono withDuration(Integer value) {
        Possible newValue = Possible.of((Object)value);
        return new PollCreateMono(this.question(), this.answers(), (Possible<Integer>)newValue, this.allowMultiselect(), this.layoutType(), this.channel);
    }

    public PollCreateMono withAllowMultiselect(Possible<Boolean> value) {
        Possible<Boolean> newValue = Objects.requireNonNull(value);
        return new PollCreateMono(this.question(), this.answers(), this.duration(), newValue, this.layoutType(), this.channel);
    }

    public PollCreateMono withAllowMultiselect(Boolean value) {
        Possible newValue = Possible.of((Object)value);
        return new PollCreateMono(this.question(), this.answers(), this.duration(), (Possible<Boolean>)newValue, this.layoutType(), this.channel);
    }

    public PollCreateMono withLayoutType(Possible<Poll.PollLayoutType> value) {
        Possible<Poll.PollLayoutType> newValue = Objects.requireNonNull(value);
        return new PollCreateMono(this.question(), this.answers(), this.duration(), this.allowMultiselect(), newValue, this.channel);
    }

    public PollCreateMono withLayoutType(Poll.PollLayoutType value) {
        Possible newValue = Possible.of((Object)((Object)value));
        return new PollCreateMono(this.question(), this.answers(), this.duration(), this.allowMultiselect(), (Possible<Poll.PollLayoutType>)newValue, this.channel);
    }

    public final PollCreateMono withChannel(MessageChannel value) {
        if (this.channel == value) {
            return this;
        }
        MessageChannel newValue = Objects.requireNonNull(value, "channel");
        return new PollCreateMono(this.question(), this.answers(), this.duration(), this.allowMultiselect(), this.layoutType(), newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof PollCreateMono && this.equalTo(0, (PollCreateMono)another);
    }

    private boolean equalTo(int synthetic, PollCreateMono another) {
        return this.question().equals(another.question()) && Objects.equals(this.answers_value, another.answers_value) && this.duration().equals(another.duration()) && this.allowMultiselect().equals(another.allowMultiselect()) && this.layoutType().equals(another.layoutType()) && this.channel.equals(another.channel);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.question().hashCode();
        h += (h << 5) + Objects.hashCode(this.answers_value);
        h += (h << 5) + this.duration().hashCode();
        h += (h << 5) + this.allowMultiselect().hashCode();
        h += (h << 5) + this.layoutType().hashCode();
        h += (h << 5) + this.channel.hashCode();
        return h;
    }

    @Override
    public String toString() {
        return "PollCreateMono{question=" + this.question().toString() + ", answers=" + Objects.toString(this.answers_value) + ", duration=" + this.duration().toString() + ", allowMultiselect=" + this.allowMultiselect().toString() + ", layoutType=" + this.layoutType().toString() + ", channel=" + this.channel + "}";
    }

    public static PollCreateMono of(MessageChannel channel) {
        return new PollCreateMono(channel);
    }

    static PollCreateMono copyOf(PollCreateMonoGenerator instance) {
        if (instance instanceof PollCreateMono) {
            return (PollCreateMono)instance;
        }
        return PollCreateMono.of(instance.channel()).withQuestion((Possible<String>)instance.question()).withAnswers((Possible<List<PollAnswer>>)instance.answers()).withDuration((Possible<Integer>)instance.duration()).withAllowMultiselect((Possible<Boolean>)instance.allowMultiselect()).withLayoutType((Possible<Poll.PollLayoutType>)instance.layoutType());
    }

    public boolean isQuestionPresent() {
        return !this.question_absent;
    }

    public String questionOrElse(String defaultValue) {
        return !this.question_absent ? this.question_value : defaultValue;
    }

    public boolean isAnswersPresent() {
        return !this.answers_absent;
    }

    public List<PollAnswer> answersOrElse(List<PollAnswer> defaultValue) {
        return !this.answers_absent ? this.answers_value : defaultValue;
    }

    public boolean isDurationPresent() {
        return !this.duration_absent;
    }

    public Integer durationOrElse(Integer defaultValue) {
        return !this.duration_absent ? this.duration_value : defaultValue;
    }

    public boolean isAllowMultiselectPresent() {
        return !this.allowMultiselect_absent;
    }

    public Boolean allowMultiselectOrElse(Boolean defaultValue) {
        return !this.allowMultiselect_absent ? this.allowMultiselect_value : defaultValue;
    }

    public boolean isLayoutTypePresent() {
        return !this.layoutType_absent;
    }

    public Poll.PollLayoutType layoutTypeOrElse(Poll.PollLayoutType defaultValue) {
        return !this.layoutType_absent ? this.layoutType_value : defaultValue;
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build PollCreateMono, attribute initializers form cycle " + attributes;
        }
    }
}

