/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.common.util.Snowflake;
import discord4j.core.object.component.BaseMessageComponent;
import discord4j.core.object.component.TopLevelMessageComponent;
import discord4j.core.object.entity.Message;
import discord4j.core.spec.EmbedCreateSpec;
import discord4j.core.spec.EmbedCreateSpecGenerator;
import discord4j.core.spec.InternalSpecUtils;
import discord4j.core.spec.MessageCreateFields;
import discord4j.core.spec.Spec;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.ImmutableMessageCreateRequest;
import discord4j.discordjson.json.MessageCreateRequest;
import discord4j.discordjson.json.MessageReferenceData;
import discord4j.discordjson.json.PollCreateData;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.AllowedMentions;
import discord4j.rest.util.MultipartRequest;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.immutables.value.Value;

@Value.Immutable(singleton=true)
interface MessageCreateSpecGenerator
extends Spec<MultipartRequest<MessageCreateRequest>> {
    public Possible<String> content();

    public Possible<String> nonce();

    public Possible<Boolean> enforceNonce();

    public Possible<Boolean> tts();

    public Possible<List<EmbedCreateSpec>> embeds();

    @Value.Default
    default public List<MessageCreateFields.File> files() {
        return Collections.emptyList();
    }

    @Value.Default
    default public List<MessageCreateFields.FileSpoiler> fileSpoilers() {
        return Collections.emptyList();
    }

    public Possible<AllowedMentions> allowedMentions();

    @Deprecated
    public Possible<Snowflake> messageReferenceId();

    public Possible<MessageReferenceData> messageReference();

    public Possible<List<TopLevelMessageComponent>> components();

    public Possible<List<Snowflake>> stickersIds();

    public Possible<PollCreateData> poll();

    public Possible<List<Message.Flag>> flags();

    @Override
    default public MultipartRequest<MessageCreateRequest> asRequest() {
        ImmutableMessageCreateRequest json = MessageCreateRequest.builder().content(this.content()).nonce(this.nonce()).enforceNonce(this.enforceNonce()).tts(this.tts()).embeds(InternalSpecUtils.mapPossible(this.embeds(), embeds -> embeds.stream().map(EmbedCreateSpecGenerator::asRequest).collect(Collectors.toList()))).allowedMentions(InternalSpecUtils.mapPossible(this.allowedMentions(), AllowedMentions::toData)).messageReference(this.messageReference().isAbsent() ? InternalSpecUtils.mapPossible(this.messageReferenceId(), ref -> MessageReferenceData.builder().messageId(ref.asString()).build()) : this.messageReference()).components(InternalSpecUtils.mapPossible(this.components(), components -> components.stream().map(BaseMessageComponent::getData).collect(Collectors.toList()))).stickerIds(InternalSpecUtils.mapPossible(this.stickersIds(), r -> r.stream().map(Snowflake::asLong).map(Id::of).collect(Collectors.toList()))).poll(this.poll()).flags(InternalSpecUtils.mapPossible(this.flags(), f -> f.stream().mapToInt(Message.Flag::getFlag).reduce(0, (left, right) -> left | right))).build();
        return MultipartRequest.ofRequestAndFiles((Object)json, Stream.concat(this.files().stream(), this.fileSpoilers().stream()).map(MessageCreateFields.File::asRequest).collect(Collectors.toList()));
    }
}

