/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.core.event.domain.interaction.ComponentInteractionEvent;
import discord4j.core.object.component.TopLevelMessageComponent;
import discord4j.core.spec.EmbedCreateSpec;
import discord4j.core.spec.InteractionApplicationCommandCallbackEditMonoGenerator;
import discord4j.core.spec.MessageCreateFields;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.AllowedMentions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;

public final class InteractionApplicationCommandCallbackEditMono
extends InteractionApplicationCommandCallbackEditMonoGenerator {
    private final String content_value;
    private final boolean content_absent;
    private final Boolean tts_value;
    private final boolean tts_absent;
    private final Boolean ephemeral_value;
    private final boolean ephemeral_absent;
    private final List<EmbedCreateSpec> embeds_value;
    private final boolean embeds_absent;
    private final List<MessageCreateFields.File> files;
    private final List<MessageCreateFields.FileSpoiler> fileSpoilers;
    private final AllowedMentions allowedMentions_value;
    private final boolean allowedMentions_absent;
    private final List<TopLevelMessageComponent> components_value;
    private final boolean components_absent;
    private final ComponentInteractionEvent event;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private InteractionApplicationCommandCallbackEditMono(ComponentInteractionEvent event) {
        this.event = Objects.requireNonNull(event, "event");
        Possible content$impl = Possible.absent();
        Possible tts$impl = Possible.absent();
        Possible ephemeral$impl = Possible.absent();
        Possible embeds$impl = Possible.absent();
        Possible allowedMentions$impl = Possible.absent();
        Possible components$impl = Possible.absent();
        this.content_value = content$impl.toOptional().orElse(null);
        this.content_absent = content$impl.isAbsent();
        this.tts_value = tts$impl.toOptional().orElse(null);
        this.tts_absent = tts$impl.isAbsent();
        this.ephemeral_value = ephemeral$impl.toOptional().orElse(null);
        this.ephemeral_absent = ephemeral$impl.isAbsent();
        this.embeds_value = embeds$impl.toOptional().orElse(null);
        this.embeds_absent = embeds$impl.isAbsent();
        this.allowedMentions_value = allowedMentions$impl.toOptional().orElse(null);
        this.allowedMentions_absent = allowedMentions$impl.isAbsent();
        this.components_value = components$impl.toOptional().orElse(null);
        this.components_absent = components$impl.isAbsent();
        this.files = this.initShim.files();
        this.fileSpoilers = this.initShim.fileSpoilers();
        this.initShim = null;
    }

    private InteractionApplicationCommandCallbackEditMono(Possible<String> content, Possible<Boolean> tts, Possible<Boolean> ephemeral, Possible<List<EmbedCreateSpec>> embeds, List<MessageCreateFields.File> files, List<MessageCreateFields.FileSpoiler> fileSpoilers, Possible<AllowedMentions> allowedMentions, Possible<List<TopLevelMessageComponent>> components, ComponentInteractionEvent event) {
        Possible<String> content$impl = content;
        Possible<Boolean> tts$impl = tts;
        Possible<Boolean> ephemeral$impl = ephemeral;
        Possible<List<EmbedCreateSpec>> embeds$impl = embeds;
        this.initShim.files(files);
        this.initShim.fileSpoilers(fileSpoilers);
        Possible<AllowedMentions> allowedMentions$impl = allowedMentions;
        Possible<List<TopLevelMessageComponent>> components$impl = components;
        this.event = event;
        this.content_value = content$impl.toOptional().orElse(null);
        this.content_absent = content$impl.isAbsent();
        this.tts_value = tts$impl.toOptional().orElse(null);
        this.tts_absent = tts$impl.isAbsent();
        this.ephemeral_value = ephemeral$impl.toOptional().orElse(null);
        this.ephemeral_absent = ephemeral$impl.isAbsent();
        this.embeds_value = embeds$impl.toOptional().orElse(null);
        this.embeds_absent = embeds$impl.isAbsent();
        this.allowedMentions_value = allowedMentions$impl.toOptional().orElse(null);
        this.allowedMentions_absent = allowedMentions$impl.isAbsent();
        this.components_value = components$impl.toOptional().orElse(null);
        this.components_absent = components$impl.isAbsent();
        this.files = this.initShim.files();
        this.fileSpoilers = this.initShim.fileSpoilers();
        this.initShim = null;
    }

    @Override
    public Possible<String> content() {
        return this.content_absent ? Possible.absent() : Possible.of((Object)this.content_value);
    }

    @Override
    public Possible<Boolean> tts() {
        return this.tts_absent ? Possible.absent() : Possible.of((Object)this.tts_value);
    }

    @Override
    public Possible<Boolean> ephemeral() {
        return this.ephemeral_absent ? Possible.absent() : Possible.of((Object)this.ephemeral_value);
    }

    @Override
    public Possible<List<EmbedCreateSpec>> embeds() {
        return this.embeds_absent ? Possible.absent() : Possible.of(this.embeds_value);
    }

    @Override
    public List<MessageCreateFields.File> files() {
        InitShim shim = this.initShim;
        return shim != null ? shim.files() : this.files;
    }

    @Override
    public List<MessageCreateFields.FileSpoiler> fileSpoilers() {
        InitShim shim = this.initShim;
        return shim != null ? shim.fileSpoilers() : this.fileSpoilers;
    }

    @Override
    public Possible<AllowedMentions> allowedMentions() {
        return this.allowedMentions_absent ? Possible.absent() : Possible.of((Object)this.allowedMentions_value);
    }

    @Override
    public Possible<List<TopLevelMessageComponent>> components() {
        return this.components_absent ? Possible.absent() : Possible.of(this.components_value);
    }

    @Override
    public ComponentInteractionEvent event() {
        return this.event;
    }

    public InteractionApplicationCommandCallbackEditMono withContent(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return new InteractionApplicationCommandCallbackEditMono(newValue, this.tts(), this.ephemeral(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.components(), this.event);
    }

    public InteractionApplicationCommandCallbackEditMono withContent(String value) {
        Possible newValue = Possible.of((Object)value);
        return new InteractionApplicationCommandCallbackEditMono((Possible<String>)newValue, this.tts(), this.ephemeral(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.components(), this.event);
    }

    public InteractionApplicationCommandCallbackEditMono withTts(Possible<Boolean> value) {
        Possible<Boolean> newValue = Objects.requireNonNull(value);
        return new InteractionApplicationCommandCallbackEditMono(this.content(), newValue, this.ephemeral(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.components(), this.event);
    }

    public InteractionApplicationCommandCallbackEditMono withTts(Boolean value) {
        Possible newValue = Possible.of((Object)value);
        return new InteractionApplicationCommandCallbackEditMono(this.content(), (Possible<Boolean>)newValue, this.ephemeral(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.components(), this.event);
    }

    public InteractionApplicationCommandCallbackEditMono withEphemeral(Possible<Boolean> value) {
        Possible<Boolean> newValue = Objects.requireNonNull(value);
        return new InteractionApplicationCommandCallbackEditMono(this.content(), this.tts(), newValue, this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.components(), this.event);
    }

    public InteractionApplicationCommandCallbackEditMono withEphemeral(Boolean value) {
        Possible newValue = Possible.of((Object)value);
        return new InteractionApplicationCommandCallbackEditMono(this.content(), this.tts(), (Possible<Boolean>)newValue, this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.components(), this.event);
    }

    public InteractionApplicationCommandCallbackEditMono withEmbeds(Possible<List<EmbedCreateSpec>> possible) {
        Possible<List<EmbedCreateSpec>> newValue = Objects.requireNonNull(possible);
        return new InteractionApplicationCommandCallbackEditMono(this.content(), this.tts(), this.ephemeral(), newValue, this.files, this.fileSpoilers, this.allowedMentions(), this.components(), this.event);
    }

    public InteractionApplicationCommandCallbackEditMono withEmbeds(Iterable<EmbedCreateSpec> elements) {
        Possible newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return new InteractionApplicationCommandCallbackEditMono(this.content(), this.tts(), this.ephemeral(), (Possible<List<EmbedCreateSpec>>)newValue, this.files, this.fileSpoilers, this.allowedMentions(), this.components(), this.event);
    }

    @SafeVarargs
    public final InteractionApplicationCommandCallbackEditMono withEmbeds(EmbedCreateSpec ... elements) {
        Possible newValue = Possible.of(Arrays.asList(elements));
        return new InteractionApplicationCommandCallbackEditMono(this.content(), this.tts(), this.ephemeral(), (Possible<List<EmbedCreateSpec>>)newValue, this.files, this.fileSpoilers, this.allowedMentions(), this.components(), this.event);
    }

    public final InteractionApplicationCommandCallbackEditMono withFiles(MessageCreateFields.File ... elements) {
        List<MessageCreateFields.File> newValue = InteractionApplicationCommandCallbackEditMono.createUnmodifiableList(false, InteractionApplicationCommandCallbackEditMono.createSafeList(Arrays.asList(elements), true, false));
        return new InteractionApplicationCommandCallbackEditMono(this.content(), this.tts(), this.ephemeral(), this.embeds(), newValue, this.fileSpoilers, this.allowedMentions(), this.components(), this.event);
    }

    public final InteractionApplicationCommandCallbackEditMono withFiles(Iterable<? extends MessageCreateFields.File> elements) {
        if (this.files == elements) {
            return this;
        }
        List<MessageCreateFields.File> newValue = InteractionApplicationCommandCallbackEditMono.createUnmodifiableList(false, InteractionApplicationCommandCallbackEditMono.createSafeList(elements, true, false));
        return new InteractionApplicationCommandCallbackEditMono(this.content(), this.tts(), this.ephemeral(), this.embeds(), newValue, this.fileSpoilers, this.allowedMentions(), this.components(), this.event);
    }

    public final InteractionApplicationCommandCallbackEditMono withFileSpoilers(MessageCreateFields.FileSpoiler ... elements) {
        List<MessageCreateFields.FileSpoiler> newValue = InteractionApplicationCommandCallbackEditMono.createUnmodifiableList(false, InteractionApplicationCommandCallbackEditMono.createSafeList(Arrays.asList(elements), true, false));
        return new InteractionApplicationCommandCallbackEditMono(this.content(), this.tts(), this.ephemeral(), this.embeds(), this.files, newValue, this.allowedMentions(), this.components(), this.event);
    }

    public final InteractionApplicationCommandCallbackEditMono withFileSpoilers(Iterable<? extends MessageCreateFields.FileSpoiler> elements) {
        if (this.fileSpoilers == elements) {
            return this;
        }
        List<MessageCreateFields.FileSpoiler> newValue = InteractionApplicationCommandCallbackEditMono.createUnmodifiableList(false, InteractionApplicationCommandCallbackEditMono.createSafeList(elements, true, false));
        return new InteractionApplicationCommandCallbackEditMono(this.content(), this.tts(), this.ephemeral(), this.embeds(), this.files, newValue, this.allowedMentions(), this.components(), this.event);
    }

    public InteractionApplicationCommandCallbackEditMono withAllowedMentions(Possible<AllowedMentions> value) {
        Possible<AllowedMentions> newValue = Objects.requireNonNull(value);
        return new InteractionApplicationCommandCallbackEditMono(this.content(), this.tts(), this.ephemeral(), this.embeds(), this.files, this.fileSpoilers, newValue, this.components(), this.event);
    }

    public InteractionApplicationCommandCallbackEditMono withAllowedMentions(AllowedMentions value) {
        Possible newValue = Possible.of((Object)value);
        return new InteractionApplicationCommandCallbackEditMono(this.content(), this.tts(), this.ephemeral(), this.embeds(), this.files, this.fileSpoilers, (Possible<AllowedMentions>)newValue, this.components(), this.event);
    }

    public InteractionApplicationCommandCallbackEditMono withComponents(Possible<List<TopLevelMessageComponent>> possible) {
        Possible<List<TopLevelMessageComponent>> newValue = Objects.requireNonNull(possible);
        return new InteractionApplicationCommandCallbackEditMono(this.content(), this.tts(), this.ephemeral(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), newValue, this.event);
    }

    public InteractionApplicationCommandCallbackEditMono withComponents(Iterable<TopLevelMessageComponent> elements) {
        Possible newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return new InteractionApplicationCommandCallbackEditMono(this.content(), this.tts(), this.ephemeral(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), (Possible<List<TopLevelMessageComponent>>)newValue, this.event);
    }

    @SafeVarargs
    public final InteractionApplicationCommandCallbackEditMono withComponents(TopLevelMessageComponent ... elements) {
        Possible newValue = Possible.of(Arrays.asList(elements));
        return new InteractionApplicationCommandCallbackEditMono(this.content(), this.tts(), this.ephemeral(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), (Possible<List<TopLevelMessageComponent>>)newValue, this.event);
    }

    public final InteractionApplicationCommandCallbackEditMono withEvent(ComponentInteractionEvent value) {
        if (this.event == value) {
            return this;
        }
        ComponentInteractionEvent newValue = Objects.requireNonNull(value, "event");
        return new InteractionApplicationCommandCallbackEditMono(this.content(), this.tts(), this.ephemeral(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.components(), newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof InteractionApplicationCommandCallbackEditMono && this.equalTo(0, (InteractionApplicationCommandCallbackEditMono)another);
    }

    private boolean equalTo(int synthetic, InteractionApplicationCommandCallbackEditMono another) {
        return this.content().equals(another.content()) && this.tts().equals(another.tts()) && this.ephemeral().equals(another.ephemeral()) && Objects.equals(this.embeds_value, another.embeds_value) && this.files.equals(another.files) && this.fileSpoilers.equals(another.fileSpoilers) && this.allowedMentions().equals(another.allowedMentions()) && Objects.equals(this.components_value, another.components_value) && this.event.equals(another.event);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.content().hashCode();
        h += (h << 5) + this.tts().hashCode();
        h += (h << 5) + this.ephemeral().hashCode();
        h += (h << 5) + Objects.hashCode(this.embeds_value);
        h += (h << 5) + this.files.hashCode();
        h += (h << 5) + this.fileSpoilers.hashCode();
        h += (h << 5) + this.allowedMentions().hashCode();
        h += (h << 5) + Objects.hashCode(this.components_value);
        h += (h << 5) + this.event.hashCode();
        return h;
    }

    @Override
    public String toString() {
        return "InteractionApplicationCommandCallbackEditMono{content=" + this.content().toString() + ", tts=" + this.tts().toString() + ", ephemeral=" + this.ephemeral().toString() + ", embeds=" + Objects.toString(this.embeds_value) + ", files=" + this.files + ", fileSpoilers=" + this.fileSpoilers + ", allowedMentions=" + this.allowedMentions().toString() + ", components=" + Objects.toString(this.components_value) + ", event=" + this.event + "}";
    }

    public static InteractionApplicationCommandCallbackEditMono of(ComponentInteractionEvent event) {
        return new InteractionApplicationCommandCallbackEditMono(event);
    }

    static InteractionApplicationCommandCallbackEditMono copyOf(InteractionApplicationCommandCallbackEditMonoGenerator instance) {
        if (instance instanceof InteractionApplicationCommandCallbackEditMono) {
            return (InteractionApplicationCommandCallbackEditMono)instance;
        }
        return InteractionApplicationCommandCallbackEditMono.of(instance.event()).withContent((Possible<String>)instance.content()).withTts((Possible<Boolean>)instance.tts()).withEphemeral((Possible<Boolean>)instance.ephemeral()).withEmbeds((Possible<List<EmbedCreateSpec>>)instance.embeds()).withFiles(instance.files()).withFileSpoilers(instance.fileSpoilers()).withAllowedMentions((Possible<AllowedMentions>)instance.allowedMentions()).withComponents((Possible<List<TopLevelMessageComponent>>)instance.components());
    }

    public boolean isContentPresent() {
        return !this.content_absent;
    }

    public String contentOrElse(String defaultValue) {
        return !this.content_absent ? this.content_value : defaultValue;
    }

    public boolean isTtsPresent() {
        return !this.tts_absent;
    }

    public Boolean ttsOrElse(Boolean defaultValue) {
        return !this.tts_absent ? this.tts_value : defaultValue;
    }

    public boolean isEphemeralPresent() {
        return !this.ephemeral_absent;
    }

    public Boolean ephemeralOrElse(Boolean defaultValue) {
        return !this.ephemeral_absent ? this.ephemeral_value : defaultValue;
    }

    public boolean isEmbedsPresent() {
        return !this.embeds_absent;
    }

    public List<EmbedCreateSpec> embedsOrElse(List<EmbedCreateSpec> defaultValue) {
        return !this.embeds_absent ? this.embeds_value : defaultValue;
    }

    public boolean isAllowedMentionsPresent() {
        return !this.allowedMentions_absent;
    }

    public AllowedMentions allowedMentionsOrElse(AllowedMentions defaultValue) {
        return !this.allowedMentions_absent ? this.allowedMentions_value : defaultValue;
    }

    public boolean isComponentsPresent() {
        return !this.components_absent;
    }

    public List<TopLevelMessageComponent> componentsOrElse(List<TopLevelMessageComponent> defaultValue) {
        return !this.components_absent ? this.components_value : defaultValue;
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private final class InitShim {
        private byte filesBuildStage = 0;
        private List<MessageCreateFields.File> files;
        private byte fileSpoilersBuildStage = 0;
        private List<MessageCreateFields.FileSpoiler> fileSpoilers;

        private InitShim() {
        }

        List<MessageCreateFields.File> files() {
            if (this.filesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.filesBuildStage == 0) {
                this.filesBuildStage = (byte)-1;
                this.files = InteractionApplicationCommandCallbackEditMono.createUnmodifiableList(false, InteractionApplicationCommandCallbackEditMono.createSafeList(InteractionApplicationCommandCallbackEditMono.super.files(), true, false));
                this.filesBuildStage = 1;
            }
            return this.files;
        }

        void files(List<MessageCreateFields.File> files) {
            this.files = files;
            this.filesBuildStage = 1;
        }

        List<MessageCreateFields.FileSpoiler> fileSpoilers() {
            if (this.fileSpoilersBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.fileSpoilersBuildStage == 0) {
                this.fileSpoilersBuildStage = (byte)-1;
                this.fileSpoilers = InteractionApplicationCommandCallbackEditMono.createUnmodifiableList(false, InteractionApplicationCommandCallbackEditMono.createSafeList(InteractionApplicationCommandCallbackEditMono.super.fileSpoilers(), true, false));
                this.fileSpoilersBuildStage = 1;
            }
            return this.fileSpoilers;
        }

        void fileSpoilers(List<MessageCreateFields.FileSpoiler> fileSpoilers) {
            this.fileSpoilers = fileSpoilers;
            this.fileSpoilersBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.filesBuildStage == -1) {
                attributes.add("files");
            }
            if (this.fileSpoilersBuildStage == -1) {
                attributes.add("fileSpoilers");
            }
            return "Cannot build InteractionApplicationCommandCallbackEditMono, attribute initializers form cycle " + attributes;
        }
    }
}

