/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.core.spec.GuildStickerEditSpecGenerator;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;

public final class GuildStickerEditSpec
implements GuildStickerEditSpecGenerator {
    @reactor.util.annotation.Nullable
    private final String reason;
    private final String name_value;
    private final boolean name_absent;
    private final String description_value;
    private final boolean description_absent;
    private final String tags_value;
    private final boolean tags_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final GuildStickerEditSpec INSTANCE = GuildStickerEditSpec.validate(new GuildStickerEditSpec());

    private GuildStickerEditSpec() {
        this.reason = null;
        Possible name$impl = Possible.absent();
        Possible description$impl = Possible.absent();
        Possible tags$impl = Possible.absent();
        this.name_value = name$impl.toOptional().orElse(null);
        this.name_absent = name$impl.isAbsent();
        this.description_value = description$impl.toOptional().orElse(null);
        this.description_absent = description$impl.isAbsent();
        this.tags_value = tags$impl.toOptional().orElse(null);
        this.tags_absent = tags$impl.isAbsent();
        this.initShim = null;
    }

    private GuildStickerEditSpec(@reactor.util.annotation.Nullable String reason, Possible<String> name, Possible<String> description, Possible<String> tags) {
        this.reason = reason;
        Possible<String> name$impl = name;
        Possible<String> description$impl = description;
        Possible<String> tags$impl = tags;
        this.name_value = name$impl.toOptional().orElse(null);
        this.name_absent = name$impl.isAbsent();
        this.description_value = description$impl.toOptional().orElse(null);
        this.description_absent = description$impl.isAbsent();
        this.tags_value = tags$impl.toOptional().orElse(null);
        this.tags_absent = tags$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @reactor.util.annotation.Nullable
    public String reason() {
        return this.reason;
    }

    @Override
    public Possible<String> name() {
        return this.name_absent ? Possible.absent() : Possible.of((Object)this.name_value);
    }

    @Override
    public Possible<String> description() {
        return this.description_absent ? Possible.absent() : Possible.of((Object)this.description_value);
    }

    @Override
    public Possible<String> tags() {
        return this.tags_absent ? Possible.absent() : Possible.of((Object)this.tags_value);
    }

    public final GuildStickerEditSpec withReason(@reactor.util.annotation.Nullable String value) {
        if (Objects.equals(this.reason, value)) {
            return this;
        }
        return GuildStickerEditSpec.validate(new GuildStickerEditSpec(value, this.name(), this.description(), this.tags()));
    }

    public GuildStickerEditSpec withName(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return GuildStickerEditSpec.validate(new GuildStickerEditSpec(this.reason, newValue, this.description(), this.tags()));
    }

    public GuildStickerEditSpec withName(String value) {
        Possible newValue = Possible.of((Object)value);
        return GuildStickerEditSpec.validate(new GuildStickerEditSpec(this.reason, (Possible<String>)newValue, this.description(), this.tags()));
    }

    public GuildStickerEditSpec withDescription(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return GuildStickerEditSpec.validate(new GuildStickerEditSpec(this.reason, this.name(), newValue, this.tags()));
    }

    public GuildStickerEditSpec withDescription(String value) {
        Possible newValue = Possible.of((Object)value);
        return GuildStickerEditSpec.validate(new GuildStickerEditSpec(this.reason, this.name(), (Possible<String>)newValue, this.tags()));
    }

    public GuildStickerEditSpec withTags(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return GuildStickerEditSpec.validate(new GuildStickerEditSpec(this.reason, this.name(), this.description(), newValue));
    }

    public GuildStickerEditSpec withTags(String value) {
        Possible newValue = Possible.of((Object)value);
        return GuildStickerEditSpec.validate(new GuildStickerEditSpec(this.reason, this.name(), this.description(), (Possible<String>)newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof GuildStickerEditSpec && this.equalTo(0, (GuildStickerEditSpec)another);
    }

    private boolean equalTo(int synthetic, GuildStickerEditSpec another) {
        return Objects.equals(this.reason, another.reason) && this.name().equals(another.name()) && this.description().equals(another.description()) && this.tags().equals(another.tags());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.reason);
        h += (h << 5) + this.name().hashCode();
        h += (h << 5) + this.description().hashCode();
        h += (h << 5) + this.tags().hashCode();
        return h;
    }

    public String toString() {
        return "GuildStickerEditSpec{reason=" + this.reason + ", name=" + this.name().toString() + ", description=" + this.description().toString() + ", tags=" + this.tags().toString() + "}";
    }

    public static GuildStickerEditSpec create() {
        return INSTANCE;
    }

    private static GuildStickerEditSpec validate(GuildStickerEditSpec instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    static GuildStickerEditSpec copyOf(GuildStickerEditSpecGenerator instance) {
        if (instance instanceof GuildStickerEditSpec) {
            return (GuildStickerEditSpec)instance;
        }
        return GuildStickerEditSpec.builder().from(instance).build();
    }

    public boolean isNamePresent() {
        return !this.name_absent;
    }

    public String nameOrElse(String defaultValue) {
        return !this.name_absent ? this.name_value : defaultValue;
    }

    public boolean isDescriptionPresent() {
        return !this.description_absent;
    }

    public String descriptionOrElse(String defaultValue) {
        return !this.description_absent ? this.description_value : defaultValue;
    }

    public boolean isTagsPresent() {
        return !this.tags_absent;
    }

    public String tagsOrElse(String defaultValue) {
        return !this.tags_absent ? this.tags_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Possible<String> name_possible = Possible.absent();
        private Possible<String> description_possible = Possible.absent();
        private Possible<String> tags_possible = Possible.absent();
        @Nullable
        private String reason;

        private Builder() {
        }

        public final Builder from(GuildStickerEditSpec instance) {
            return this.from((GuildStickerEditSpecGenerator)instance);
        }

        final Builder from(GuildStickerEditSpecGenerator instance) {
            Objects.requireNonNull(instance, "instance");
            String reasonValue = instance.reason();
            if (reasonValue != null) {
                this.reason(reasonValue);
            }
            this.name(instance.name());
            this.description(instance.description());
            this.tags(instance.tags());
            return this;
        }

        public final Builder reason(@reactor.util.annotation.Nullable String reason) {
            this.reason = reason;
            return this;
        }

        public Builder name(Possible<String> value) {
            this.name_possible = value;
            return this;
        }

        public Builder name(String value) {
            this.name_possible = Possible.of((Object)value);
            return this;
        }

        public Builder description(Possible<String> value) {
            this.description_possible = value;
            return this;
        }

        public Builder description(String value) {
            this.description_possible = Possible.of((Object)value);
            return this;
        }

        public Builder tags(Possible<String> value) {
            this.tags_possible = value;
            return this;
        }

        public Builder tags(String value) {
            this.tags_possible = Possible.of((Object)value);
            return this;
        }

        public GuildStickerEditSpec build() {
            return GuildStickerEditSpec.validate(new GuildStickerEditSpec(this.reason, this.name_build(), this.description_build(), this.tags_build()));
        }

        private Possible<String> name_build() {
            return this.name_possible;
        }

        private Possible<String> description_build() {
            return this.description_possible;
        }

        private Possible<String> tags_build() {
            return this.tags_possible;
        }
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build GuildStickerEditSpec, attribute initializers form cycle " + attributes;
        }
    }
}

