/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.core.object.GuildTemplate;
import discord4j.core.spec.GuildCreateFromTemplateMonoGenerator;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.Image;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;

public final class GuildCreateFromTemplateMono
extends GuildCreateFromTemplateMonoGenerator {
    private final String name;
    private final Image icon_value;
    private final boolean icon_absent;
    private final GuildTemplate guildTemplate;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private GuildCreateFromTemplateMono(String name, GuildTemplate guildTemplate) {
        this.name = Objects.requireNonNull(name, "name");
        this.guildTemplate = Objects.requireNonNull(guildTemplate, "guildTemplate");
        Possible icon$impl = Possible.absent();
        this.icon_value = icon$impl.toOptional().orElse(null);
        this.icon_absent = icon$impl.isAbsent();
        this.initShim = null;
    }

    private GuildCreateFromTemplateMono(String name, Possible<Image> icon, GuildTemplate guildTemplate) {
        this.name = name;
        Possible<Image> icon$impl = icon;
        this.guildTemplate = guildTemplate;
        this.icon_value = icon$impl.toOptional().orElse(null);
        this.icon_absent = icon$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Possible<Image> icon() {
        return this.icon_absent ? Possible.absent() : Possible.of((Object)this.icon_value);
    }

    @Override
    public GuildTemplate guildTemplate() {
        return this.guildTemplate;
    }

    public final GuildCreateFromTemplateMono withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new GuildCreateFromTemplateMono(newValue, this.icon(), this.guildTemplate);
    }

    public GuildCreateFromTemplateMono withIcon(Possible<Image> value) {
        Possible<Image> newValue = Objects.requireNonNull(value);
        return new GuildCreateFromTemplateMono(this.name, newValue, this.guildTemplate);
    }

    public GuildCreateFromTemplateMono withIcon(Image value) {
        Possible newValue = Possible.of((Object)value);
        return new GuildCreateFromTemplateMono(this.name, (Possible<Image>)newValue, this.guildTemplate);
    }

    public final GuildCreateFromTemplateMono withGuildTemplate(GuildTemplate value) {
        if (this.guildTemplate == value) {
            return this;
        }
        GuildTemplate newValue = Objects.requireNonNull(value, "guildTemplate");
        return new GuildCreateFromTemplateMono(this.name, this.icon(), newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof GuildCreateFromTemplateMono && this.equalTo(0, (GuildCreateFromTemplateMono)another);
    }

    private boolean equalTo(int synthetic, GuildCreateFromTemplateMono another) {
        return this.name.equals(another.name) && this.icon().equals(another.icon()) && this.guildTemplate.equals(another.guildTemplate);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.icon().hashCode();
        h += (h << 5) + this.guildTemplate.hashCode();
        return h;
    }

    @Override
    public String toString() {
        return "GuildCreateFromTemplateMono{name=" + this.name + ", icon=" + this.icon().toString() + ", guildTemplate=" + this.guildTemplate + "}";
    }

    public static GuildCreateFromTemplateMono of(String name, GuildTemplate guildTemplate) {
        return new GuildCreateFromTemplateMono(name, guildTemplate);
    }

    static GuildCreateFromTemplateMono copyOf(GuildCreateFromTemplateMonoGenerator instance) {
        if (instance instanceof GuildCreateFromTemplateMono) {
            return (GuildCreateFromTemplateMono)instance;
        }
        return GuildCreateFromTemplateMono.of(instance.name(), instance.guildTemplate()).withIcon((Possible<Image>)instance.icon());
    }

    public boolean isIconPresent() {
        return !this.icon_absent;
    }

    public Image iconOrElse(Image defaultValue) {
        return !this.icon_absent ? this.icon_value : defaultValue;
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build GuildCreateFromTemplateMono, attribute initializers form cycle " + attributes;
        }
    }
}

