/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.retriever;

import discord4j.common.util.Snowflake;
import discord4j.core.object.ScheduledEventUser;
import discord4j.core.object.VoiceState;
import discord4j.core.object.automod.AutoModRule;
import discord4j.core.object.entity.Guild;
import discord4j.core.object.entity.GuildEmoji;
import discord4j.core.object.entity.GuildSticker;
import discord4j.core.object.entity.Member;
import discord4j.core.object.entity.Message;
import discord4j.core.object.entity.Role;
import discord4j.core.object.entity.ScheduledEvent;
import discord4j.core.object.entity.User;
import discord4j.core.object.entity.channel.Channel;
import discord4j.core.object.entity.channel.GuildChannel;
import discord4j.core.retriever.EntityRetriever;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class FallbackEntityRetriever
implements EntityRetriever {
    private final EntityRetriever first;
    private final EntityRetriever fallback;

    public FallbackEntityRetriever(EntityRetriever first, EntityRetriever fallback) {
        this.first = first;
        this.fallback = fallback;
    }

    @Override
    public Mono<Channel> getChannelById(Snowflake channelId) {
        return this.first.getChannelById(channelId).switchIfEmpty(this.fallback.getChannelById(channelId));
    }

    @Override
    public Mono<Guild> getGuildById(Snowflake guildId) {
        return this.first.getGuildById(guildId).switchIfEmpty(this.fallback.getGuildById(guildId));
    }

    @Override
    public Mono<GuildSticker> getGuildStickerById(Snowflake guildId, Snowflake stickerId) {
        return this.first.getGuildStickerById(guildId, stickerId).switchIfEmpty(this.fallback.getGuildStickerById(guildId, stickerId));
    }

    @Override
    public Mono<GuildEmoji> getGuildEmojiById(Snowflake guildId, Snowflake emojiId) {
        return this.first.getGuildEmojiById(guildId, emojiId).switchIfEmpty(this.fallback.getGuildEmojiById(guildId, emojiId));
    }

    @Override
    public Mono<Member> getMemberById(Snowflake guildId, Snowflake userId) {
        return this.first.getMemberById(guildId, userId).switchIfEmpty(this.fallback.getMemberById(guildId, userId));
    }

    @Override
    public Mono<Message> getMessageById(Snowflake channelId, Snowflake messageId) {
        return this.first.getMessageById(channelId, messageId).switchIfEmpty(this.fallback.getMessageById(channelId, messageId));
    }

    @Override
    public Mono<Role> getRoleById(Snowflake guildId, Snowflake roleId) {
        return this.first.getRoleById(guildId, roleId).switchIfEmpty(this.fallback.getRoleById(guildId, roleId));
    }

    @Override
    public Mono<User> getUserById(Snowflake userId) {
        return this.first.getUserById(userId).switchIfEmpty(this.fallback.getUserById(userId));
    }

    @Override
    public Flux<Guild> getGuilds() {
        return this.first.getGuilds().switchIfEmpty(this.fallback.getGuilds());
    }

    @Override
    public Mono<User> getSelf() {
        return this.first.getSelf().switchIfEmpty(this.fallback.getSelf());
    }

    @Override
    public Mono<Member> getSelfMember(Snowflake guildId) {
        return this.first.getSelfMember(guildId).switchIfEmpty(this.fallback.getSelfMember(guildId));
    }

    @Override
    public Flux<Member> getGuildMembers(Snowflake guildId) {
        return this.first.getGuildMembers(guildId).switchIfEmpty(this.fallback.getGuildMembers(guildId));
    }

    @Override
    public Flux<GuildChannel> getGuildChannels(Snowflake guildId) {
        return this.first.getGuildChannels(guildId).switchIfEmpty(this.fallback.getGuildChannels(guildId));
    }

    @Override
    public Flux<Role> getGuildRoles(Snowflake guildId) {
        return this.first.getGuildRoles(guildId).switchIfEmpty(this.fallback.getGuildRoles(guildId));
    }

    @Override
    public Flux<GuildEmoji> getGuildEmojis(Snowflake guildId) {
        return this.first.getGuildEmojis(guildId).switchIfEmpty(this.fallback.getGuildEmojis(guildId));
    }

    @Override
    public Flux<GuildSticker> getGuildStickers(Snowflake guildId) {
        return this.first.getGuildStickers(guildId).switchIfEmpty(this.fallback.getGuildStickers(guildId));
    }

    @Override
    public Flux<AutoModRule> getGuildAutoModRules(Snowflake guildId) {
        return this.first.getGuildAutoModRules(guildId).switchIfEmpty(this.fallback.getGuildAutoModRules(guildId));
    }

    @Override
    public Mono<ScheduledEvent> getScheduledEventById(Snowflake guildId, Snowflake eventId) {
        return this.first.getScheduledEventById(guildId, eventId).switchIfEmpty(this.fallback.getScheduledEventById(guildId, eventId));
    }

    @Override
    public Flux<ScheduledEvent> getScheduledEvents(Snowflake guildId) {
        return this.first.getScheduledEvents(guildId).switchIfEmpty(this.fallback.getScheduledEvents(guildId));
    }

    @Override
    public Flux<ScheduledEventUser> getScheduledEventUsers(Snowflake guildId, Snowflake eventId) {
        return this.first.getScheduledEventUsers(guildId, eventId).switchIfEmpty(this.fallback.getScheduledEventUsers(guildId, eventId));
    }

    @Override
    public Mono<VoiceState> getVoiceStateById(Snowflake guildId, Snowflake userId) {
        return this.first.getVoiceStateById(guildId, userId);
    }
}

