/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.entity.poll;

import discord4j.core.object.entity.poll.PollAnswerCount;
import discord4j.discordjson.json.PollResultObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class PollResult {
    private final PollResultObject data;
    private final List<PollAnswerCount> answerCount;
    private final Map<Integer, PollAnswerCount> answerCountById;

    PollResult(PollResultObject data) {
        this.data = data;
        this.answerCount = data.answerCounts().stream().map(PollAnswerCount::new).collect(Collectors.toList());
        this.answerCountById = this.answerCount.stream().collect(Collectors.toMap(PollAnswerCount::getAnswerId, count -> count));
    }

    public PollResultObject getData() {
        return this.data;
    }

    public boolean isFinalized() {
        return this.data.isFinalized();
    }

    public List<PollAnswerCount> getAnswerCount() {
        return this.answerCount;
    }

    public Optional<Integer> getAnswerCountById(int answerId) {
        return Optional.ofNullable(this.answerCountById.get(answerId)).map(PollAnswerCount::getCount);
    }
}

