/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.entity.poll;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.entity.Entity;
import discord4j.core.object.entity.poll.PollAnswer;
import discord4j.core.object.entity.poll.PollQuestion;
import discord4j.core.object.entity.poll.PollResult;
import discord4j.core.spec.PollVotersRequestFlux;
import discord4j.discordjson.json.PollData;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

public class Poll
implements Entity {
    private final GatewayDiscordClient gateway;
    private final PollData data;
    private final Snowflake channelId;
    private final Snowflake messageId;
    private final PollQuestion question;
    private final List<PollAnswer> answers;
    private final Map<Integer, PollAnswer> pollAnswerById;

    public Poll(GatewayDiscordClient gateway, PollData data, long channelId, long messageId) {
        this.gateway = gateway;
        this.data = data;
        this.channelId = Snowflake.of((long)channelId);
        this.messageId = Snowflake.of((long)messageId);
        this.question = new PollQuestion(data.question());
        this.answers = data.answers().stream().map(PollAnswer::new).collect(Collectors.toList());
        this.pollAnswerById = this.answers.stream().collect(Collectors.toMap(PollAnswer::getAnswerId, answer -> answer));
    }

    public PollQuestion getQuestion() {
        return this.question;
    }

    public List<PollAnswer> getAnswers() {
        return this.answers;
    }

    public Optional<Instant> getExpiry() {
        return this.data.expiry().map(date -> DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse((CharSequence)date, Instant::from));
    }

    public boolean allowMultiselect() {
        return this.data.allowMultiselect();
    }

    public PollLayoutType getLayoutType() {
        return PollLayoutType.from(this.data.layoutType());
    }

    public Optional<PollResult> getResults() {
        return this.data.results().toOptional().map(PollResult::new);
    }

    public Mono<PollResult> getLatestResults() {
        return this.gateway.getRestClient().getMessageById(this.channelId, this.messageId).getData().map(messageData -> messageData.poll().toOptional().flatMap(pollData -> pollData.results().toOptional())).flatMap(Mono::justOrEmpty).map(PollResult::new);
    }

    public Mono<Poll> end() {
        return this.gateway.getRestClient().getPollService().endPoll(this.channelId.asLong(), this.messageId.asLong()).map(messageData -> new Poll(this.gateway, (PollData)messageData.poll().get(), this.channelId.asLong(), this.messageId.asLong()));
    }

    public PollVotersRequestFlux getVoters(int answerId) {
        return PollVotersRequestFlux.of(this.gateway, this.gateway.rest(), this.channelId, this.messageId, answerId);
    }

    public PollData getData() {
        return this.data;
    }

    @Override
    public Snowflake getId() {
        return this.messageId;
    }

    @Override
    public GatewayDiscordClient getClient() {
        return this.gateway;
    }

    public Optional<PollAnswer> getAnswerById(int answerId) {
        return Optional.ofNullable(this.pollAnswerById.get(answerId));
    }

    public String toString() {
        return "Poll{data=" + this.data + ", messageId=" + this.messageId + ", channelId=" + this.channelId + '}';
    }

    public static enum PollLayoutType {
        UNKNOWN(-1),
        DEFAULT(1);

        private final int value;

        private PollLayoutType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static PollLayoutType from(int value) {
            switch (value) {
                case 1: {
                    return DEFAULT;
                }
            }
            return UNKNOWN;
        }
    }
}

