/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.component;

import discord4j.core.object.component.ActionRow;
import discord4j.core.object.component.BaseMessageComponent;
import discord4j.core.object.component.Button;
import discord4j.core.object.component.Container;
import discord4j.core.object.component.File;
import discord4j.core.object.component.MediaGallery;
import discord4j.core.object.component.Section;
import discord4j.core.object.component.SelectMenu;
import discord4j.core.object.component.Separator;
import discord4j.core.object.component.TextDisplay;
import discord4j.core.object.component.TextInput;
import discord4j.core.object.component.Thumbnail;
import discord4j.discordjson.json.ComponentData;
import discord4j.discordjson.json.ImmutableComponentData;
import reactor.util.Logger;
import reactor.util.Loggers;

public class MessageComponent
implements BaseMessageComponent {
    private static final Logger LOGGER = Loggers.getLogger(MessageComponent.class);
    private final ComponentData data;

    static ImmutableComponentData.Builder getBuilder(Type type) {
        return ImmutableComponentData.builder().type(type.getValue());
    }

    public static MessageComponent fromData(ComponentData data) {
        switch (Type.of(data.type())) {
            case CONTAINER: {
                return new Container(data);
            }
            case SECTION: {
                return new Section(data);
            }
            case SEPARATOR: {
                return new Separator(data);
            }
            case ACTION_ROW: {
                return new ActionRow(data);
            }
            case TEXT_DISPLAY: {
                return new TextDisplay(data);
            }
            case THUMBNAIL: {
                return new Thumbnail(data);
            }
            case MEDIA_GALLERY: {
                return new MediaGallery(data);
            }
            case FILE: {
                return new File(data);
            }
            case BUTTON: {
                return new Button(data);
            }
            case SELECT_MENU_ROLE: 
            case SELECT_MENU_CHANNEL: 
            case SELECT_MENU_MENTIONABLE: 
            case SELECT_MENU_USER: 
            case SELECT_MENU: {
                return new SelectMenu(data);
            }
            case TEXT_INPUT: {
                return new TextInput(data);
            }
        }
        LOGGER.warn("Unhandled component type: " + data.type());
        return new MessageComponent(data);
    }

    MessageComponent(ComponentData data) {
        this.data = data;
    }

    @Override
    public int getId() {
        return (Integer)this.data.id().toOptional().orElseThrow(IllegalStateException::new);
    }

    @Override
    public ComponentData getData() {
        return this.data;
    }

    @Override
    public Type getType() {
        return Type.of(this.data.type());
    }

    public static enum Type {
        UNKNOWN(-1),
        ACTION_ROW(1),
        BUTTON(2),
        SELECT_MENU(3),
        TEXT_INPUT(4),
        SELECT_MENU_USER(5),
        SELECT_MENU_ROLE(6),
        SELECT_MENU_MENTIONABLE(7),
        SELECT_MENU_CHANNEL(8),
        SECTION(9, true),
        TEXT_DISPLAY(10, true),
        THUMBNAIL(11, true),
        MEDIA_GALLERY(12, true),
        FILE(13, true),
        SEPARATOR(14, true),
        CONTAINER(17, true);

        private final int value;
        private final boolean requireFlag;

        private Type(int value) {
            this(value, false);
        }

        private Type(int value, boolean requireFlag) {
            this.value = value;
            this.requireFlag = requireFlag;
        }

        public boolean isRequiredFlag() {
            return this.requireFlag;
        }

        public int getValue() {
            return this.value;
        }

        public static Type of(int value) {
            switch (value) {
                case 1: {
                    return ACTION_ROW;
                }
                case 2: {
                    return BUTTON;
                }
                case 3: {
                    return SELECT_MENU;
                }
                case 4: {
                    return TEXT_INPUT;
                }
                case 5: {
                    return SELECT_MENU_USER;
                }
                case 6: {
                    return SELECT_MENU_ROLE;
                }
                case 7: {
                    return SELECT_MENU_MENTIONABLE;
                }
                case 8: {
                    return SELECT_MENU_CHANNEL;
                }
                case 9: {
                    return SECTION;
                }
                case 10: {
                    return TEXT_DISPLAY;
                }
                case 11: {
                    return THUMBNAIL;
                }
                case 12: {
                    return MEDIA_GALLERY;
                }
                case 13: {
                    return FILE;
                }
                case 14: {
                    return SEPARATOR;
                }
                case 17: {
                    return CONTAINER;
                }
            }
            return UNKNOWN;
        }
    }
}

