/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.component;

import discord4j.common.util.Snowflake;
import discord4j.core.object.component.ActionComponent;
import discord4j.core.object.component.IAccessoryComponent;
import discord4j.core.object.component.MessageComponent;
import discord4j.core.object.reaction.ReactionEmoji;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.ComponentData;
import discord4j.discordjson.json.ImmutableComponentData;
import discord4j.discordjson.possible.Possible;
import java.util.Optional;
import reactor.util.annotation.Nullable;

public class Button
extends ActionComponent
implements IAccessoryComponent {
    public static Button primary(String customId, String label) {
        return Button.of(Style.PRIMARY, customId, null, label, null, null);
    }

    public static Button primary(String customId, ReactionEmoji emoji) {
        return Button.of(Style.PRIMARY, customId, emoji, null, null, null);
    }

    public static Button primary(String customId, ReactionEmoji emoji, String label) {
        return Button.of(Style.PRIMARY, customId, emoji, label, null, null);
    }

    public static Button secondary(String customId, String label) {
        return Button.of(Style.SECONDARY, customId, null, label, null, null);
    }

    public static Button secondary(String customId, ReactionEmoji emoji) {
        return Button.of(Style.SECONDARY, customId, emoji, null, null, null);
    }

    public static Button secondary(String customId, ReactionEmoji emoji, String label) {
        return Button.of(Style.SECONDARY, customId, emoji, label, null, null);
    }

    public static Button success(String customId, String label) {
        return Button.of(Style.SUCCESS, customId, null, label, null, null);
    }

    public static Button success(String customId, ReactionEmoji emoji) {
        return Button.of(Style.SUCCESS, customId, emoji, null, null, null);
    }

    public static Button success(String customId, ReactionEmoji emoji, String label) {
        return Button.of(Style.SUCCESS, customId, emoji, label, null, null);
    }

    public static Button danger(String customId, String label) {
        return Button.of(Style.DANGER, customId, null, label, null, null);
    }

    public static Button danger(String customId, ReactionEmoji emoji) {
        return Button.of(Style.DANGER, customId, emoji, null, null, null);
    }

    public static Button danger(String customId, ReactionEmoji emoji, String label) {
        return Button.of(Style.DANGER, customId, emoji, label, null, null);
    }

    public static Button link(String url, String label) {
        return Button.of(Style.LINK, null, null, label, url, null);
    }

    public static Button link(String url, ReactionEmoji emoji) {
        return Button.of(Style.LINK, null, emoji, null, url, null);
    }

    public static Button link(String url, ReactionEmoji emoji, String label) {
        return Button.of(Style.LINK, null, emoji, label, url, null);
    }

    public static Button premium(Snowflake skuId) {
        return Button.of(Style.PREMIUM, null, null, null, null, skuId.asString());
    }

    private static Button of(Style style, @Nullable String customId, @Nullable ReactionEmoji emoji, @Nullable String label, @Nullable String url, @Nullable String skuId) {
        ImmutableComponentData.Builder builder = ComponentData.builder().type(MessageComponent.Type.BUTTON.getValue()).style(Integer.valueOf(style.getValue()));
        if (customId != null) {
            builder.customId(customId);
        }
        if (emoji != null) {
            builder.emoji(emoji.asEmojiData());
        }
        if (label != null) {
            builder.label(label);
        }
        if (url != null) {
            builder.url(url);
        }
        if (skuId != null) {
            builder.skuId(skuId);
        }
        return new Button((ComponentData)builder.build());
    }

    public static Button primary(int id, String customId, String label) {
        return Button.of(id, Style.PRIMARY, customId, null, label, null, null);
    }

    public static Button primary(int id, String customId, ReactionEmoji emoji) {
        return Button.of(id, Style.PRIMARY, customId, emoji, null, null, null);
    }

    public static Button primary(int id, String customId, ReactionEmoji emoji, String label) {
        return Button.of(id, Style.PRIMARY, customId, emoji, label, null, null);
    }

    public static Button secondary(int id, String customId, String label) {
        return Button.of(id, Style.SECONDARY, customId, null, label, null, null);
    }

    public static Button secondary(int id, String customId, ReactionEmoji emoji) {
        return Button.of(id, Style.SECONDARY, customId, emoji, null, null, null);
    }

    public static Button secondary(int id, String customId, ReactionEmoji emoji, String label) {
        return Button.of(id, Style.SECONDARY, customId, emoji, label, null, null);
    }

    public static Button success(int id, String customId, String label) {
        return Button.of(id, Style.SUCCESS, customId, null, label, null, null);
    }

    public static Button success(int id, String customId, ReactionEmoji emoji) {
        return Button.of(id, Style.SUCCESS, customId, emoji, null, null, null);
    }

    public static Button success(int id, String customId, ReactionEmoji emoji, String label) {
        return Button.of(id, Style.SUCCESS, customId, emoji, label, null, null);
    }

    public static Button danger(int id, String customId, String label) {
        return Button.of(id, Style.DANGER, customId, null, label, null, null);
    }

    public static Button danger(int id, String customId, ReactionEmoji emoji) {
        return Button.of(id, Style.DANGER, customId, emoji, null, null, null);
    }

    public static Button danger(int id, String customId, ReactionEmoji emoji, String label) {
        return Button.of(id, Style.DANGER, customId, emoji, label, null, null);
    }

    public static Button link(int id, String url, String label) {
        return Button.of(id, Style.LINK, null, null, label, url, null);
    }

    public static Button link(int id, String url, ReactionEmoji emoji) {
        return Button.of(id, Style.LINK, null, emoji, null, url, null);
    }

    public static Button link(int id, String url, ReactionEmoji emoji, String label) {
        return Button.of(id, Style.LINK, null, emoji, label, url, null);
    }

    public static Button premium(int id, Snowflake skuId) {
        return Button.of(id, Style.PREMIUM, null, null, null, null, skuId.asString());
    }

    private static Button of(int id, Style style, @Nullable String customId, @Nullable ReactionEmoji emoji, @Nullable String label, @Nullable String url, @Nullable String skuId) {
        ImmutableComponentData.Builder builder = ComponentData.builder().type(MessageComponent.Type.BUTTON.getValue()).id(Integer.valueOf(id)).style(Integer.valueOf(style.getValue()));
        if (customId != null) {
            builder.customId(customId);
        }
        if (emoji != null) {
            builder.emoji(emoji.asEmojiData());
        }
        if (label != null) {
            builder.label(label);
        }
        if (url != null) {
            builder.url(url);
        }
        if (skuId != null) {
            builder.skuId(skuId);
        }
        return new Button((ComponentData)builder.build());
    }

    protected Button(Integer id, Style style, @Nullable String customId, @Nullable ReactionEmoji emoji, @Nullable String label, @Nullable String url, @Nullable String skuId) {
        super((ComponentData)MessageComponent.getBuilder(MessageComponent.Type.BUTTON).id(Possible.ofNullable((Object)id)).style(Integer.valueOf(style.getValue())).customId(Possible.ofNullable((Object)customId)).emoji(Possible.ofNullable((Object)emoji).map(ReactionEmoji::asEmojiData)).label(Possible.ofNullable((Object)label)).url(Possible.ofNullable((Object)url)).skuId(Possible.ofNullable((Object)skuId).map(Id::of)).build());
    }

    Button(ComponentData data) {
        super(data);
    }

    public Style getStyle() {
        return this.getData().style().toOptional().map(Style::of).orElseThrow(IllegalStateException::new);
    }

    public Optional<String> getLabel() {
        return this.getData().label().toOptional();
    }

    public Optional<ReactionEmoji> getEmoji() {
        return this.getData().emoji().toOptional().map(ReactionEmoji::of);
    }

    public Optional<String> getUrl() {
        return this.getData().url().toOptional();
    }

    public Optional<Snowflake> getSkuId() {
        return this.getData().skuId().toOptional().map(Snowflake::of);
    }

    public boolean isDisabled() {
        return this.getData().disabled().toOptional().orElse(false);
    }

    public Button disabled() {
        return this.disabled(true);
    }

    public Button disabled(boolean value) {
        return new Button((ComponentData)ComponentData.builder().from(this.getData()).disabled(Boolean.valueOf(value)).build());
    }

    public static enum Style {
        UNKNOWN(-1),
        PRIMARY(1),
        SECONDARY(2),
        SUCCESS(3),
        DANGER(4),
        LINK(5),
        PREMIUM(6);

        private final int value;

        private Style(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Style of(int value) {
            switch (value) {
                case 1: {
                    return PRIMARY;
                }
                case 2: {
                    return SECONDARY;
                }
                case 3: {
                    return SUCCESS;
                }
                case 4: {
                    return DANGER;
                }
                case 5: {
                    return LINK;
                }
                case 6: {
                    return PREMIUM;
                }
            }
            return UNKNOWN;
        }
    }
}

