/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.audit;

import discord4j.common.util.Snowflake;
import java.util.function.Function;

public class OptionKey<T> {
    public static final OptionKey<Integer> DELETE_MEMBER_DAYS = OptionKey.optionKey("delete_member_days", Integer::parseInt);
    public static final OptionKey<Integer> MEMBERS_REMOVED = OptionKey.optionKey("members_removed", Integer::parseInt);
    public static final OptionKey<Snowflake> CHANNEL_ID = OptionKey.optionKey("channel_id", Snowflake::of);
    public static final OptionKey<Snowflake> MESSAGE_ID = OptionKey.optionKey("message_id", Snowflake::of);
    public static final OptionKey<Integer> COUNT = OptionKey.optionKey("count", Integer::parseInt);
    public static final OptionKey<Snowflake> ID = OptionKey.optionKey("id", Snowflake::of);
    public static final OptionKey<String> TYPE = OptionKey.optionKey("type", Function.identity());
    public static final OptionKey<String> ROLE_NAME = OptionKey.optionKey("role_name", Function.identity());
    public static final OptionKey<String> INTEGRATION_TYPE = OptionKey.optionKey("integration_type", Function.identity());
    public static final OptionKey<String> AUTO_MODERATION_RULE_NAME = OptionKey.optionKey("auto_moderation_rule_name", Function.identity());
    public static final OptionKey<String> AUTO_MODERATION_RULE_TRIGGER_TYPE = OptionKey.optionKey("auto_moderation_rule_trigger_type", Function.identity());
    public static final OptionKey<Snowflake> APPLICATION_ID = OptionKey.optionKey("application_id", Snowflake::of);
    private final String field;
    private final Function<String, T> parser;

    private static <T> OptionKey<T> optionKey(String field, Function<String, T> parser) {
        return new OptionKey<T>(field, parser);
    }

    private OptionKey(String field, Function<String, T> parser) {
        this.field = field;
        this.parser = parser;
    }

    public String getField() {
        return this.field;
    }

    public T parseValue(String value) {
        return this.parser.apply(value);
    }

    public String toString() {
        return "OptionKey{field='" + this.field + '\'' + '}';
    }
}

