/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.audit;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.ExtendedPermissionOverwrite;
import discord4j.core.object.audit.AuditLogEntry;
import discord4j.core.object.audit.AuditLogRole;
import discord4j.discordjson.json.AuditLogPartialRoleData;
import discord4j.discordjson.json.OverwriteData;
import discord4j.rest.util.PermissionSet;
import java.io.IOException;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;

interface AuditLogChangeParser<T>
extends BiFunction<AuditLogEntry, JsonNode, T> {
    public static final AuditLogChangeParser<String> STRING_PARSER = (entry, node) -> node.asText();
    public static final AuditLogChangeParser<Integer> INTEGER_PARSER = (entry, node) -> node.asInt();
    public static final AuditLogChangeParser<Boolean> BOOLEAN_PARSER = (entry, node) -> node.asBoolean();
    public static final AuditLogChangeParser<Snowflake> SNOWFLAKE_PARSER = (entry, node) -> Snowflake.of((String)node.asText());
    public static final AuditLogChangeParser<PermissionSet> PERMISSION_SET_PARSER = (entry, node) -> PermissionSet.of((String)node.asText());
    public static final AuditLogChangeParser<Instant> INSTANT_PARSER = (entry, node) -> DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse((CharSequence)node.asText(), Instant::from);
    public static final AuditLogChangeParser<Set<AuditLogRole>> AUDIT_LOG_ROLES_PARSER = (entry, node) -> {
        try {
            ObjectMapper mapper = entry.getClient().getCoreResources().getJacksonResources().getObjectMapper();
            List roles = (List)mapper.readerForListOf(AuditLogPartialRoleData.class).readValue(node);
            return roles.stream().map(AuditLogRole::new).collect(Collectors.toSet());
        }
        catch (IOException e) {
            throw new RuntimeException("Could not parse audit log roles");
        }
    };
    public static final AuditLogChangeParser<Set<ExtendedPermissionOverwrite>> OVERWRITES_PARSER = (entry, node) -> {
        try {
            GatewayDiscordClient client = entry.getClient();
            ObjectMapper mapper = client.getCoreResources().getJacksonResources().getObjectMapper();
            List overwrites = (List)mapper.readerForListOf(OverwriteData.class).readValue(node);
            long guildId = entry.getParent().getGuildId().asLong();
            long channelId = entry.getTargetId().orElseThrow(() -> new NoSuchElementException("Audit log entry has no target ID")).asLong();
            return overwrites.stream().map(overwriteData -> new ExtendedPermissionOverwrite(client, (OverwriteData)overwriteData, guildId, channelId)).collect(Collectors.toSet());
        }
        catch (IOException e) {
            throw new RuntimeException("Could not parse audit log overwrite data");
        }
    };
}

