/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object;

import discord4j.common.util.Snowflake;
import discord4j.discordjson.json.OverwriteData;
import discord4j.rest.util.PermissionSet;
import java.util.Optional;

public class PermissionOverwrite {
    private final long allowed;
    private final long denied;
    private final long targetId;
    private final Type type;

    public static PermissionOverwrite forMember(Snowflake memberId, PermissionSet allowed, PermissionSet denied) {
        return new PermissionOverwrite(allowed.getRawValue(), denied.getRawValue(), memberId.asLong(), Type.MEMBER);
    }

    public static PermissionOverwrite forRole(Snowflake roleId, PermissionSet allowed, PermissionSet denied) {
        return new PermissionOverwrite(allowed.getRawValue(), denied.getRawValue(), roleId.asLong(), Type.ROLE);
    }

    PermissionOverwrite(long allowed, long denied, long targetId, Type type) {
        this.allowed = allowed;
        this.denied = denied;
        this.targetId = targetId;
        this.type = type;
    }

    public OverwriteData getData() {
        return OverwriteData.builder().id(this.targetId).type(this.type.getValue()).allow(this.allowed).deny(this.denied).build();
    }

    public PermissionSet getAllowed() {
        return PermissionSet.of((long)this.allowed);
    }

    public PermissionSet getDenied() {
        return PermissionSet.of((long)this.denied);
    }

    public Snowflake getTargetId() {
        return Snowflake.of((long)this.targetId);
    }

    public Optional<Snowflake> getRoleId() {
        return this.type == Type.ROLE ? Optional.of(this.getTargetId()) : Optional.empty();
    }

    public Optional<Snowflake> getMemberId() {
        return this.type == Type.MEMBER ? Optional.of(this.getTargetId()) : Optional.empty();
    }

    public Type getType() {
        return this.type;
    }

    public String toString() {
        return "PermissionOverwrite{allowed=" + this.allowed + ", denied=" + this.denied + ", targetId=" + this.targetId + ", type=" + (Object)((Object)this.type) + '}';
    }

    public static enum Type {
        UNKNOWN(-1),
        ROLE(0),
        MEMBER(1);

        private final int value;

        private Type(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Type of(int value) {
            switch (value) {
                case 0: {
                    return ROLE;
                }
                case 1: {
                    return MEMBER;
                }
            }
            return UNKNOWN;
        }
    }
}

