/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.event.domain.message;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.event.domain.message.MessageEvent;
import discord4j.core.object.entity.Guild;
import discord4j.core.object.entity.Message;
import discord4j.core.object.entity.User;
import discord4j.core.object.entity.channel.MessageChannel;
import discord4j.core.object.reaction.Reaction;
import discord4j.core.object.reaction.ReactionEmoji;
import discord4j.gateway.ShardInfo;
import java.util.Optional;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

public class ReactionRemoveEvent
extends MessageEvent {
    private final long userId;
    private final long channelId;
    private final long messageId;
    @Nullable
    private final Long guildId;
    private final ReactionEmoji emoji;
    private final boolean burst;
    private final int type;

    public ReactionRemoveEvent(GatewayDiscordClient gateway, ShardInfo shardInfo, long userId, long channelId, long messageId, @Nullable Long guildId, ReactionEmoji emoji, boolean burst, int type) {
        super(gateway, shardInfo);
        this.userId = userId;
        this.channelId = channelId;
        this.messageId = messageId;
        this.guildId = guildId;
        this.emoji = emoji;
        this.burst = burst;
        this.type = type;
    }

    public Snowflake getUserId() {
        return Snowflake.of((long)this.userId);
    }

    public Mono<User> getUser() {
        return this.getClient().getUserById(this.getUserId());
    }

    public Snowflake getChannelId() {
        return Snowflake.of((long)this.channelId);
    }

    public Mono<MessageChannel> getChannel() {
        return this.getClient().getChannelById(this.getChannelId()).cast(MessageChannel.class);
    }

    public Snowflake getMessageId() {
        return Snowflake.of((long)this.messageId);
    }

    public Mono<Message> getMessage() {
        return this.getClient().getMessageById(this.getChannelId(), this.getMessageId());
    }

    public Optional<Snowflake> getGuildId() {
        return Optional.ofNullable(this.guildId).map(Snowflake::of);
    }

    public Mono<Guild> getGuild() {
        return Mono.justOrEmpty(this.getGuildId()).flatMap(this.getClient()::getGuildById);
    }

    public ReactionEmoji getEmoji() {
        return this.emoji;
    }

    public boolean isSuperReaction() {
        return this.burst;
    }

    public Reaction.Type getType() {
        return Reaction.Type.of(this.type);
    }

    public String toString() {
        return "ReactionRemoveEvent{userId=" + this.userId + ", channelId=" + this.channelId + ", messageId=" + this.messageId + ", guildId=" + this.guildId + ", emoji=" + this.emoji + '}';
    }
}

