/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.event.domain.message;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.event.domain.message.MessageEvent;
import discord4j.core.object.entity.Guild;
import discord4j.core.object.entity.Member;
import discord4j.core.object.entity.Message;
import discord4j.core.object.entity.User;
import discord4j.core.object.entity.channel.MessageChannel;
import discord4j.core.object.reaction.Reaction;
import discord4j.core.object.reaction.ReactionEmoji;
import discord4j.gateway.ShardInfo;
import discord4j.rest.util.Color;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

public class ReactionAddEvent
extends MessageEvent {
    private final long userId;
    private final long channelId;
    private final long messageId;
    @Nullable
    private final Long guildId;
    private final ReactionEmoji emoji;
    @Nullable
    private final Member member;
    private final long messageAuthorId;
    private final boolean burst;
    private final List<String> burstColors;
    private final int type;

    public ReactionAddEvent(GatewayDiscordClient gateway, ShardInfo shardInfo, long userId, long channelId, long messageId, @Nullable Long guildId, ReactionEmoji emoji, @Nullable Member member, long messageAuthorId, boolean burst, List<String> burstColors, int type) {
        super(gateway, shardInfo);
        this.userId = userId;
        this.channelId = channelId;
        this.messageId = messageId;
        this.guildId = guildId;
        this.emoji = emoji;
        this.member = member;
        this.messageAuthorId = messageAuthorId;
        this.burst = burst;
        this.burstColors = burstColors;
        this.type = type;
    }

    public Snowflake getUserId() {
        return Snowflake.of((long)this.userId);
    }

    public Mono<User> getUser() {
        return this.getClient().getUserById(this.getUserId());
    }

    public Snowflake getChannelId() {
        return Snowflake.of((long)this.channelId);
    }

    public Mono<MessageChannel> getChannel() {
        return this.getClient().getChannelById(this.getChannelId()).cast(MessageChannel.class);
    }

    public Snowflake getMessageId() {
        return Snowflake.of((long)this.messageId);
    }

    public Mono<Message> getMessage() {
        return this.getClient().getMessageById(this.getChannelId(), this.getMessageId());
    }

    public Optional<Snowflake> getGuildId() {
        return Optional.ofNullable(this.guildId).map(Snowflake::of);
    }

    public Mono<Guild> getGuild() {
        return Mono.justOrEmpty(this.getGuildId()).flatMap(this.getClient()::getGuildById);
    }

    public ReactionEmoji getEmoji() {
        return this.emoji;
    }

    public Optional<Member> getMember() {
        return Optional.ofNullable(this.member);
    }

    public Snowflake getMessageAuthorId() {
        return Snowflake.of((long)this.messageAuthorId);
    }

    public List<Color> getSuperColors() {
        return this.burstColors.stream().map(Color::of).collect(Collectors.toList());
    }

    public boolean isSuperReaction() {
        return this.burst;
    }

    public Reaction.Type getType() {
        return Reaction.Type.of(this.type);
    }

    public String toString() {
        return "ReactionAddEvent{userId=" + this.userId + ", channelId=" + this.channelId + ", messageId=" + this.messageId + ", guildId=" + this.guildId + ", emoji=" + this.emoji + ", member=" + this.member + '}';
    }
}

