/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.event.domain.message;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.event.domain.message.MessageEvent;
import discord4j.core.object.Embed;
import discord4j.core.object.entity.Guild;
import discord4j.core.object.entity.Message;
import discord4j.core.object.entity.channel.MessageChannel;
import discord4j.gateway.ShardInfo;
import java.util.List;
import java.util.Optional;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

public class MessageUpdateEvent
extends MessageEvent {
    private final long messageId;
    private final long channelId;
    @Nullable
    private final Long guildId;
    @Nullable
    private final Message old;
    private final boolean contentChanged;
    @Nullable
    private final String currentContent;
    private final boolean embedsChanged;
    private final List<Embed> currentEmbeds;

    public MessageUpdateEvent(GatewayDiscordClient gateway, ShardInfo shardInfo, long messageId, long channelId, @Nullable Long guildId, @Nullable Message old, boolean contentChanged, @Nullable String currentContent, boolean embedsChanged, List<Embed> currentEmbeds) {
        super(gateway, shardInfo);
        this.messageId = messageId;
        this.channelId = channelId;
        this.guildId = guildId;
        this.old = old;
        this.contentChanged = contentChanged;
        this.currentContent = currentContent;
        this.embedsChanged = embedsChanged;
        this.currentEmbeds = currentEmbeds;
    }

    public Snowflake getMessageId() {
        return Snowflake.of((long)this.messageId);
    }

    public Mono<Message> getMessage() {
        return this.getClient().getMessageById(this.getChannelId(), this.getMessageId());
    }

    public Snowflake getChannelId() {
        return Snowflake.of((long)this.channelId);
    }

    public Mono<MessageChannel> getChannel() {
        return this.getClient().getChannelById(this.getChannelId()).cast(MessageChannel.class);
    }

    public Optional<Snowflake> getGuildId() {
        return Optional.ofNullable(this.guildId).map(Snowflake::of);
    }

    public Mono<Guild> getGuild() {
        return Mono.justOrEmpty(this.getGuildId()).flatMap(this.getClient()::getGuildById);
    }

    public Optional<Message> getOld() {
        return Optional.ofNullable(this.old);
    }

    public boolean isContentChanged() {
        return this.contentChanged;
    }

    public Optional<String> getCurrentContent() {
        return Optional.ofNullable(this.currentContent);
    }

    public boolean isEmbedsChanged() {
        return this.embedsChanged;
    }

    public List<Embed> getCurrentEmbeds() {
        return this.currentEmbeds;
    }

    public String toString() {
        return "MessageUpdateEvent{messageId=" + this.messageId + ", channelId=" + this.channelId + ", guildId=" + this.guildId + ", old=" + this.old + ", contentChanged=" + this.contentChanged + ", currentContent='" + this.currentContent + '\'' + ", embedsChanged=" + this.embedsChanged + ", currentEmbeds=" + this.currentEmbeds + '}';
    }
}

