/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.event.domain;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.event.domain.Event;
import discord4j.core.object.entity.Guild;
import discord4j.gateway.ShardInfo;
import java.util.Optional;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

public class InviteDeleteEvent
extends Event {
    @Nullable
    private final Long guildId;
    private final long channelId;
    private final String code;

    public InviteDeleteEvent(GatewayDiscordClient client, ShardInfo shardInfo, Long guildId, long channelId, String code) {
        super(client, shardInfo);
        this.guildId = guildId;
        this.channelId = channelId;
        this.code = code;
    }

    public Optional<Snowflake> getGuildId() {
        return Optional.ofNullable(this.guildId).map(Snowflake::of);
    }

    public Mono<Guild> getGuild() {
        return Mono.justOrEmpty(this.getGuildId()).flatMap(this.getClient()::getGuildById);
    }

    public Snowflake getChannelId() {
        return Snowflake.of((long)this.channelId);
    }

    public final String getCode() {
        return this.code;
    }

    public String toString() {
        return "InviteDeleteEvent{guildId=" + this.guildId + ", channelId=" + this.channelId + ", code=" + this.code + '}';
    }
}

