/*
 * Decompiled with CFR 0.152.
 */
package discord4j.voice;

import discord4j.common.util.Snowflake;
import discord4j.voice.VoiceGatewayEvent;
import java.util.function.Function;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.context.ContextView;

public interface VoiceConnection {
    public Flux<VoiceGatewayEvent> events();

    default public Mono<Boolean> isConnected() {
        return this.stateEvents().next().filter(s -> s.equals((Object)State.CONNECTED)).hasElement();
    }

    default public Mono<State> onConnectOrDisconnect() {
        return this.stateEvents().filter(s -> s.equals((Object)State.CONNECTED) || s.equals((Object)State.DISCONNECTED)).next();
    }

    public Flux<State> stateEvents();

    public Mono<Void> disconnect();

    public Snowflake getGuildId();

    public Mono<Snowflake> getChannelId();

    public Mono<Void> reconnect();

    default public Mono<Void> reconnect(Function<ContextView, Throwable> errorCause) {
        return this.reconnect();
    }

    public static enum State {
        CONNECTING,
        CONNECTED,
        RESUMING,
        RECONNECTING,
        DISCONNECTED;

    }
}

