/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json.gateway;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.SubscriptionData;
import discord4j.discordjson.json.gateway.SubscriptionDelete;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ImmutableSubscriptionDelete
implements SubscriptionDelete {
    private final SubscriptionData subscription;

    private ImmutableSubscriptionDelete(SubscriptionData subscription) {
        this.subscription = Objects.requireNonNull(subscription, "subscription");
    }

    private ImmutableSubscriptionDelete(ImmutableSubscriptionDelete original, SubscriptionData subscription) {
        this.subscription = subscription;
    }

    @Override
    @JsonProperty(value="subscription")
    @JsonUnwrapped
    public SubscriptionData subscription() {
        return this.subscription;
    }

    public final ImmutableSubscriptionDelete withSubscription(SubscriptionData value) {
        if (this.subscription == value) {
            return this;
        }
        SubscriptionData newValue = Objects.requireNonNull(value, "subscription");
        return new ImmutableSubscriptionDelete(this, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSubscriptionDelete && this.equalTo(0, (ImmutableSubscriptionDelete)another);
    }

    private boolean equalTo(int synthetic, ImmutableSubscriptionDelete another) {
        return this.subscription.equals(another.subscription);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.subscription.hashCode();
        return h;
    }

    public String toString() {
        return "SubscriptionDelete{subscription=" + this.subscription + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableSubscriptionDelete fromJson(Json json) {
        Builder builder = ImmutableSubscriptionDelete.builder();
        if (json.subscription != null) {
            builder.subscription(json.subscription);
        }
        return builder.build();
    }

    public static ImmutableSubscriptionDelete of(SubscriptionData subscription) {
        return new ImmutableSubscriptionDelete(subscription);
    }

    public static ImmutableSubscriptionDelete copyOf(SubscriptionDelete instance) {
        if (instance instanceof ImmutableSubscriptionDelete) {
            return (ImmutableSubscriptionDelete)instance;
        }
        return ImmutableSubscriptionDelete.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_SUBSCRIPTION = 1L;
        private long initBits = 1L;
        @Nullable
        private SubscriptionData subscription;

        private Builder() {
        }

        public final Builder from(SubscriptionDelete instance) {
            Objects.requireNonNull(instance, "instance");
            this.subscription(instance.subscription());
            return this;
        }

        @JsonProperty(value="subscription")
        @JsonUnwrapped
        public final Builder subscription(SubscriptionData subscription) {
            this.subscription = Objects.requireNonNull(subscription, "subscription");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableSubscriptionDelete build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSubscriptionDelete(null, this.subscription);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("subscription");
            }
            return "Cannot build SubscriptionDelete, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements SubscriptionDelete {
        @Nullable
        SubscriptionData subscription;

        Json() {
        }

        @JsonProperty(value="subscription")
        @JsonUnwrapped
        public void setSubscription(SubscriptionData subscription) {
            this.subscription = subscription;
        }

        @Override
        public SubscriptionData subscription() {
            throw new UnsupportedOperationException();
        }
    }
}

