/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json.gateway;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.ActivityUpdateRequest;
import discord4j.discordjson.json.gateway.StatusUpdate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class ImmutableStatusUpdate
implements StatusUpdate {
    @Nullable
    private final Long since;
    private final List<ActivityUpdateRequest> activities;
    private final String status;
    private final boolean afk;

    private ImmutableStatusUpdate(Optional<Long> since, Iterable<? extends ActivityUpdateRequest> activities, String status, boolean afk) {
        this.since = since.orElse(null);
        this.activities = ImmutableStatusUpdate.createUnmodifiableList(false, ImmutableStatusUpdate.createSafeList(activities, true, false));
        this.status = Objects.requireNonNull(status, "status");
        this.afk = afk;
    }

    private ImmutableStatusUpdate(ImmutableStatusUpdate original, @Nullable Long since, List<ActivityUpdateRequest> activities, String status, boolean afk) {
        this.since = since;
        this.activities = activities;
        this.status = status;
        this.afk = afk;
    }

    @Override
    @JsonProperty(value="since")
    public Optional<Long> since() {
        return Optional.ofNullable(this.since);
    }

    @Override
    @JsonProperty(value="activities")
    public List<ActivityUpdateRequest> activities() {
        return this.activities;
    }

    @Override
    @JsonProperty(value="status")
    public String status() {
        return this.status;
    }

    @Override
    @JsonProperty(value="afk")
    public boolean afk() {
        return this.afk;
    }

    public final ImmutableStatusUpdate withSince(long value) {
        Long newValue = value;
        if (Objects.equals(this.since, newValue)) {
            return this;
        }
        return new ImmutableStatusUpdate(this, newValue, this.activities, this.status, this.afk);
    }

    public final ImmutableStatusUpdate withSince(Optional<Long> optional) {
        Long value = optional.orElse(null);
        if (Objects.equals(this.since, value)) {
            return this;
        }
        return new ImmutableStatusUpdate(this, value, this.activities, this.status, this.afk);
    }

    public final ImmutableStatusUpdate withActivities(ActivityUpdateRequest ... elements) {
        List<ActivityUpdateRequest> newValue = ImmutableStatusUpdate.createUnmodifiableList(false, ImmutableStatusUpdate.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableStatusUpdate(this, this.since, newValue, this.status, this.afk);
    }

    public final ImmutableStatusUpdate withActivities(Iterable<? extends ActivityUpdateRequest> elements) {
        if (this.activities == elements) {
            return this;
        }
        List<ActivityUpdateRequest> newValue = ImmutableStatusUpdate.createUnmodifiableList(false, ImmutableStatusUpdate.createSafeList(elements, true, false));
        return new ImmutableStatusUpdate(this, this.since, newValue, this.status, this.afk);
    }

    public final ImmutableStatusUpdate withStatus(String value) {
        String newValue = Objects.requireNonNull(value, "status");
        if (this.status.equals(newValue)) {
            return this;
        }
        return new ImmutableStatusUpdate(this, this.since, this.activities, newValue, this.afk);
    }

    public final ImmutableStatusUpdate withAfk(boolean value) {
        if (this.afk == value) {
            return this;
        }
        return new ImmutableStatusUpdate(this, this.since, this.activities, this.status, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStatusUpdate && this.equalTo(0, (ImmutableStatusUpdate)another);
    }

    private boolean equalTo(int synthetic, ImmutableStatusUpdate another) {
        return Objects.equals(this.since, another.since) && this.activities.equals(another.activities) && this.status.equals(another.status) && this.afk == another.afk;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.since);
        h += (h << 5) + this.activities.hashCode();
        h += (h << 5) + this.status.hashCode();
        h += (h << 5) + Boolean.hashCode(this.afk);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("StatusUpdate{");
        if (this.since != null) {
            builder.append("since=").append(this.since);
        }
        if (builder.length() > 13) {
            builder.append(", ");
        }
        builder.append("activities=").append(this.activities);
        builder.append(", ");
        builder.append("status=").append(this.status);
        builder.append(", ");
        builder.append("afk=").append(this.afk);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableStatusUpdate fromJson(Json json) {
        Builder builder = ImmutableStatusUpdate.builder();
        if (json.since != null) {
            builder.since(json.since);
        }
        if (json.activities != null) {
            builder.addAllActivities(json.activities);
        }
        if (json.status != null) {
            builder.status(json.status);
        }
        if (json.afkIsSet) {
            builder.afk(json.afk);
        }
        return builder.build();
    }

    public static ImmutableStatusUpdate of(Optional<Long> since, List<ActivityUpdateRequest> activities, String status, boolean afk) {
        return ImmutableStatusUpdate.of(since, activities, status, afk);
    }

    public static ImmutableStatusUpdate of(Optional<Long> since, Iterable<? extends ActivityUpdateRequest> activities, String status, boolean afk) {
        return new ImmutableStatusUpdate(since, activities, status, afk);
    }

    public static ImmutableStatusUpdate copyOf(StatusUpdate instance) {
        if (instance instanceof ImmutableStatusUpdate) {
            return (ImmutableStatusUpdate)instance;
        }
        return ImmutableStatusUpdate.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_STATUS = 1L;
        private static final long INIT_BIT_AFK = 2L;
        private long initBits = 3L;
        @Nullable
        private Long since;
        private List<ActivityUpdateRequest> activities = new ArrayList<ActivityUpdateRequest>();
        @Nullable
        private String status;
        private boolean afk;

        private Builder() {
        }

        public final Builder from(StatusUpdate instance) {
            Objects.requireNonNull(instance, "instance");
            Optional<Long> sinceOptional = instance.since();
            if (sinceOptional.isPresent()) {
                this.since(sinceOptional);
            }
            this.addAllActivities(instance.activities());
            this.status(instance.status());
            this.afk(instance.afk());
            return this;
        }

        public final Builder since(long since) {
            this.since = since;
            return this;
        }

        @JsonProperty(value="since")
        public final Builder since(Optional<Long> since) {
            this.since = since.orElse(null);
            return this;
        }

        public final Builder addActivity(ActivityUpdateRequest element) {
            this.activities.add(Objects.requireNonNull(element, "activities element"));
            return this;
        }

        public final Builder addActivities(ActivityUpdateRequest ... elements) {
            for (ActivityUpdateRequest element : elements) {
                this.activities.add(Objects.requireNonNull(element, "activities element"));
            }
            return this;
        }

        @JsonProperty(value="activities")
        public final Builder activities(Iterable<? extends ActivityUpdateRequest> elements) {
            this.activities.clear();
            return this.addAllActivities(elements);
        }

        public final Builder addAllActivities(Iterable<? extends ActivityUpdateRequest> elements) {
            for (ActivityUpdateRequest activityUpdateRequest : elements) {
                this.activities.add(Objects.requireNonNull(activityUpdateRequest, "activities element"));
            }
            return this;
        }

        @JsonProperty(value="status")
        public final Builder status(String status) {
            this.status = Objects.requireNonNull(status, "status");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="afk")
        public final Builder afk(boolean afk) {
            this.afk = afk;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableStatusUpdate build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableStatusUpdate(null, this.since, ImmutableStatusUpdate.createUnmodifiableList(true, this.activities), this.status, this.afk);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("status");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("afk");
            }
            return "Cannot build StatusUpdate, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements StatusUpdate {
        @Nullable
        Optional<Long> since = Optional.empty();
        @Nullable
        List<ActivityUpdateRequest> activities = Collections.emptyList();
        @Nullable
        String status;
        boolean afk;
        boolean afkIsSet;

        Json() {
        }

        @JsonProperty(value="since")
        public void setSince(Optional<Long> since) {
            this.since = since;
        }

        @JsonProperty(value="activities")
        public void setActivities(List<ActivityUpdateRequest> activities) {
            this.activities = activities;
        }

        @JsonProperty(value="status")
        public void setStatus(String status) {
            this.status = status;
        }

        @JsonProperty(value="afk")
        public void setAfk(boolean afk) {
            this.afk = afk;
            this.afkIsSet = true;
        }

        @Override
        public Optional<Long> since() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<ActivityUpdateRequest> activities() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String status() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean afk() {
            throw new UnsupportedOperationException();
        }
    }
}

