/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json.gateway;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.SoundboardSoundData;
import discord4j.discordjson.json.gateway.SoundboardSounds;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ImmutableSoundboardSounds
implements SoundboardSounds {
    private final List<SoundboardSoundData> soundboardSounds;
    private final long guildId_value;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableSoundboardSounds(Iterable<? extends SoundboardSoundData> soundboardSounds, Id guildId) {
        this.soundboardSounds = ImmutableSoundboardSounds.createUnmodifiableList(false, ImmutableSoundboardSounds.createSafeList(soundboardSounds, true, false));
        Id guildId$impl = guildId;
        this.guildId_value = guildId$impl.asLong();
        this.initShim = null;
    }

    private ImmutableSoundboardSounds(ImmutableSoundboardSounds original, List<SoundboardSoundData> soundboardSounds, Id guildId) {
        this.soundboardSounds = soundboardSounds;
        Id guildId$impl = guildId;
        this.guildId_value = guildId$impl.asLong();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="soundboard_sounds")
    public List<SoundboardSoundData> soundboardSounds() {
        return this.soundboardSounds;
    }

    @Override
    @JsonProperty(value="guild_id")
    public Id guildId() {
        return Id.of((long)this.guildId_value);
    }

    public final ImmutableSoundboardSounds withSoundboardSounds(SoundboardSoundData ... elements) {
        List<SoundboardSoundData> newValue = ImmutableSoundboardSounds.createUnmodifiableList(false, ImmutableSoundboardSounds.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableSoundboardSounds(this, newValue, this.guildId());
    }

    public final ImmutableSoundboardSounds withSoundboardSounds(Iterable<? extends SoundboardSoundData> elements) {
        if (this.soundboardSounds == elements) {
            return this;
        }
        List<SoundboardSoundData> newValue = ImmutableSoundboardSounds.createUnmodifiableList(false, ImmutableSoundboardSounds.createSafeList(elements, true, false));
        return new ImmutableSoundboardSounds(this, newValue, this.guildId());
    }

    public ImmutableSoundboardSounds withGuildId(long value) {
        Id newValue = Id.of((long)value);
        return new ImmutableSoundboardSounds(this, this.soundboardSounds, newValue);
    }

    public ImmutableSoundboardSounds withGuildId(String value) {
        Id newValue = Id.of((String)value);
        return new ImmutableSoundboardSounds(this, this.soundboardSounds, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSoundboardSounds && this.equalTo(0, (ImmutableSoundboardSounds)another);
    }

    private boolean equalTo(int synthetic, ImmutableSoundboardSounds another) {
        return this.soundboardSounds.equals(another.soundboardSounds) && Objects.equals(this.guildId_value, another.guildId_value);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.soundboardSounds.hashCode();
        h += (h << 5) + Objects.hashCode(this.guildId_value);
        return h;
    }

    public String toString() {
        return "SoundboardSounds{soundboardSounds=" + this.soundboardSounds + ", guildId=" + Objects.toString(this.guildId_value) + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableSoundboardSounds fromJson(Json json) {
        Builder builder = ImmutableSoundboardSounds.builder();
        if (json.soundboardSounds != null) {
            builder.addAllSoundboardSounds(json.soundboardSounds);
        }
        if (json.guildId != null) {
            builder.guildId(json.guildId);
        }
        return builder.build();
    }

    public static ImmutableSoundboardSounds of(List<SoundboardSoundData> soundboardSounds, Id guildId) {
        return ImmutableSoundboardSounds.of(soundboardSounds, guildId);
    }

    public static ImmutableSoundboardSounds of(Iterable<? extends SoundboardSoundData> soundboardSounds, Id guildId) {
        return new ImmutableSoundboardSounds(soundboardSounds, guildId);
    }

    public static ImmutableSoundboardSounds copyOf(SoundboardSounds instance) {
        if (instance instanceof ImmutableSoundboardSounds) {
            return (ImmutableSoundboardSounds)instance;
        }
        return ImmutableSoundboardSounds.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private Id guildId_id = null;
        private List<SoundboardSoundData> soundboardSounds = new ArrayList<SoundboardSoundData>();

        private Builder() {
        }

        public final Builder from(SoundboardSounds instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllSoundboardSounds(instance.soundboardSounds());
            this.guildId(instance.guildId());
            return this;
        }

        public final Builder addSoundboardSound(SoundboardSoundData element) {
            this.soundboardSounds.add(Objects.requireNonNull(element, "soundboardSounds element"));
            return this;
        }

        public final Builder addSoundboardSounds(SoundboardSoundData ... elements) {
            for (SoundboardSoundData element : elements) {
                this.soundboardSounds.add(Objects.requireNonNull(element, "soundboardSounds element"));
            }
            return this;
        }

        @JsonProperty(value="soundboard_sounds")
        public final Builder soundboardSounds(Iterable<? extends SoundboardSoundData> elements) {
            this.soundboardSounds.clear();
            return this.addAllSoundboardSounds(elements);
        }

        public final Builder addAllSoundboardSounds(Iterable<? extends SoundboardSoundData> elements) {
            for (SoundboardSoundData soundboardSoundData : elements) {
                this.soundboardSounds.add(Objects.requireNonNull(soundboardSoundData, "soundboardSounds element"));
            }
            return this;
        }

        public Builder guildId(String value) {
            this.guildId_id = Id.of((String)value);
            return this;
        }

        public Builder guildId(long value) {
            this.guildId_id = Id.of((long)value);
            return this;
        }

        @JsonProperty(value="guild_id")
        public Builder guildId(Id value) {
            this.guildId_id = value;
            return this;
        }

        public ImmutableSoundboardSounds build() {
            return new ImmutableSoundboardSounds(null, ImmutableSoundboardSounds.createUnmodifiableList(true, this.soundboardSounds), this.guildId_build());
        }

        private Id guildId_build() {
            return this.guildId_id;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements SoundboardSounds {
        @Nullable
        List<SoundboardSoundData> soundboardSounds = Collections.emptyList();
        @Nullable
        Id guildId;

        Json() {
        }

        @JsonProperty(value="soundboard_sounds")
        public void setSoundboardSounds(List<SoundboardSoundData> soundboardSounds) {
            this.soundboardSounds = soundboardSounds;
        }

        @JsonProperty(value="guild_id")
        public void setGuildId(Id guildId) {
            this.guildId = guildId;
        }

        @Override
        public List<SoundboardSoundData> soundboardSounds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Id guildId() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build SoundboardSounds, attribute initializers form cycle " + attributes;
        }
    }
}

