/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json.gateway;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.UserData;
import discord4j.discordjson.json.gateway.PollVoters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ImmutablePollVoters
implements PollVoters {
    private final List<UserData> users;

    private ImmutablePollVoters(Iterable<? extends UserData> users) {
        this.users = ImmutablePollVoters.createUnmodifiableList(false, ImmutablePollVoters.createSafeList(users, true, false));
    }

    private ImmutablePollVoters(ImmutablePollVoters original, List<UserData> users) {
        this.users = users;
    }

    @Override
    @JsonProperty(value="users")
    public List<UserData> users() {
        return this.users;
    }

    public final ImmutablePollVoters withUsers(UserData ... elements) {
        List<UserData> newValue = ImmutablePollVoters.createUnmodifiableList(false, ImmutablePollVoters.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutablePollVoters(this, newValue);
    }

    public final ImmutablePollVoters withUsers(Iterable<? extends UserData> elements) {
        if (this.users == elements) {
            return this;
        }
        List<UserData> newValue = ImmutablePollVoters.createUnmodifiableList(false, ImmutablePollVoters.createSafeList(elements, true, false));
        return new ImmutablePollVoters(this, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePollVoters && this.equalTo(0, (ImmutablePollVoters)another);
    }

    private boolean equalTo(int synthetic, ImmutablePollVoters another) {
        return this.users.equals(another.users);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.users.hashCode();
        return h;
    }

    public String toString() {
        return "PollVoters{users=" + this.users + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutablePollVoters fromJson(Json json) {
        ImmutablePollVoters instance = ImmutablePollVoters.of(json.users);
        return instance;
    }

    public static ImmutablePollVoters of(List<UserData> users) {
        return ImmutablePollVoters.of(users);
    }

    public static ImmutablePollVoters of(Iterable<? extends UserData> users) {
        return new ImmutablePollVoters(users);
    }

    public static ImmutablePollVoters copyOf(PollVoters instance) {
        if (instance instanceof ImmutablePollVoters) {
            return (ImmutablePollVoters)instance;
        }
        return ImmutablePollVoters.of(instance.users());
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements PollVoters {
        @Nullable
        List<UserData> users = Collections.emptyList();

        Json() {
        }

        @JsonProperty(value="users")
        public void setUsers(List<UserData> users) {
            this.users = users;
        }

        @Override
        public List<UserData> users() {
            throw new UnsupportedOperationException();
        }
    }
}

