/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json.gateway;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.gateway.MessageReactionRemoveAll;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ImmutableMessageReactionRemoveAll
implements MessageReactionRemoveAll {
    private final long channelId_value;
    private final long messageId_value;
    private final long guildId_value;
    private final boolean guildId_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableMessageReactionRemoveAll(Id channelId, Id messageId, Possible<Id> guildId) {
        Id channelId$impl = channelId;
        Id messageId$impl = messageId;
        Possible<Id> guildId$impl = guildId;
        this.channelId_value = channelId$impl.asLong();
        this.messageId_value = messageId$impl.asLong();
        this.guildId_value = guildId$impl.toOptional().map(Id::asLong).orElse(0L);
        this.guildId_absent = guildId$impl.isAbsent();
        this.initShim = null;
    }

    private ImmutableMessageReactionRemoveAll(ImmutableMessageReactionRemoveAll original, Id channelId, Id messageId, Possible<Id> guildId) {
        Id channelId$impl = channelId;
        Id messageId$impl = messageId;
        Possible<Id> guildId$impl = guildId;
        this.channelId_value = channelId$impl.asLong();
        this.messageId_value = messageId$impl.asLong();
        this.guildId_value = guildId$impl.toOptional().map(Id::asLong).orElse(0L);
        this.guildId_absent = guildId$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="channel_id")
    public Id channelId() {
        return Id.of((long)this.channelId_value);
    }

    @Override
    @JsonProperty(value="message_id")
    public Id messageId() {
        return Id.of((long)this.messageId_value);
    }

    @Override
    @JsonProperty(value="guild_id")
    public Possible<Id> guildId() {
        return this.guildId_absent ? Possible.absent() : Possible.of((Object)Id.of((long)this.guildId_value));
    }

    public ImmutableMessageReactionRemoveAll withChannelId(long value) {
        Id newValue = Id.of((long)value);
        return new ImmutableMessageReactionRemoveAll(this, newValue, this.messageId(), this.guildId());
    }

    public ImmutableMessageReactionRemoveAll withChannelId(String value) {
        Id newValue = Id.of((String)value);
        return new ImmutableMessageReactionRemoveAll(this, newValue, this.messageId(), this.guildId());
    }

    public ImmutableMessageReactionRemoveAll withMessageId(long value) {
        Id newValue = Id.of((long)value);
        return new ImmutableMessageReactionRemoveAll(this, this.channelId(), newValue, this.guildId());
    }

    public ImmutableMessageReactionRemoveAll withMessageId(String value) {
        Id newValue = Id.of((String)value);
        return new ImmutableMessageReactionRemoveAll(this, this.channelId(), newValue, this.guildId());
    }

    public ImmutableMessageReactionRemoveAll withGuildId(Possible<Id> value) {
        Possible<Id> newValue = Objects.requireNonNull(value);
        return new ImmutableMessageReactionRemoveAll(this, this.channelId(), this.messageId(), newValue);
    }

    public ImmutableMessageReactionRemoveAll withGuildId(long value) {
        Possible newValue = Possible.of((Object)Id.of((long)value));
        return new ImmutableMessageReactionRemoveAll(this, this.channelId(), this.messageId(), (Possible<Id>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessageReactionRemoveAll && this.equalTo(0, (ImmutableMessageReactionRemoveAll)another);
    }

    private boolean equalTo(int synthetic, ImmutableMessageReactionRemoveAll another) {
        return Objects.equals(this.channelId_value, another.channelId_value) && Objects.equals(this.messageId_value, another.messageId_value) && this.guildId().equals(another.guildId());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.channelId_value);
        h += (h << 5) + Objects.hashCode(this.messageId_value);
        h += (h << 5) + this.guildId().hashCode();
        return h;
    }

    public String toString() {
        return "MessageReactionRemoveAll{channelId=" + Objects.toString(this.channelId_value) + ", messageId=" + Objects.toString(this.messageId_value) + ", guildId=" + this.guildId().toString() + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableMessageReactionRemoveAll fromJson(Json json) {
        Builder builder = ImmutableMessageReactionRemoveAll.builder();
        if (json.channelId != null) {
            builder.channelId(json.channelId);
        }
        if (json.messageId != null) {
            builder.messageId(json.messageId);
        }
        if (json.guildId != null) {
            builder.guildId(json.guildId);
        }
        return builder.build();
    }

    public static ImmutableMessageReactionRemoveAll of(Id channelId, Id messageId, Possible<Id> guildId) {
        return new ImmutableMessageReactionRemoveAll(channelId, messageId, guildId);
    }

    public static ImmutableMessageReactionRemoveAll copyOf(MessageReactionRemoveAll instance) {
        if (instance instanceof ImmutableMessageReactionRemoveAll) {
            return (ImmutableMessageReactionRemoveAll)instance;
        }
        return ImmutableMessageReactionRemoveAll.builder().from(instance).build();
    }

    public boolean isGuildIdPresent() {
        return !this.guildId_absent;
    }

    public long guildIdOrElse(long defaultValue) {
        return !this.guildId_absent ? this.guildId_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Id channelId_id = null;
        private Id messageId_id = null;
        private Possible<Id> guildId_possible = Possible.absent();

        private Builder() {
        }

        public final Builder from(MessageReactionRemoveAll instance) {
            Objects.requireNonNull(instance, "instance");
            this.channelId(instance.channelId());
            this.messageId(instance.messageId());
            this.guildId(instance.guildId());
            return this;
        }

        public Builder channelId(String value) {
            this.channelId_id = Id.of((String)value);
            return this;
        }

        public Builder channelId(long value) {
            this.channelId_id = Id.of((long)value);
            return this;
        }

        @JsonProperty(value="channel_id")
        public Builder channelId(Id value) {
            this.channelId_id = value;
            return this;
        }

        public Builder messageId(String value) {
            this.messageId_id = Id.of((String)value);
            return this;
        }

        public Builder messageId(long value) {
            this.messageId_id = Id.of((long)value);
            return this;
        }

        @JsonProperty(value="message_id")
        public Builder messageId(Id value) {
            this.messageId_id = value;
            return this;
        }

        public Builder guildId(String value) {
            this.guildId_possible = Possible.of((Object)Id.of((String)value));
            return this;
        }

        public Builder guildId(long value) {
            this.guildId_possible = Possible.of((Object)Id.of((long)value));
            return this;
        }

        public Builder guildId(Id value) {
            this.guildId_possible = Possible.of((Object)value);
            return this;
        }

        @JsonProperty(value="guild_id")
        public Builder guildId(Possible<Id> value) {
            this.guildId_possible = value;
            return this;
        }

        public ImmutableMessageReactionRemoveAll build() {
            return new ImmutableMessageReactionRemoveAll(null, this.channelId_build(), this.messageId_build(), this.guildId_build());
        }

        private Id channelId_build() {
            return this.channelId_id;
        }

        private Id messageId_build() {
            return this.messageId_id;
        }

        private Possible<Id> guildId_build() {
            return this.guildId_possible;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements MessageReactionRemoveAll {
        @Nullable
        Id channelId;
        @Nullable
        Id messageId;
        Possible<Id> guildId = Possible.absent();

        Json() {
        }

        @JsonProperty(value="channel_id")
        public void setChannelId(Id channelId) {
            this.channelId = channelId;
        }

        @JsonProperty(value="message_id")
        public void setMessageId(Id messageId) {
            this.messageId = messageId;
        }

        @JsonProperty(value="guild_id")
        public void setGuildId(Possible<Id> guildId) {
            this.guildId = guildId;
        }

        @Override
        public Id channelId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Id messageId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Id> guildId() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build MessageReactionRemoveAll, attribute initializers form cycle " + attributes;
        }
    }
}

