/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json.gateway;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.IntegrationData;
import discord4j.discordjson.json.gateway.IntegrationCreate;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ImmutableIntegrationCreate
implements IntegrationCreate {
    private final String guildId;
    private final IntegrationData integration;

    private ImmutableIntegrationCreate(String guildId, IntegrationData integration) {
        this.guildId = Objects.requireNonNull(guildId, "guildId");
        this.integration = Objects.requireNonNull(integration, "integration");
    }

    private ImmutableIntegrationCreate(ImmutableIntegrationCreate original, String guildId, IntegrationData integration) {
        this.guildId = guildId;
        this.integration = integration;
    }

    @Override
    @JsonProperty(value="guild_id")
    public String guildId() {
        return this.guildId;
    }

    @Override
    @JsonProperty(value="integration")
    @JsonUnwrapped
    public IntegrationData integration() {
        return this.integration;
    }

    public final ImmutableIntegrationCreate withGuildId(String value) {
        String newValue = Objects.requireNonNull(value, "guildId");
        if (this.guildId.equals(newValue)) {
            return this;
        }
        return new ImmutableIntegrationCreate(this, newValue, this.integration);
    }

    public final ImmutableIntegrationCreate withIntegration(IntegrationData value) {
        if (this.integration == value) {
            return this;
        }
        IntegrationData newValue = Objects.requireNonNull(value, "integration");
        return new ImmutableIntegrationCreate(this, this.guildId, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableIntegrationCreate && this.equalTo(0, (ImmutableIntegrationCreate)another);
    }

    private boolean equalTo(int synthetic, ImmutableIntegrationCreate another) {
        return this.guildId.equals(another.guildId) && this.integration.equals(another.integration);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.guildId.hashCode();
        h += (h << 5) + this.integration.hashCode();
        return h;
    }

    public String toString() {
        return "IntegrationCreate{guildId=" + this.guildId + ", integration=" + this.integration + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableIntegrationCreate fromJson(Json json) {
        Builder builder = ImmutableIntegrationCreate.builder();
        if (json.guildId != null) {
            builder.guildId(json.guildId);
        }
        if (json.integration != null) {
            builder.integration(json.integration);
        }
        return builder.build();
    }

    public static ImmutableIntegrationCreate of(String guildId, IntegrationData integration) {
        return new ImmutableIntegrationCreate(guildId, integration);
    }

    public static ImmutableIntegrationCreate copyOf(IntegrationCreate instance) {
        if (instance instanceof ImmutableIntegrationCreate) {
            return (ImmutableIntegrationCreate)instance;
        }
        return ImmutableIntegrationCreate.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_GUILD_ID = 1L;
        private static final long INIT_BIT_INTEGRATION = 2L;
        private long initBits = 3L;
        @Nullable
        private String guildId;
        @Nullable
        private IntegrationData integration;

        private Builder() {
        }

        public final Builder from(IntegrationCreate instance) {
            Objects.requireNonNull(instance, "instance");
            this.guildId(instance.guildId());
            this.integration(instance.integration());
            return this;
        }

        @JsonProperty(value="guild_id")
        public final Builder guildId(String guildId) {
            this.guildId = Objects.requireNonNull(guildId, "guildId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="integration")
        @JsonUnwrapped
        public final Builder integration(IntegrationData integration) {
            this.integration = Objects.requireNonNull(integration, "integration");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableIntegrationCreate build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableIntegrationCreate(null, this.guildId, this.integration);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("guildId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("integration");
            }
            return "Cannot build IntegrationCreate, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements IntegrationCreate {
        @Nullable
        String guildId;
        @Nullable
        IntegrationData integration;

        Json() {
        }

        @JsonProperty(value="guild_id")
        public void setGuildId(String guildId) {
            this.guildId = guildId;
        }

        @JsonProperty(value="integration")
        @JsonUnwrapped
        public void setIntegration(IntegrationData integration) {
            this.integration = integration;
        }

        @Override
        public String guildId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public IntegrationData integration() {
            throw new UnsupportedOperationException();
        }
    }
}

