/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json.gateway;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.StickerData;
import discord4j.discordjson.json.gateway.GuildStickersUpdate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ImmutableGuildStickersUpdate
implements GuildStickersUpdate {
    private final long guildId_value;
    private final List<StickerData> stickers;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableGuildStickersUpdate(Id guildId, Iterable<? extends StickerData> stickers) {
        Id guildId$impl = guildId;
        this.stickers = ImmutableGuildStickersUpdate.createUnmodifiableList(false, ImmutableGuildStickersUpdate.createSafeList(stickers, true, false));
        this.guildId_value = guildId$impl.asLong();
        this.initShim = null;
    }

    private ImmutableGuildStickersUpdate(ImmutableGuildStickersUpdate original, Id guildId, List<StickerData> stickers) {
        Id guildId$impl = guildId;
        this.stickers = stickers;
        this.guildId_value = guildId$impl.asLong();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="guild_id")
    public Id guildId() {
        return Id.of((long)this.guildId_value);
    }

    @Override
    @JsonProperty(value="stickers")
    public List<StickerData> stickers() {
        return this.stickers;
    }

    public ImmutableGuildStickersUpdate withGuildId(long value) {
        Id newValue = Id.of((long)value);
        return new ImmutableGuildStickersUpdate(this, newValue, this.stickers);
    }

    public ImmutableGuildStickersUpdate withGuildId(String value) {
        Id newValue = Id.of((String)value);
        return new ImmutableGuildStickersUpdate(this, newValue, this.stickers);
    }

    public final ImmutableGuildStickersUpdate withStickers(StickerData ... elements) {
        List<StickerData> newValue = ImmutableGuildStickersUpdate.createUnmodifiableList(false, ImmutableGuildStickersUpdate.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableGuildStickersUpdate(this, this.guildId(), newValue);
    }

    public final ImmutableGuildStickersUpdate withStickers(Iterable<? extends StickerData> elements) {
        if (this.stickers == elements) {
            return this;
        }
        List<StickerData> newValue = ImmutableGuildStickersUpdate.createUnmodifiableList(false, ImmutableGuildStickersUpdate.createSafeList(elements, true, false));
        return new ImmutableGuildStickersUpdate(this, this.guildId(), newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGuildStickersUpdate && this.equalTo(0, (ImmutableGuildStickersUpdate)another);
    }

    private boolean equalTo(int synthetic, ImmutableGuildStickersUpdate another) {
        return Objects.equals(this.guildId_value, another.guildId_value) && this.stickers.equals(another.stickers);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.guildId_value);
        h += (h << 5) + this.stickers.hashCode();
        return h;
    }

    public String toString() {
        return "GuildStickersUpdate{guildId=" + Objects.toString(this.guildId_value) + ", stickers=" + this.stickers + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableGuildStickersUpdate fromJson(Json json) {
        Builder builder = ImmutableGuildStickersUpdate.builder();
        if (json.guildId != null) {
            builder.guildId(json.guildId);
        }
        if (json.stickers != null) {
            builder.addAllStickers(json.stickers);
        }
        return builder.build();
    }

    public static ImmutableGuildStickersUpdate of(Id guildId, List<StickerData> stickers) {
        return ImmutableGuildStickersUpdate.of(guildId, stickers);
    }

    public static ImmutableGuildStickersUpdate of(Id guildId, Iterable<? extends StickerData> stickers) {
        return new ImmutableGuildStickersUpdate(guildId, stickers);
    }

    public static ImmutableGuildStickersUpdate copyOf(GuildStickersUpdate instance) {
        if (instance instanceof ImmutableGuildStickersUpdate) {
            return (ImmutableGuildStickersUpdate)instance;
        }
        return ImmutableGuildStickersUpdate.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private Id guildId_id = null;
        private List<StickerData> stickers = new ArrayList<StickerData>();

        private Builder() {
        }

        public final Builder from(GuildStickersUpdate instance) {
            Objects.requireNonNull(instance, "instance");
            this.guildId(instance.guildId());
            this.addAllStickers(instance.stickers());
            return this;
        }

        public Builder guildId(String value) {
            this.guildId_id = Id.of((String)value);
            return this;
        }

        public Builder guildId(long value) {
            this.guildId_id = Id.of((long)value);
            return this;
        }

        @JsonProperty(value="guild_id")
        public Builder guildId(Id value) {
            this.guildId_id = value;
            return this;
        }

        public final Builder addSticker(StickerData element) {
            this.stickers.add(Objects.requireNonNull(element, "stickers element"));
            return this;
        }

        public final Builder addStickers(StickerData ... elements) {
            for (StickerData element : elements) {
                this.stickers.add(Objects.requireNonNull(element, "stickers element"));
            }
            return this;
        }

        @JsonProperty(value="stickers")
        public final Builder stickers(Iterable<? extends StickerData> elements) {
            this.stickers.clear();
            return this.addAllStickers(elements);
        }

        public final Builder addAllStickers(Iterable<? extends StickerData> elements) {
            for (StickerData stickerData : elements) {
                this.stickers.add(Objects.requireNonNull(stickerData, "stickers element"));
            }
            return this;
        }

        public ImmutableGuildStickersUpdate build() {
            return new ImmutableGuildStickersUpdate(null, this.guildId_build(), ImmutableGuildStickersUpdate.createUnmodifiableList(true, this.stickers));
        }

        private Id guildId_build() {
            return this.guildId_id;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements GuildStickersUpdate {
        @Nullable
        Id guildId;
        @Nullable
        List<StickerData> stickers = Collections.emptyList();

        Json() {
        }

        @JsonProperty(value="guild_id")
        public void setGuildId(Id guildId) {
            this.guildId = guildId;
        }

        @JsonProperty(value="stickers")
        public void setStickers(List<StickerData> stickers) {
            this.stickers = stickers;
        }

        @Override
        public Id guildId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<StickerData> stickers() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build GuildStickersUpdate, attribute initializers form cycle " + attributes;
        }
    }
}

