/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.SubscriptionData;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;

public final class ImmutableSubscriptionData
implements SubscriptionData {
    private final long id_value;
    private final long userId_value;
    private final long[] skuIds_value;
    private final long[] entitlementIds_value;
    @Nullable
    private final List<Id> renewalSkuIds;
    private final String currentPeriodStart;
    private final String currentPeriodEnd;
    private final int status;
    @Nullable
    private final String canceledAt;
    private final String country_value;
    private final boolean country_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableSubscriptionData(Id id, Id userId, List<Id> skuIds, List<Id> entitlementIds, Optional<? extends List<Id>> renewalSkuIds, String currentPeriodStart, String currentPeriodEnd, int status, Optional<String> canceledAt, Possible<String> country) {
        Id id$impl = id;
        Id userId$impl = userId;
        List<Id> skuIds$impl = skuIds;
        List<Id> entitlementIds$impl = entitlementIds;
        this.renewalSkuIds = renewalSkuIds.orElse(null);
        this.currentPeriodStart = Objects.requireNonNull(currentPeriodStart, "currentPeriodStart");
        this.currentPeriodEnd = Objects.requireNonNull(currentPeriodEnd, "currentPeriodEnd");
        this.status = status;
        this.canceledAt = canceledAt.orElse(null);
        Possible<String> country$impl = country;
        this.id_value = id$impl.asLong();
        this.userId_value = userId$impl.asLong();
        this.skuIds_value = skuIds$impl.stream().mapToLong(Id::asLong).toArray();
        this.entitlementIds_value = entitlementIds$impl.stream().mapToLong(Id::asLong).toArray();
        this.country_value = country$impl.toOptional().orElse(null);
        this.country_absent = country$impl.isAbsent();
        this.initShim = null;
    }

    private ImmutableSubscriptionData(ImmutableSubscriptionData original, Id id, Id userId, List<Id> skuIds, List<Id> entitlementIds, @Nullable List<Id> renewalSkuIds, String currentPeriodStart, String currentPeriodEnd, int status, @Nullable String canceledAt, Possible<String> country) {
        Id id$impl = id;
        Id userId$impl = userId;
        List<Id> skuIds$impl = skuIds;
        List<Id> entitlementIds$impl = entitlementIds;
        this.renewalSkuIds = renewalSkuIds;
        this.currentPeriodStart = currentPeriodStart;
        this.currentPeriodEnd = currentPeriodEnd;
        this.status = status;
        this.canceledAt = canceledAt;
        Possible<String> country$impl = country;
        this.id_value = id$impl.asLong();
        this.userId_value = userId$impl.asLong();
        this.skuIds_value = skuIds$impl.stream().mapToLong(Id::asLong).toArray();
        this.entitlementIds_value = entitlementIds$impl.stream().mapToLong(Id::asLong).toArray();
        this.country_value = country$impl.toOptional().orElse(null);
        this.country_absent = country$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="id")
    public Id id() {
        return Id.of((long)this.id_value);
    }

    @Override
    @JsonProperty(value="user_id")
    public Id userId() {
        return Id.of((long)this.userId_value);
    }

    @Override
    @JsonProperty(value="sku_ids")
    public List<Id> skuIds() {
        return LongStream.of(this.skuIds_value).mapToObj(Id::of).collect(Collectors.toList());
    }

    @Override
    @JsonProperty(value="entitlement_ids")
    public List<Id> entitlementIds() {
        return LongStream.of(this.entitlementIds_value).mapToObj(Id::of).collect(Collectors.toList());
    }

    @Override
    @JsonProperty(value="renewal_sku_ids")
    public Optional<List<Id>> renewalSkuIds() {
        return Optional.ofNullable(this.renewalSkuIds);
    }

    @Override
    @JsonProperty(value="current_period_start")
    public String currentPeriodStart() {
        return this.currentPeriodStart;
    }

    @Override
    @JsonProperty(value="current_period_end")
    public String currentPeriodEnd() {
        return this.currentPeriodEnd;
    }

    @Override
    @JsonProperty(value="status")
    public int status() {
        return this.status;
    }

    @Override
    @JsonProperty(value="canceled_at")
    public Optional<String> canceledAt() {
        return Optional.ofNullable(this.canceledAt);
    }

    @Override
    @JsonProperty(value="country")
    public Possible<String> country() {
        return this.country_absent ? Possible.absent() : Possible.of((Object)this.country_value);
    }

    public ImmutableSubscriptionData withId(long value) {
        Id newValue = Id.of((long)value);
        return new ImmutableSubscriptionData(this, newValue, this.userId(), this.skuIds(), this.entitlementIds(), this.renewalSkuIds, this.currentPeriodStart, this.currentPeriodEnd, this.status, this.canceledAt, this.country());
    }

    public ImmutableSubscriptionData withId(String value) {
        Id newValue = Id.of((String)value);
        return new ImmutableSubscriptionData(this, newValue, this.userId(), this.skuIds(), this.entitlementIds(), this.renewalSkuIds, this.currentPeriodStart, this.currentPeriodEnd, this.status, this.canceledAt, this.country());
    }

    public ImmutableSubscriptionData withUserId(long value) {
        Id newValue = Id.of((long)value);
        return new ImmutableSubscriptionData(this, this.id(), newValue, this.skuIds(), this.entitlementIds(), this.renewalSkuIds, this.currentPeriodStart, this.currentPeriodEnd, this.status, this.canceledAt, this.country());
    }

    public ImmutableSubscriptionData withUserId(String value) {
        Id newValue = Id.of((String)value);
        return new ImmutableSubscriptionData(this, this.id(), newValue, this.skuIds(), this.entitlementIds(), this.renewalSkuIds, this.currentPeriodStart, this.currentPeriodEnd, this.status, this.canceledAt, this.country());
    }

    public ImmutableSubscriptionData withSkuIds(List<Id> value) {
        List<Id> newValue = value;
        return new ImmutableSubscriptionData(this, this.id(), this.userId(), newValue, this.entitlementIds(), this.renewalSkuIds, this.currentPeriodStart, this.currentPeriodEnd, this.status, this.canceledAt, this.country());
    }

    public ImmutableSubscriptionData withEntitlementIds(List<Id> value) {
        List<Id> newValue = value;
        return new ImmutableSubscriptionData(this, this.id(), this.userId(), this.skuIds(), newValue, this.renewalSkuIds, this.currentPeriodStart, this.currentPeriodEnd, this.status, this.canceledAt, this.country());
    }

    public final ImmutableSubscriptionData withRenewalSkuIds(List<Id> value) {
        List<Id> newValue = Objects.requireNonNull(value, "renewalSkuIds");
        if (this.renewalSkuIds == newValue) {
            return this;
        }
        return new ImmutableSubscriptionData(this, this.id(), this.userId(), this.skuIds(), this.entitlementIds(), newValue, this.currentPeriodStart, this.currentPeriodEnd, this.status, this.canceledAt, this.country());
    }

    public final ImmutableSubscriptionData withRenewalSkuIds(Optional<? extends List<Id>> optional) {
        List value = optional.orElse(null);
        if (this.renewalSkuIds == value) {
            return this;
        }
        return new ImmutableSubscriptionData(this, this.id(), this.userId(), this.skuIds(), this.entitlementIds(), value, this.currentPeriodStart, this.currentPeriodEnd, this.status, this.canceledAt, this.country());
    }

    public final ImmutableSubscriptionData withCurrentPeriodStart(String value) {
        String newValue = Objects.requireNonNull(value, "currentPeriodStart");
        if (this.currentPeriodStart.equals(newValue)) {
            return this;
        }
        return new ImmutableSubscriptionData(this, this.id(), this.userId(), this.skuIds(), this.entitlementIds(), this.renewalSkuIds, newValue, this.currentPeriodEnd, this.status, this.canceledAt, this.country());
    }

    public final ImmutableSubscriptionData withCurrentPeriodEnd(String value) {
        String newValue = Objects.requireNonNull(value, "currentPeriodEnd");
        if (this.currentPeriodEnd.equals(newValue)) {
            return this;
        }
        return new ImmutableSubscriptionData(this, this.id(), this.userId(), this.skuIds(), this.entitlementIds(), this.renewalSkuIds, this.currentPeriodStart, newValue, this.status, this.canceledAt, this.country());
    }

    public final ImmutableSubscriptionData withStatus(int value) {
        if (this.status == value) {
            return this;
        }
        return new ImmutableSubscriptionData(this, this.id(), this.userId(), this.skuIds(), this.entitlementIds(), this.renewalSkuIds, this.currentPeriodStart, this.currentPeriodEnd, value, this.canceledAt, this.country());
    }

    public final ImmutableSubscriptionData withCanceledAt(String value) {
        String newValue = Objects.requireNonNull(value, "canceledAt");
        if (Objects.equals(this.canceledAt, newValue)) {
            return this;
        }
        return new ImmutableSubscriptionData(this, this.id(), this.userId(), this.skuIds(), this.entitlementIds(), this.renewalSkuIds, this.currentPeriodStart, this.currentPeriodEnd, this.status, newValue, this.country());
    }

    public final ImmutableSubscriptionData withCanceledAt(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.canceledAt, value)) {
            return this;
        }
        return new ImmutableSubscriptionData(this, this.id(), this.userId(), this.skuIds(), this.entitlementIds(), this.renewalSkuIds, this.currentPeriodStart, this.currentPeriodEnd, this.status, value, this.country());
    }

    public ImmutableSubscriptionData withCountry(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return new ImmutableSubscriptionData(this, this.id(), this.userId(), this.skuIds(), this.entitlementIds(), this.renewalSkuIds, this.currentPeriodStart, this.currentPeriodEnd, this.status, this.canceledAt, newValue);
    }

    public ImmutableSubscriptionData withCountry(String value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableSubscriptionData(this, this.id(), this.userId(), this.skuIds(), this.entitlementIds(), this.renewalSkuIds, this.currentPeriodStart, this.currentPeriodEnd, this.status, this.canceledAt, (Possible<String>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSubscriptionData && this.equalTo(0, (ImmutableSubscriptionData)another);
    }

    private boolean equalTo(int synthetic, ImmutableSubscriptionData another) {
        return Objects.equals(this.id_value, another.id_value) && Objects.equals(this.userId_value, another.userId_value) && Objects.equals(this.skuIds_value, another.skuIds_value) && Objects.equals(this.entitlementIds_value, another.entitlementIds_value) && Objects.equals(this.renewalSkuIds, another.renewalSkuIds) && this.currentPeriodStart.equals(another.currentPeriodStart) && this.currentPeriodEnd.equals(another.currentPeriodEnd) && this.status == another.status && Objects.equals(this.canceledAt, another.canceledAt) && this.country().equals(another.country());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.id_value);
        h += (h << 5) + Objects.hashCode(this.userId_value);
        h += (h << 5) + Objects.hashCode(this.skuIds_value);
        h += (h << 5) + Objects.hashCode(this.entitlementIds_value);
        h += (h << 5) + Objects.hashCode(this.renewalSkuIds);
        h += (h << 5) + this.currentPeriodStart.hashCode();
        h += (h << 5) + this.currentPeriodEnd.hashCode();
        h += (h << 5) + this.status;
        h += (h << 5) + Objects.hashCode(this.canceledAt);
        h += (h << 5) + this.country().hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SubscriptionData{");
        builder.append("id=").append(Objects.toString(this.id_value));
        builder.append(", ");
        builder.append("userId=").append(Objects.toString(this.userId_value));
        builder.append(", ");
        builder.append("skuIds=").append(Objects.toString(this.skuIds_value));
        builder.append(", ");
        builder.append("entitlementIds=").append(Objects.toString(this.entitlementIds_value));
        if (this.renewalSkuIds != null) {
            builder.append(", ");
            builder.append("renewalSkuIds=").append(this.renewalSkuIds);
        }
        builder.append(", ");
        builder.append("currentPeriodStart=").append(this.currentPeriodStart);
        builder.append(", ");
        builder.append("currentPeriodEnd=").append(this.currentPeriodEnd);
        builder.append(", ");
        builder.append("status=").append(this.status);
        if (this.canceledAt != null) {
            builder.append(", ");
            builder.append("canceledAt=").append(this.canceledAt);
        }
        builder.append(", ");
        builder.append("country=").append(this.country().toString());
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableSubscriptionData fromJson(Json json) {
        Builder builder = ImmutableSubscriptionData.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.userId != null) {
            builder.userId(json.userId);
        }
        if (json.skuIds != null) {
            builder.skuIds(json.skuIds);
        }
        if (json.entitlementIds != null) {
            builder.entitlementIds(json.entitlementIds);
        }
        if (json.renewalSkuIds != null) {
            builder.renewalSkuIds(json.renewalSkuIds);
        }
        if (json.currentPeriodStart != null) {
            builder.currentPeriodStart(json.currentPeriodStart);
        }
        if (json.currentPeriodEnd != null) {
            builder.currentPeriodEnd(json.currentPeriodEnd);
        }
        if (json.statusIsSet) {
            builder.status(json.status);
        }
        if (json.canceledAt != null) {
            builder.canceledAt(json.canceledAt);
        }
        if (json.country != null) {
            builder.country(json.country);
        }
        return builder.build();
    }

    public static ImmutableSubscriptionData of(Id id, Id userId, List<Id> skuIds, List<Id> entitlementIds, Optional<? extends List<Id>> renewalSkuIds, String currentPeriodStart, String currentPeriodEnd, int status, Optional<String> canceledAt, Possible<String> country) {
        return new ImmutableSubscriptionData(id, userId, skuIds, entitlementIds, renewalSkuIds, currentPeriodStart, currentPeriodEnd, status, canceledAt, country);
    }

    public static ImmutableSubscriptionData copyOf(SubscriptionData instance) {
        if (instance instanceof ImmutableSubscriptionData) {
            return (ImmutableSubscriptionData)instance;
        }
        return ImmutableSubscriptionData.builder().from(instance).build();
    }

    public boolean isCountryPresent() {
        return !this.country_absent;
    }

    public String countryOrElse(String defaultValue) {
        return !this.country_absent ? this.country_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CURRENT_PERIOD_START = 1L;
        private static final long INIT_BIT_CURRENT_PERIOD_END = 2L;
        private static final long INIT_BIT_STATUS = 4L;
        private long initBits = 7L;
        private Id id_id = null;
        private Id userId_id = null;
        private List<Long> skuIds_list = null;
        private List<Long> entitlementIds_list = null;
        private Possible<String> country_possible = Possible.absent();
        @Nullable
        private List<Id> renewalSkuIds;
        @Nullable
        private String currentPeriodStart;
        @Nullable
        private String currentPeriodEnd;
        private int status;
        @Nullable
        private String canceledAt;

        private Builder() {
        }

        public final Builder from(SubscriptionData instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.id());
            this.userId(instance.userId());
            this.skuIds(instance.skuIds());
            this.entitlementIds(instance.entitlementIds());
            Optional<List<Id>> renewalSkuIdsOptional = instance.renewalSkuIds();
            if (renewalSkuIdsOptional.isPresent()) {
                this.renewalSkuIds(renewalSkuIdsOptional);
            }
            this.currentPeriodStart(instance.currentPeriodStart());
            this.currentPeriodEnd(instance.currentPeriodEnd());
            this.status(instance.status());
            Optional<String> canceledAtOptional = instance.canceledAt();
            if (canceledAtOptional.isPresent()) {
                this.canceledAt(canceledAtOptional);
            }
            this.country(instance.country());
            return this;
        }

        public Builder id(String value) {
            this.id_id = Id.of((String)value);
            return this;
        }

        public Builder id(long value) {
            this.id_id = Id.of((long)value);
            return this;
        }

        @JsonProperty(value="id")
        public Builder id(Id value) {
            this.id_id = value;
            return this;
        }

        public Builder userId(String value) {
            this.userId_id = Id.of((String)value);
            return this;
        }

        public Builder userId(long value) {
            this.userId_id = Id.of((long)value);
            return this;
        }

        @JsonProperty(value="user_id")
        public Builder userId(Id value) {
            this.userId_id = value;
            return this;
        }

        public Builder addSkuId(long element) {
            this.skuIds_getOrCreate().add(element);
            return this;
        }

        public Builder addSkuId(String element) {
            this.skuIds_getOrCreate().add(Id.of((String)element).asLong());
            return this;
        }

        public Builder addSkuId(Id element) {
            this.skuIds_getOrCreate().add(element.asLong());
            return this;
        }

        public Builder addAllSkuIds(List<Long> elements) {
            this.skuIds_getOrCreate().addAll(elements);
            return this;
        }

        @JsonProperty(value="sku_ids")
        public Builder skuIds(List<Id> elements) {
            this.skuIds_list = elements.stream().map(Id::asLong).collect(Collectors.toList());
            return this;
        }

        public Builder skuIds(Iterable<Id> elements) {
            this.skuIds_list = StreamSupport.stream(elements.spliterator(), false).map(Id::asLong).collect(Collectors.toList());
            return this;
        }

        public Builder addEntitlementId(long element) {
            this.entitlementIds_getOrCreate().add(element);
            return this;
        }

        public Builder addEntitlementId(String element) {
            this.entitlementIds_getOrCreate().add(Id.of((String)element).asLong());
            return this;
        }

        public Builder addEntitlementId(Id element) {
            this.entitlementIds_getOrCreate().add(element.asLong());
            return this;
        }

        public Builder addAllEntitlementIds(List<Long> elements) {
            this.entitlementIds_getOrCreate().addAll(elements);
            return this;
        }

        @JsonProperty(value="entitlement_ids")
        public Builder entitlementIds(List<Id> elements) {
            this.entitlementIds_list = elements.stream().map(Id::asLong).collect(Collectors.toList());
            return this;
        }

        public Builder entitlementIds(Iterable<Id> elements) {
            this.entitlementIds_list = StreamSupport.stream(elements.spliterator(), false).map(Id::asLong).collect(Collectors.toList());
            return this;
        }

        public final Builder renewalSkuIds(List<Id> renewalSkuIds) {
            this.renewalSkuIds = Objects.requireNonNull(renewalSkuIds, "renewalSkuIds");
            return this;
        }

        @JsonProperty(value="renewal_sku_ids")
        public final Builder renewalSkuIds(Optional<? extends List<Id>> renewalSkuIds) {
            this.renewalSkuIds = renewalSkuIds.orElse(null);
            return this;
        }

        @JsonProperty(value="current_period_start")
        public final Builder currentPeriodStart(String currentPeriodStart) {
            this.currentPeriodStart = Objects.requireNonNull(currentPeriodStart, "currentPeriodStart");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="current_period_end")
        public final Builder currentPeriodEnd(String currentPeriodEnd) {
            this.currentPeriodEnd = Objects.requireNonNull(currentPeriodEnd, "currentPeriodEnd");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="status")
        public final Builder status(int status) {
            this.status = status;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder canceledAt(String canceledAt) {
            this.canceledAt = Objects.requireNonNull(canceledAt, "canceledAt");
            return this;
        }

        @JsonProperty(value="canceled_at")
        public final Builder canceledAt(Optional<String> canceledAt) {
            this.canceledAt = canceledAt.orElse(null);
            return this;
        }

        @JsonProperty(value="country")
        public Builder country(Possible<String> value) {
            this.country_possible = value;
            return this;
        }

        public Builder country(String value) {
            this.country_possible = Possible.of((Object)value);
            return this;
        }

        public ImmutableSubscriptionData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSubscriptionData(null, this.id_build(), this.userId_build(), this.skuIds_build(), this.entitlementIds_build(), this.renewalSkuIds, this.currentPeriodStart, this.currentPeriodEnd, this.status, this.canceledAt, this.country_build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("currentPeriodStart");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("currentPeriodEnd");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("status");
            }
            return "Cannot build SubscriptionData, some of required attributes are not set " + attributes;
        }

        private Id id_build() {
            return this.id_id;
        }

        private Id userId_build() {
            return this.userId_id;
        }

        private List<Id> skuIds_build() {
            return this.skuIds_getOrCreate().stream().map(Id::of).collect(Collectors.toList());
        }

        private List<Long> skuIds_getOrCreate() {
            if (this.skuIds_list == null) {
                this.skuIds_list = new ArrayList<Long>();
            }
            return this.skuIds_list;
        }

        private List<Id> entitlementIds_build() {
            return this.entitlementIds_getOrCreate().stream().map(Id::of).collect(Collectors.toList());
        }

        private List<Long> entitlementIds_getOrCreate() {
            if (this.entitlementIds_list == null) {
                this.entitlementIds_list = new ArrayList<Long>();
            }
            return this.entitlementIds_list;
        }

        private Possible<String> country_build() {
            return this.country_possible;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements SubscriptionData {
        @Nullable
        Id id;
        @Nullable
        Id userId;
        @Nullable
        List<Id> skuIds;
        @Nullable
        List<Id> entitlementIds;
        @Nullable
        Optional<List<Id>> renewalSkuIds = Optional.empty();
        @Nullable
        String currentPeriodStart;
        @Nullable
        String currentPeriodEnd;
        int status;
        boolean statusIsSet;
        @Nullable
        Optional<String> canceledAt = Optional.empty();
        Possible<String> country = Possible.absent();

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(Id id) {
            this.id = id;
        }

        @JsonProperty(value="user_id")
        public void setUserId(Id userId) {
            this.userId = userId;
        }

        @JsonProperty(value="sku_ids")
        public void setSkuIds(List<Id> skuIds) {
            this.skuIds = skuIds;
        }

        @JsonProperty(value="entitlement_ids")
        public void setEntitlementIds(List<Id> entitlementIds) {
            this.entitlementIds = entitlementIds;
        }

        @JsonProperty(value="renewal_sku_ids")
        public void setRenewalSkuIds(Optional<List<Id>> renewalSkuIds) {
            this.renewalSkuIds = renewalSkuIds;
        }

        @JsonProperty(value="current_period_start")
        public void setCurrentPeriodStart(String currentPeriodStart) {
            this.currentPeriodStart = currentPeriodStart;
        }

        @JsonProperty(value="current_period_end")
        public void setCurrentPeriodEnd(String currentPeriodEnd) {
            this.currentPeriodEnd = currentPeriodEnd;
        }

        @JsonProperty(value="status")
        public void setStatus(int status) {
            this.status = status;
            this.statusIsSet = true;
        }

        @JsonProperty(value="canceled_at")
        public void setCanceledAt(Optional<String> canceledAt) {
            this.canceledAt = canceledAt;
        }

        @JsonProperty(value="country")
        public void setCountry(Possible<String> country) {
            this.country = country;
        }

        @Override
        public Id id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Id userId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Id> skuIds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Id> entitlementIds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<List<Id>> renewalSkuIds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String currentPeriodStart() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String currentPeriodEnd() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int status() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> canceledAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<String> country() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build SubscriptionData, attribute initializers form cycle " + attributes;
        }
    }
}

