/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.EmojiData;
import discord4j.discordjson.json.SelectOptionData;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ImmutableSelectOptionData
implements SelectOptionData {
    private final String label;
    private final String value;
    private final String description_value;
    private final boolean description_absent;
    private final EmojiData emoji_value;
    private final boolean emoji_absent;
    private final Boolean isDefault_value;
    private final boolean isDefault_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableSelectOptionData(String label, String value, Possible<String> description, Possible<EmojiData> emoji, Possible<Boolean> isDefault) {
        this.label = Objects.requireNonNull(label, "label");
        this.value = Objects.requireNonNull(value, "value");
        Possible<String> description$impl = description;
        Possible<EmojiData> emoji$impl = emoji;
        Possible<Boolean> isDefault$impl = isDefault;
        this.description_value = description$impl.toOptional().orElse(null);
        this.description_absent = description$impl.isAbsent();
        this.emoji_value = emoji$impl.toOptional().orElse(null);
        this.emoji_absent = emoji$impl.isAbsent();
        this.isDefault_value = isDefault$impl.toOptional().orElse(null);
        this.isDefault_absent = isDefault$impl.isAbsent();
        this.initShim = null;
    }

    private ImmutableSelectOptionData(ImmutableSelectOptionData original, String label, String value, Possible<String> description, Possible<EmojiData> emoji, Possible<Boolean> isDefault) {
        this.label = label;
        this.value = value;
        Possible<String> description$impl = description;
        Possible<EmojiData> emoji$impl = emoji;
        Possible<Boolean> isDefault$impl = isDefault;
        this.description_value = description$impl.toOptional().orElse(null);
        this.description_absent = description$impl.isAbsent();
        this.emoji_value = emoji$impl.toOptional().orElse(null);
        this.emoji_absent = emoji$impl.isAbsent();
        this.isDefault_value = isDefault$impl.toOptional().orElse(null);
        this.isDefault_absent = isDefault$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="label")
    public String label() {
        return this.label;
    }

    @Override
    @JsonProperty(value="value")
    public String value() {
        return this.value;
    }

    @Override
    @JsonProperty(value="description")
    public Possible<String> description() {
        return this.description_absent ? Possible.absent() : Possible.of((Object)this.description_value);
    }

    @Override
    @JsonProperty(value="emoji")
    public Possible<EmojiData> emoji() {
        return this.emoji_absent ? Possible.absent() : Possible.of((Object)this.emoji_value);
    }

    @Override
    @JsonProperty(value="default")
    public Possible<Boolean> isDefault() {
        return this.isDefault_absent ? Possible.absent() : Possible.of((Object)this.isDefault_value);
    }

    public final ImmutableSelectOptionData withLabel(String value) {
        String newValue = Objects.requireNonNull(value, "label");
        if (this.label.equals(newValue)) {
            return this;
        }
        return new ImmutableSelectOptionData(this, newValue, this.value, this.description(), this.emoji(), this.isDefault());
    }

    public final ImmutableSelectOptionData withValue(String value) {
        String newValue = Objects.requireNonNull(value, "value");
        if (this.value.equals(newValue)) {
            return this;
        }
        return new ImmutableSelectOptionData(this, this.label, newValue, this.description(), this.emoji(), this.isDefault());
    }

    public ImmutableSelectOptionData withDescription(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return new ImmutableSelectOptionData(this, this.label, this.value, newValue, this.emoji(), this.isDefault());
    }

    public ImmutableSelectOptionData withDescription(String value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableSelectOptionData(this, this.label, this.value, (Possible<String>)newValue, this.emoji(), this.isDefault());
    }

    public ImmutableSelectOptionData withEmoji(Possible<EmojiData> value) {
        Possible<EmojiData> newValue = Objects.requireNonNull(value);
        return new ImmutableSelectOptionData(this, this.label, this.value, this.description(), newValue, this.isDefault());
    }

    public ImmutableSelectOptionData withEmoji(EmojiData value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableSelectOptionData(this, this.label, this.value, this.description(), (Possible<EmojiData>)newValue, this.isDefault());
    }

    public ImmutableSelectOptionData withIsDefault(Possible<Boolean> value) {
        Possible<Boolean> newValue = Objects.requireNonNull(value);
        return new ImmutableSelectOptionData(this, this.label, this.value, this.description(), this.emoji(), newValue);
    }

    public ImmutableSelectOptionData withIsDefault(Boolean value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableSelectOptionData(this, this.label, this.value, this.description(), this.emoji(), (Possible<Boolean>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSelectOptionData && this.equalTo(0, (ImmutableSelectOptionData)another);
    }

    private boolean equalTo(int synthetic, ImmutableSelectOptionData another) {
        return this.label.equals(another.label) && this.value.equals(another.value) && this.description().equals(another.description()) && this.emoji().equals(another.emoji()) && this.isDefault().equals(another.isDefault());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.label.hashCode();
        h += (h << 5) + this.value.hashCode();
        h += (h << 5) + this.description().hashCode();
        h += (h << 5) + this.emoji().hashCode();
        h += (h << 5) + this.isDefault().hashCode();
        return h;
    }

    public String toString() {
        return "SelectOptionData{label=" + this.label + ", value=" + this.value + ", description=" + this.description().toString() + ", emoji=" + this.emoji().toString() + ", isDefault=" + this.isDefault().toString() + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableSelectOptionData fromJson(Json json) {
        Builder builder = ImmutableSelectOptionData.builder();
        if (json.label != null) {
            builder.label(json.label);
        }
        if (json.value != null) {
            builder.value(json.value);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.emoji != null) {
            builder.emoji(json.emoji);
        }
        if (json.isDefault != null) {
            builder.isDefault(json.isDefault);
        }
        return builder.build();
    }

    public static ImmutableSelectOptionData of(String label, String value, Possible<String> description, Possible<EmojiData> emoji, Possible<Boolean> isDefault) {
        return new ImmutableSelectOptionData(label, value, description, emoji, isDefault);
    }

    public static ImmutableSelectOptionData copyOf(SelectOptionData instance) {
        if (instance instanceof ImmutableSelectOptionData) {
            return (ImmutableSelectOptionData)instance;
        }
        return ImmutableSelectOptionData.builder().from(instance).build();
    }

    public boolean isDescriptionPresent() {
        return !this.description_absent;
    }

    public String descriptionOrElse(String defaultValue) {
        return !this.description_absent ? this.description_value : defaultValue;
    }

    public boolean isEmojiPresent() {
        return !this.emoji_absent;
    }

    public EmojiData emojiOrElse(EmojiData defaultValue) {
        return !this.emoji_absent ? this.emoji_value : defaultValue;
    }

    public boolean isIsDefaultPresent() {
        return !this.isDefault_absent;
    }

    public Boolean isDefaultOrElse(Boolean defaultValue) {
        return !this.isDefault_absent ? this.isDefault_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_LABEL = 1L;
        private static final long INIT_BIT_VALUE = 2L;
        private long initBits = 3L;
        private Possible<String> description_possible = Possible.absent();
        private Possible<EmojiData> emoji_possible = Possible.absent();
        private Possible<Boolean> isDefault_possible = Possible.absent();
        @Nullable
        private String label;
        @Nullable
        private String value;

        private Builder() {
        }

        public final Builder from(SelectOptionData instance) {
            Objects.requireNonNull(instance, "instance");
            this.label(instance.label());
            this.value(instance.value());
            this.description(instance.description());
            this.emoji(instance.emoji());
            this.isDefault(instance.isDefault());
            return this;
        }

        @JsonProperty(value="label")
        public final Builder label(String label) {
            this.label = Objects.requireNonNull(label, "label");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="value")
        public final Builder value(String value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="description")
        public Builder description(Possible<String> value) {
            this.description_possible = value;
            return this;
        }

        public Builder description(String value) {
            this.description_possible = Possible.of((Object)value);
            return this;
        }

        @JsonProperty(value="emoji")
        public Builder emoji(Possible<EmojiData> value) {
            this.emoji_possible = value;
            return this;
        }

        public Builder emoji(EmojiData value) {
            this.emoji_possible = Possible.of((Object)value);
            return this;
        }

        @JsonProperty(value="default")
        public Builder isDefault(Possible<Boolean> value) {
            this.isDefault_possible = value;
            return this;
        }

        public Builder isDefault(Boolean value) {
            this.isDefault_possible = Possible.of((Object)value);
            return this;
        }

        public ImmutableSelectOptionData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSelectOptionData(null, this.label, this.value, this.description_build(), this.emoji_build(), this.isDefault_build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("label");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("value");
            }
            return "Cannot build SelectOptionData, some of required attributes are not set " + attributes;
        }

        private Possible<String> description_build() {
            return this.description_possible;
        }

        private Possible<EmojiData> emoji_build() {
            return this.emoji_possible;
        }

        private Possible<Boolean> isDefault_build() {
            return this.isDefault_possible;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements SelectOptionData {
        @Nullable
        String label;
        @Nullable
        String value;
        Possible<String> description = Possible.absent();
        Possible<EmojiData> emoji = Possible.absent();
        Possible<Boolean> isDefault = Possible.absent();

        Json() {
        }

        @JsonProperty(value="label")
        public void setLabel(String label) {
            this.label = label;
        }

        @JsonProperty(value="value")
        public void setValue(String value) {
            this.value = value;
        }

        @JsonProperty(value="description")
        public void setDescription(Possible<String> description) {
            this.description = description;
        }

        @JsonProperty(value="emoji")
        public void setEmoji(Possible<EmojiData> emoji) {
            this.emoji = emoji;
        }

        @JsonProperty(value="default")
        public void setIsDefault(Possible<Boolean> isDefault) {
            this.isDefault = isDefault;
        }

        @Override
        public String label() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String value() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<String> description() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<EmojiData> emoji() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Boolean> isDefault() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build SelectOptionData, attribute initializers form cycle " + attributes;
        }
    }
}

