/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.ReactionCountDetailsData;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ImmutableReactionCountDetailsData
implements ReactionCountDetailsData {
    private final int normal;
    private final int burst;

    private ImmutableReactionCountDetailsData(int normal, int burst) {
        this.normal = normal;
        this.burst = burst;
    }

    @Override
    @JsonProperty(value="normal")
    public int normal() {
        return this.normal;
    }

    @Override
    @JsonProperty(value="burst")
    public int burst() {
        return this.burst;
    }

    public final ImmutableReactionCountDetailsData withNormal(int value) {
        if (this.normal == value) {
            return this;
        }
        return new ImmutableReactionCountDetailsData(value, this.burst);
    }

    public final ImmutableReactionCountDetailsData withBurst(int value) {
        if (this.burst == value) {
            return this;
        }
        return new ImmutableReactionCountDetailsData(this.normal, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableReactionCountDetailsData && this.equalTo(0, (ImmutableReactionCountDetailsData)another);
    }

    private boolean equalTo(int synthetic, ImmutableReactionCountDetailsData another) {
        return this.normal == another.normal && this.burst == another.burst;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.normal;
        h += (h << 5) + this.burst;
        return h;
    }

    public String toString() {
        return "ReactionCountDetailsData{normal=" + this.normal + ", burst=" + this.burst + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableReactionCountDetailsData fromJson(Json json) {
        Builder builder = ImmutableReactionCountDetailsData.builder();
        if (json.normalIsSet) {
            builder.normal(json.normal);
        }
        if (json.burstIsSet) {
            builder.burst(json.burst);
        }
        return builder.build();
    }

    public static ImmutableReactionCountDetailsData of(int normal, int burst) {
        return new ImmutableReactionCountDetailsData(normal, burst);
    }

    public static ImmutableReactionCountDetailsData copyOf(ReactionCountDetailsData instance) {
        if (instance instanceof ImmutableReactionCountDetailsData) {
            return (ImmutableReactionCountDetailsData)instance;
        }
        return ImmutableReactionCountDetailsData.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_NORMAL = 1L;
        private static final long INIT_BIT_BURST = 2L;
        private long initBits = 3L;
        private int normal;
        private int burst;

        private Builder() {
        }

        public final Builder from(ReactionCountDetailsData instance) {
            Objects.requireNonNull(instance, "instance");
            this.normal(instance.normal());
            this.burst(instance.burst());
            return this;
        }

        @JsonProperty(value="normal")
        public final Builder normal(int normal) {
            this.normal = normal;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="burst")
        public final Builder burst(int burst) {
            this.burst = burst;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableReactionCountDetailsData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableReactionCountDetailsData(this.normal, this.burst);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("normal");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("burst");
            }
            return "Cannot build ReactionCountDetailsData, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements ReactionCountDetailsData {
        int normal;
        boolean normalIsSet;
        int burst;
        boolean burstIsSet;

        Json() {
        }

        @JsonProperty(value="normal")
        public void setNormal(int normal) {
            this.normal = normal;
            this.normalIsSet = true;
        }

        @JsonProperty(value="burst")
        public void setBurst(int burst) {
            this.burst = burst;
            this.burstIsSet = true;
        }

        @Override
        public int normal() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int burst() {
            throw new UnsupportedOperationException();
        }
    }
}

