/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.EmojiData;
import discord4j.discordjson.json.PollMediaObject;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ImmutablePollMediaObject
implements PollMediaObject {
    private final String text_value;
    private final boolean text_absent;
    private final EmojiData emoji_value;
    private final boolean emoji_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutablePollMediaObject(Possible<String> text, Possible<EmojiData> emoji) {
        Possible<String> text$impl = text;
        Possible<EmojiData> emoji$impl = emoji;
        this.text_value = text$impl.toOptional().orElse(null);
        this.text_absent = text$impl.isAbsent();
        this.emoji_value = emoji$impl.toOptional().orElse(null);
        this.emoji_absent = emoji$impl.isAbsent();
        this.initShim = null;
    }

    private ImmutablePollMediaObject(ImmutablePollMediaObject original, Possible<String> text, Possible<EmojiData> emoji) {
        Possible<String> text$impl = text;
        Possible<EmojiData> emoji$impl = emoji;
        this.text_value = text$impl.toOptional().orElse(null);
        this.text_absent = text$impl.isAbsent();
        this.emoji_value = emoji$impl.toOptional().orElse(null);
        this.emoji_absent = emoji$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="text")
    public Possible<String> text() {
        return this.text_absent ? Possible.absent() : Possible.of((Object)this.text_value);
    }

    @Override
    @JsonProperty(value="emoji")
    public Possible<EmojiData> emoji() {
        return this.emoji_absent ? Possible.absent() : Possible.of((Object)this.emoji_value);
    }

    public ImmutablePollMediaObject withText(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return new ImmutablePollMediaObject(this, newValue, this.emoji());
    }

    public ImmutablePollMediaObject withText(String value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutablePollMediaObject(this, (Possible<String>)newValue, this.emoji());
    }

    public ImmutablePollMediaObject withEmoji(Possible<EmojiData> value) {
        Possible<EmojiData> newValue = Objects.requireNonNull(value);
        return new ImmutablePollMediaObject(this, this.text(), newValue);
    }

    public ImmutablePollMediaObject withEmoji(EmojiData value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutablePollMediaObject(this, this.text(), (Possible<EmojiData>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePollMediaObject && this.equalTo(0, (ImmutablePollMediaObject)another);
    }

    private boolean equalTo(int synthetic, ImmutablePollMediaObject another) {
        return this.text().equals(another.text()) && this.emoji().equals(another.emoji());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.text().hashCode();
        h += (h << 5) + this.emoji().hashCode();
        return h;
    }

    public String toString() {
        return "PollMediaObject{text=" + this.text().toString() + ", emoji=" + this.emoji().toString() + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutablePollMediaObject fromJson(Json json) {
        Builder builder = ImmutablePollMediaObject.builder();
        if (json.text != null) {
            builder.text(json.text);
        }
        if (json.emoji != null) {
            builder.emoji(json.emoji);
        }
        return builder.build();
    }

    public static ImmutablePollMediaObject of(Possible<String> text, Possible<EmojiData> emoji) {
        return new ImmutablePollMediaObject(text, emoji);
    }

    public static ImmutablePollMediaObject copyOf(PollMediaObject instance) {
        if (instance instanceof ImmutablePollMediaObject) {
            return (ImmutablePollMediaObject)instance;
        }
        return ImmutablePollMediaObject.builder().from(instance).build();
    }

    public boolean isTextPresent() {
        return !this.text_absent;
    }

    public String textOrElse(String defaultValue) {
        return !this.text_absent ? this.text_value : defaultValue;
    }

    public boolean isEmojiPresent() {
        return !this.emoji_absent;
    }

    public EmojiData emojiOrElse(EmojiData defaultValue) {
        return !this.emoji_absent ? this.emoji_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Possible<String> text_possible = Possible.absent();
        private Possible<EmojiData> emoji_possible = Possible.absent();

        private Builder() {
        }

        public final Builder from(PollMediaObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.text(instance.text());
            this.emoji(instance.emoji());
            return this;
        }

        @JsonProperty(value="text")
        public Builder text(Possible<String> value) {
            this.text_possible = value;
            return this;
        }

        public Builder text(String value) {
            this.text_possible = Possible.of((Object)value);
            return this;
        }

        @JsonProperty(value="emoji")
        public Builder emoji(Possible<EmojiData> value) {
            this.emoji_possible = value;
            return this;
        }

        public Builder emoji(EmojiData value) {
            this.emoji_possible = Possible.of((Object)value);
            return this;
        }

        public ImmutablePollMediaObject build() {
            return new ImmutablePollMediaObject(null, this.text_build(), this.emoji_build());
        }

        private Possible<String> text_build() {
            return this.text_possible;
        }

        private Possible<EmojiData> emoji_build() {
            return this.emoji_possible;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements PollMediaObject {
        Possible<String> text = Possible.absent();
        Possible<EmojiData> emoji = Possible.absent();

        Json() {
        }

        @JsonProperty(value="text")
        public void setText(Possible<String> text) {
            this.text = text;
        }

        @JsonProperty(value="emoji")
        public void setEmoji(Possible<EmojiData> emoji) {
            this.emoji = emoji;
        }

        @Override
        public Possible<String> text() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<EmojiData> emoji() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build PollMediaObject, attribute initializers form cycle " + attributes;
        }
    }
}

