/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.BaseOnboardingPromptData;
import discord4j.discordjson.json.OnboardingPromptData;
import discord4j.discordjson.json.OnboardingPromptOptionData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ImmutableOnboardingPromptData
implements OnboardingPromptData {
    private final int type;
    private final String title;
    private final boolean singleSelect;
    private final boolean required;
    private final boolean inOnboarding;
    private final long id_value;
    private final List<OnboardingPromptOptionData> options;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableOnboardingPromptData(int type, String title, boolean singleSelect, boolean required, boolean inOnboarding, Id id, Iterable<? extends OnboardingPromptOptionData> options) {
        this.type = type;
        this.title = Objects.requireNonNull(title, "title");
        this.singleSelect = singleSelect;
        this.required = required;
        this.inOnboarding = inOnboarding;
        Id id$impl = id;
        this.options = ImmutableOnboardingPromptData.createUnmodifiableList(false, ImmutableOnboardingPromptData.createSafeList(options, true, false));
        this.id_value = id$impl.asLong();
        this.initShim = null;
    }

    private ImmutableOnboardingPromptData(ImmutableOnboardingPromptData original, int type, String title, boolean singleSelect, boolean required, boolean inOnboarding, Id id, List<OnboardingPromptOptionData> options) {
        this.type = type;
        this.title = title;
        this.singleSelect = singleSelect;
        this.required = required;
        this.inOnboarding = inOnboarding;
        Id id$impl = id;
        this.options = options;
        this.id_value = id$impl.asLong();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="type")
    public int type() {
        return this.type;
    }

    @Override
    @JsonProperty(value="title")
    public String title() {
        return this.title;
    }

    @Override
    @JsonProperty(value="single_select")
    public boolean singleSelect() {
        return this.singleSelect;
    }

    @Override
    @JsonProperty(value="required")
    public boolean required() {
        return this.required;
    }

    @Override
    @JsonProperty(value="in_onboarding")
    public boolean inOnboarding() {
        return this.inOnboarding;
    }

    @Override
    @JsonProperty(value="id")
    public Id id() {
        return Id.of((long)this.id_value);
    }

    @Override
    @JsonProperty(value="options")
    public List<OnboardingPromptOptionData> options() {
        return this.options;
    }

    public final ImmutableOnboardingPromptData withType(int value) {
        if (this.type == value) {
            return this;
        }
        return new ImmutableOnboardingPromptData(this, value, this.title, this.singleSelect, this.required, this.inOnboarding, this.id(), this.options);
    }

    public final ImmutableOnboardingPromptData withTitle(String value) {
        String newValue = Objects.requireNonNull(value, "title");
        if (this.title.equals(newValue)) {
            return this;
        }
        return new ImmutableOnboardingPromptData(this, this.type, newValue, this.singleSelect, this.required, this.inOnboarding, this.id(), this.options);
    }

    public final ImmutableOnboardingPromptData withSingleSelect(boolean value) {
        if (this.singleSelect == value) {
            return this;
        }
        return new ImmutableOnboardingPromptData(this, this.type, this.title, value, this.required, this.inOnboarding, this.id(), this.options);
    }

    public final ImmutableOnboardingPromptData withRequired(boolean value) {
        if (this.required == value) {
            return this;
        }
        return new ImmutableOnboardingPromptData(this, this.type, this.title, this.singleSelect, value, this.inOnboarding, this.id(), this.options);
    }

    public final ImmutableOnboardingPromptData withInOnboarding(boolean value) {
        if (this.inOnboarding == value) {
            return this;
        }
        return new ImmutableOnboardingPromptData(this, this.type, this.title, this.singleSelect, this.required, value, this.id(), this.options);
    }

    public ImmutableOnboardingPromptData withId(long value) {
        Id newValue = Id.of((long)value);
        return new ImmutableOnboardingPromptData(this, this.type, this.title, this.singleSelect, this.required, this.inOnboarding, newValue, this.options);
    }

    public ImmutableOnboardingPromptData withId(String value) {
        Id newValue = Id.of((String)value);
        return new ImmutableOnboardingPromptData(this, this.type, this.title, this.singleSelect, this.required, this.inOnboarding, newValue, this.options);
    }

    public final ImmutableOnboardingPromptData withOptions(OnboardingPromptOptionData ... elements) {
        List<OnboardingPromptOptionData> newValue = ImmutableOnboardingPromptData.createUnmodifiableList(false, ImmutableOnboardingPromptData.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableOnboardingPromptData(this, this.type, this.title, this.singleSelect, this.required, this.inOnboarding, this.id(), newValue);
    }

    public final ImmutableOnboardingPromptData withOptions(Iterable<? extends OnboardingPromptOptionData> elements) {
        if (this.options == elements) {
            return this;
        }
        List<OnboardingPromptOptionData> newValue = ImmutableOnboardingPromptData.createUnmodifiableList(false, ImmutableOnboardingPromptData.createSafeList(elements, true, false));
        return new ImmutableOnboardingPromptData(this, this.type, this.title, this.singleSelect, this.required, this.inOnboarding, this.id(), newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableOnboardingPromptData && this.equalTo(0, (ImmutableOnboardingPromptData)another);
    }

    private boolean equalTo(int synthetic, ImmutableOnboardingPromptData another) {
        return this.type == another.type && this.title.equals(another.title) && this.singleSelect == another.singleSelect && this.required == another.required && this.inOnboarding == another.inOnboarding && Objects.equals(this.id_value, another.id_value) && this.options.equals(another.options);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type;
        h += (h << 5) + this.title.hashCode();
        h += (h << 5) + Boolean.hashCode(this.singleSelect);
        h += (h << 5) + Boolean.hashCode(this.required);
        h += (h << 5) + Boolean.hashCode(this.inOnboarding);
        h += (h << 5) + Objects.hashCode(this.id_value);
        h += (h << 5) + this.options.hashCode();
        return h;
    }

    public String toString() {
        return "OnboardingPromptData{type=" + this.type + ", title=" + this.title + ", singleSelect=" + this.singleSelect + ", required=" + this.required + ", inOnboarding=" + this.inOnboarding + ", id=" + Objects.toString(this.id_value) + ", options=" + this.options + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableOnboardingPromptData fromJson(Json json) {
        Builder builder = ImmutableOnboardingPromptData.builder();
        if (json.typeIsSet) {
            builder.type(json.type);
        }
        if (json.title != null) {
            builder.title(json.title);
        }
        if (json.singleSelectIsSet) {
            builder.singleSelect(json.singleSelect);
        }
        if (json.requiredIsSet) {
            builder.required(json.required);
        }
        if (json.inOnboardingIsSet) {
            builder.inOnboarding(json.inOnboarding);
        }
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.options != null) {
            builder.addAllOptions(json.options);
        }
        return builder.build();
    }

    public static ImmutableOnboardingPromptData of(int type, String title, boolean singleSelect, boolean required, boolean inOnboarding, Id id, List<OnboardingPromptOptionData> options) {
        return ImmutableOnboardingPromptData.of(type, title, singleSelect, required, inOnboarding, id, options);
    }

    public static ImmutableOnboardingPromptData of(int type, String title, boolean singleSelect, boolean required, boolean inOnboarding, Id id, Iterable<? extends OnboardingPromptOptionData> options) {
        return new ImmutableOnboardingPromptData(type, title, singleSelect, required, inOnboarding, id, options);
    }

    public static ImmutableOnboardingPromptData copyOf(OnboardingPromptData instance) {
        if (instance instanceof ImmutableOnboardingPromptData) {
            return (ImmutableOnboardingPromptData)instance;
        }
        return ImmutableOnboardingPromptData.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_TITLE = 2L;
        private static final long INIT_BIT_SINGLE_SELECT = 4L;
        private static final long INIT_BIT_REQUIRED = 8L;
        private static final long INIT_BIT_IN_ONBOARDING = 16L;
        private long initBits = 31L;
        private Id id_id = null;
        private int type;
        @Nullable
        private String title;
        private boolean singleSelect;
        private boolean required;
        private boolean inOnboarding;
        private List<OnboardingPromptOptionData> options = new ArrayList<OnboardingPromptOptionData>();

        private Builder() {
        }

        public final Builder from(OnboardingPromptData instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(BaseOnboardingPromptData instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            BaseOnboardingPromptData instance;
            long bits = 0L;
            if (object instanceof OnboardingPromptData) {
                instance = (OnboardingPromptData)object;
                if ((bits & 0x10L) == 0L) {
                    this.inOnboarding(instance.inOnboarding());
                    bits |= 0x10L;
                }
                this.addAllOptions(instance.options());
                this.id(instance.id());
                if ((bits & 1L) == 0L) {
                    this.type(instance.type());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.title(instance.title());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.singleSelect(instance.singleSelect());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.required(instance.required());
                    bits |= 8L;
                }
            }
            if (object instanceof BaseOnboardingPromptData) {
                instance = (BaseOnboardingPromptData)object;
                if ((bits & 1L) == 0L) {
                    this.type(instance.type());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.title(instance.title());
                    bits |= 2L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.inOnboarding(instance.inOnboarding());
                    bits |= 0x10L;
                }
                if ((bits & 4L) == 0L) {
                    this.singleSelect(instance.singleSelect());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.required(instance.required());
                    bits |= 8L;
                }
            }
        }

        @JsonProperty(value="type")
        public final Builder type(int type) {
            this.type = type;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="title")
        public final Builder title(String title) {
            this.title = Objects.requireNonNull(title, "title");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="single_select")
        public final Builder singleSelect(boolean singleSelect) {
            this.singleSelect = singleSelect;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="required")
        public final Builder required(boolean required) {
            this.required = required;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="in_onboarding")
        public final Builder inOnboarding(boolean inOnboarding) {
            this.inOnboarding = inOnboarding;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public Builder id(String value) {
            this.id_id = Id.of((String)value);
            return this;
        }

        public Builder id(long value) {
            this.id_id = Id.of((long)value);
            return this;
        }

        @JsonProperty(value="id")
        public Builder id(Id value) {
            this.id_id = value;
            return this;
        }

        public final Builder addOption(OnboardingPromptOptionData element) {
            this.options.add(Objects.requireNonNull(element, "options element"));
            return this;
        }

        public final Builder addOptions(OnboardingPromptOptionData ... elements) {
            for (OnboardingPromptOptionData element : elements) {
                this.options.add(Objects.requireNonNull(element, "options element"));
            }
            return this;
        }

        @JsonProperty(value="options")
        public final Builder options(Iterable<? extends OnboardingPromptOptionData> elements) {
            this.options.clear();
            return this.addAllOptions(elements);
        }

        public final Builder addAllOptions(Iterable<? extends OnboardingPromptOptionData> elements) {
            for (OnboardingPromptOptionData onboardingPromptOptionData : elements) {
                this.options.add(Objects.requireNonNull(onboardingPromptOptionData, "options element"));
            }
            return this;
        }

        public ImmutableOnboardingPromptData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableOnboardingPromptData(null, this.type, this.title, this.singleSelect, this.required, this.inOnboarding, this.id_build(), ImmutableOnboardingPromptData.createUnmodifiableList(true, this.options));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("title");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("singleSelect");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("required");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("inOnboarding");
            }
            return "Cannot build OnboardingPromptData, some of required attributes are not set " + attributes;
        }

        private Id id_build() {
            return this.id_id;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements OnboardingPromptData {
        int type;
        boolean typeIsSet;
        @Nullable
        String title;
        boolean singleSelect;
        boolean singleSelectIsSet;
        boolean required;
        boolean requiredIsSet;
        boolean inOnboarding;
        boolean inOnboardingIsSet;
        @Nullable
        Id id;
        @Nullable
        List<OnboardingPromptOptionData> options = Collections.emptyList();

        Json() {
        }

        @JsonProperty(value="type")
        public void setType(int type) {
            this.type = type;
            this.typeIsSet = true;
        }

        @JsonProperty(value="title")
        public void setTitle(String title) {
            this.title = title;
        }

        @JsonProperty(value="single_select")
        public void setSingleSelect(boolean singleSelect) {
            this.singleSelect = singleSelect;
            this.singleSelectIsSet = true;
        }

        @JsonProperty(value="required")
        public void setRequired(boolean required) {
            this.required = required;
            this.requiredIsSet = true;
        }

        @JsonProperty(value="in_onboarding")
        public void setInOnboarding(boolean inOnboarding) {
            this.inOnboarding = inOnboarding;
            this.inOnboardingIsSet = true;
        }

        @JsonProperty(value="id")
        public void setId(Id id) {
            this.id = id;
        }

        @JsonProperty(value="options")
        public void setOptions(List<OnboardingPromptOptionData> options) {
            this.options = options;
        }

        @Override
        public int type() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String title() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean singleSelect() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean required() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean inOnboarding() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Id id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<OnboardingPromptOptionData> options() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build OnboardingPromptData, attribute initializers form cycle " + attributes;
        }
    }
}

