/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.BaseOnboardingPromptData;
import discord4j.discordjson.json.OnboardingEditPromptData;
import discord4j.discordjson.json.OnboardingEditPromptOptionData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ImmutableOnboardingEditPromptData
implements OnboardingEditPromptData {
    private final int type;
    private final String title;
    private final boolean singleSelect;
    private final boolean required;
    private final boolean inOnboarding;
    private final List<OnboardingEditPromptOptionData> options;

    private ImmutableOnboardingEditPromptData(int type, String title, boolean singleSelect, boolean required, boolean inOnboarding, Iterable<? extends OnboardingEditPromptOptionData> options) {
        this.type = type;
        this.title = Objects.requireNonNull(title, "title");
        this.singleSelect = singleSelect;
        this.required = required;
        this.inOnboarding = inOnboarding;
        this.options = ImmutableOnboardingEditPromptData.createUnmodifiableList(false, ImmutableOnboardingEditPromptData.createSafeList(options, true, false));
    }

    private ImmutableOnboardingEditPromptData(ImmutableOnboardingEditPromptData original, int type, String title, boolean singleSelect, boolean required, boolean inOnboarding, List<OnboardingEditPromptOptionData> options) {
        this.type = type;
        this.title = title;
        this.singleSelect = singleSelect;
        this.required = required;
        this.inOnboarding = inOnboarding;
        this.options = options;
    }

    @Override
    @JsonProperty(value="type")
    public int type() {
        return this.type;
    }

    @Override
    @JsonProperty(value="title")
    public String title() {
        return this.title;
    }

    @Override
    @JsonProperty(value="single_select")
    public boolean singleSelect() {
        return this.singleSelect;
    }

    @Override
    @JsonProperty(value="required")
    public boolean required() {
        return this.required;
    }

    @Override
    @JsonProperty(value="in_onboarding")
    public boolean inOnboarding() {
        return this.inOnboarding;
    }

    @Override
    @JsonProperty(value="options")
    public List<OnboardingEditPromptOptionData> options() {
        return this.options;
    }

    public final ImmutableOnboardingEditPromptData withType(int value) {
        if (this.type == value) {
            return this;
        }
        return new ImmutableOnboardingEditPromptData(this, value, this.title, this.singleSelect, this.required, this.inOnboarding, this.options);
    }

    public final ImmutableOnboardingEditPromptData withTitle(String value) {
        String newValue = Objects.requireNonNull(value, "title");
        if (this.title.equals(newValue)) {
            return this;
        }
        return new ImmutableOnboardingEditPromptData(this, this.type, newValue, this.singleSelect, this.required, this.inOnboarding, this.options);
    }

    public final ImmutableOnboardingEditPromptData withSingleSelect(boolean value) {
        if (this.singleSelect == value) {
            return this;
        }
        return new ImmutableOnboardingEditPromptData(this, this.type, this.title, value, this.required, this.inOnboarding, this.options);
    }

    public final ImmutableOnboardingEditPromptData withRequired(boolean value) {
        if (this.required == value) {
            return this;
        }
        return new ImmutableOnboardingEditPromptData(this, this.type, this.title, this.singleSelect, value, this.inOnboarding, this.options);
    }

    public final ImmutableOnboardingEditPromptData withInOnboarding(boolean value) {
        if (this.inOnboarding == value) {
            return this;
        }
        return new ImmutableOnboardingEditPromptData(this, this.type, this.title, this.singleSelect, this.required, value, this.options);
    }

    public final ImmutableOnboardingEditPromptData withOptions(OnboardingEditPromptOptionData ... elements) {
        List<OnboardingEditPromptOptionData> newValue = ImmutableOnboardingEditPromptData.createUnmodifiableList(false, ImmutableOnboardingEditPromptData.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableOnboardingEditPromptData(this, this.type, this.title, this.singleSelect, this.required, this.inOnboarding, newValue);
    }

    public final ImmutableOnboardingEditPromptData withOptions(Iterable<? extends OnboardingEditPromptOptionData> elements) {
        if (this.options == elements) {
            return this;
        }
        List<OnboardingEditPromptOptionData> newValue = ImmutableOnboardingEditPromptData.createUnmodifiableList(false, ImmutableOnboardingEditPromptData.createSafeList(elements, true, false));
        return new ImmutableOnboardingEditPromptData(this, this.type, this.title, this.singleSelect, this.required, this.inOnboarding, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableOnboardingEditPromptData && this.equalTo(0, (ImmutableOnboardingEditPromptData)another);
    }

    private boolean equalTo(int synthetic, ImmutableOnboardingEditPromptData another) {
        return this.type == another.type && this.title.equals(another.title) && this.singleSelect == another.singleSelect && this.required == another.required && this.inOnboarding == another.inOnboarding && this.options.equals(another.options);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type;
        h += (h << 5) + this.title.hashCode();
        h += (h << 5) + Boolean.hashCode(this.singleSelect);
        h += (h << 5) + Boolean.hashCode(this.required);
        h += (h << 5) + Boolean.hashCode(this.inOnboarding);
        h += (h << 5) + this.options.hashCode();
        return h;
    }

    public String toString() {
        return "OnboardingEditPromptData{type=" + this.type + ", title=" + this.title + ", singleSelect=" + this.singleSelect + ", required=" + this.required + ", inOnboarding=" + this.inOnboarding + ", options=" + this.options + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableOnboardingEditPromptData fromJson(Json json) {
        Builder builder = ImmutableOnboardingEditPromptData.builder();
        if (json.typeIsSet) {
            builder.type(json.type);
        }
        if (json.title != null) {
            builder.title(json.title);
        }
        if (json.singleSelectIsSet) {
            builder.singleSelect(json.singleSelect);
        }
        if (json.requiredIsSet) {
            builder.required(json.required);
        }
        if (json.inOnboardingIsSet) {
            builder.inOnboarding(json.inOnboarding);
        }
        if (json.options != null) {
            builder.addAllOptions(json.options);
        }
        return builder.build();
    }

    public static ImmutableOnboardingEditPromptData of(int type, String title, boolean singleSelect, boolean required, boolean inOnboarding, List<OnboardingEditPromptOptionData> options) {
        return ImmutableOnboardingEditPromptData.of(type, title, singleSelect, required, inOnboarding, options);
    }

    public static ImmutableOnboardingEditPromptData of(int type, String title, boolean singleSelect, boolean required, boolean inOnboarding, Iterable<? extends OnboardingEditPromptOptionData> options) {
        return new ImmutableOnboardingEditPromptData(type, title, singleSelect, required, inOnboarding, options);
    }

    public static ImmutableOnboardingEditPromptData copyOf(OnboardingEditPromptData instance) {
        if (instance instanceof ImmutableOnboardingEditPromptData) {
            return (ImmutableOnboardingEditPromptData)instance;
        }
        return ImmutableOnboardingEditPromptData.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_TITLE = 2L;
        private static final long INIT_BIT_SINGLE_SELECT = 4L;
        private static final long INIT_BIT_REQUIRED = 8L;
        private static final long INIT_BIT_IN_ONBOARDING = 16L;
        private long initBits = 31L;
        private int type;
        @Nullable
        private String title;
        private boolean singleSelect;
        private boolean required;
        private boolean inOnboarding;
        private List<OnboardingEditPromptOptionData> options = new ArrayList<OnboardingEditPromptOptionData>();

        private Builder() {
        }

        public final Builder from(OnboardingEditPromptData instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(BaseOnboardingPromptData instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            BaseOnboardingPromptData instance;
            long bits = 0L;
            if (object instanceof OnboardingEditPromptData) {
                instance = (OnboardingEditPromptData)object;
                this.addAllOptions(instance.options());
                if ((bits & 1L) == 0L) {
                    this.type(instance.type());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.title(instance.title());
                    bits |= 2L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.inOnboarding(instance.inOnboarding());
                    bits |= 0x10L;
                }
                if ((bits & 4L) == 0L) {
                    this.singleSelect(instance.singleSelect());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.required(instance.required());
                    bits |= 8L;
                }
            }
            if (object instanceof BaseOnboardingPromptData) {
                instance = (BaseOnboardingPromptData)object;
                if ((bits & 1L) == 0L) {
                    this.type(instance.type());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.title(instance.title());
                    bits |= 2L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.inOnboarding(instance.inOnboarding());
                    bits |= 0x10L;
                }
                if ((bits & 4L) == 0L) {
                    this.singleSelect(instance.singleSelect());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.required(instance.required());
                    bits |= 8L;
                }
            }
        }

        @JsonProperty(value="type")
        public final Builder type(int type) {
            this.type = type;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="title")
        public final Builder title(String title) {
            this.title = Objects.requireNonNull(title, "title");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="single_select")
        public final Builder singleSelect(boolean singleSelect) {
            this.singleSelect = singleSelect;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="required")
        public final Builder required(boolean required) {
            this.required = required;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="in_onboarding")
        public final Builder inOnboarding(boolean inOnboarding) {
            this.inOnboarding = inOnboarding;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder addOption(OnboardingEditPromptOptionData element) {
            this.options.add(Objects.requireNonNull(element, "options element"));
            return this;
        }

        public final Builder addOptions(OnboardingEditPromptOptionData ... elements) {
            for (OnboardingEditPromptOptionData element : elements) {
                this.options.add(Objects.requireNonNull(element, "options element"));
            }
            return this;
        }

        @JsonProperty(value="options")
        public final Builder options(Iterable<? extends OnboardingEditPromptOptionData> elements) {
            this.options.clear();
            return this.addAllOptions(elements);
        }

        public final Builder addAllOptions(Iterable<? extends OnboardingEditPromptOptionData> elements) {
            for (OnboardingEditPromptOptionData onboardingEditPromptOptionData : elements) {
                this.options.add(Objects.requireNonNull(onboardingEditPromptOptionData, "options element"));
            }
            return this;
        }

        public ImmutableOnboardingEditPromptData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableOnboardingEditPromptData(null, this.type, this.title, this.singleSelect, this.required, this.inOnboarding, ImmutableOnboardingEditPromptData.createUnmodifiableList(true, this.options));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("title");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("singleSelect");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("required");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("inOnboarding");
            }
            return "Cannot build OnboardingEditPromptData, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements OnboardingEditPromptData {
        int type;
        boolean typeIsSet;
        @Nullable
        String title;
        boolean singleSelect;
        boolean singleSelectIsSet;
        boolean required;
        boolean requiredIsSet;
        boolean inOnboarding;
        boolean inOnboardingIsSet;
        @Nullable
        List<OnboardingEditPromptOptionData> options = Collections.emptyList();

        Json() {
        }

        @JsonProperty(value="type")
        public void setType(int type) {
            this.type = type;
            this.typeIsSet = true;
        }

        @JsonProperty(value="title")
        public void setTitle(String title) {
            this.title = title;
        }

        @JsonProperty(value="single_select")
        public void setSingleSelect(boolean singleSelect) {
            this.singleSelect = singleSelect;
            this.singleSelectIsSet = true;
        }

        @JsonProperty(value="required")
        public void setRequired(boolean required) {
            this.required = required;
            this.requiredIsSet = true;
        }

        @JsonProperty(value="in_onboarding")
        public void setInOnboarding(boolean inOnboarding) {
            this.inOnboarding = inOnboarding;
            this.inOnboardingIsSet = true;
        }

        @JsonProperty(value="options")
        public void setOptions(List<OnboardingEditPromptOptionData> options) {
            this.options = options;
        }

        @Override
        public int type() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String title() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean singleSelect() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean required() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean inOnboarding() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<OnboardingEditPromptOptionData> options() {
            throw new UnsupportedOperationException();
        }
    }
}

