/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.MessageApplicationData;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class ImmutableMessageApplicationData
implements MessageApplicationData {
    private final long id_value;
    private final String coverImage_value;
    private final boolean coverImage_absent;
    private final String description;
    @Nullable
    private final String icon;
    private final String name;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableMessageApplicationData(Id id, Possible<String> coverImage, String description, Optional<String> icon, String name) {
        Id id$impl = id;
        Possible<String> coverImage$impl = coverImage;
        this.description = Objects.requireNonNull(description, "description");
        this.icon = icon.orElse(null);
        this.name = Objects.requireNonNull(name, "name");
        this.id_value = id$impl.asLong();
        this.coverImage_value = coverImage$impl.toOptional().orElse(null);
        this.coverImage_absent = coverImage$impl.isAbsent();
        this.initShim = null;
    }

    private ImmutableMessageApplicationData(ImmutableMessageApplicationData original, Id id, Possible<String> coverImage, String description, @Nullable String icon, String name) {
        Id id$impl = id;
        Possible<String> coverImage$impl = coverImage;
        this.description = description;
        this.icon = icon;
        this.name = name;
        this.id_value = id$impl.asLong();
        this.coverImage_value = coverImage$impl.toOptional().orElse(null);
        this.coverImage_absent = coverImage$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="id")
    public Id id() {
        return Id.of((long)this.id_value);
    }

    @Override
    @JsonProperty(value="cover_image")
    public Possible<String> coverImage() {
        return this.coverImage_absent ? Possible.absent() : Possible.of((Object)this.coverImage_value);
    }

    @Override
    @JsonProperty(value="description")
    public String description() {
        return this.description;
    }

    @Override
    @JsonProperty(value="icon")
    public Optional<String> icon() {
        return Optional.ofNullable(this.icon);
    }

    @Override
    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    public ImmutableMessageApplicationData withId(long value) {
        Id newValue = Id.of((long)value);
        return new ImmutableMessageApplicationData(this, newValue, this.coverImage(), this.description, this.icon, this.name);
    }

    public ImmutableMessageApplicationData withId(String value) {
        Id newValue = Id.of((String)value);
        return new ImmutableMessageApplicationData(this, newValue, this.coverImage(), this.description, this.icon, this.name);
    }

    public ImmutableMessageApplicationData withCoverImage(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return new ImmutableMessageApplicationData(this, this.id(), newValue, this.description, this.icon, this.name);
    }

    public ImmutableMessageApplicationData withCoverImage(String value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableMessageApplicationData(this, this.id(), (Possible<String>)newValue, this.description, this.icon, this.name);
    }

    public final ImmutableMessageApplicationData withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (this.description.equals(newValue)) {
            return this;
        }
        return new ImmutableMessageApplicationData(this, this.id(), this.coverImage(), newValue, this.icon, this.name);
    }

    public final ImmutableMessageApplicationData withIcon(String value) {
        String newValue = Objects.requireNonNull(value, "icon");
        if (Objects.equals(this.icon, newValue)) {
            return this;
        }
        return new ImmutableMessageApplicationData(this, this.id(), this.coverImage(), this.description, newValue, this.name);
    }

    public final ImmutableMessageApplicationData withIcon(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.icon, value)) {
            return this;
        }
        return new ImmutableMessageApplicationData(this, this.id(), this.coverImage(), this.description, value, this.name);
    }

    public final ImmutableMessageApplicationData withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableMessageApplicationData(this, this.id(), this.coverImage(), this.description, this.icon, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessageApplicationData && this.equalTo(0, (ImmutableMessageApplicationData)another);
    }

    private boolean equalTo(int synthetic, ImmutableMessageApplicationData another) {
        return Objects.equals(this.id_value, another.id_value) && this.coverImage().equals(another.coverImage()) && this.description.equals(another.description) && Objects.equals(this.icon, another.icon) && this.name.equals(another.name);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.id_value);
        h += (h << 5) + this.coverImage().hashCode();
        h += (h << 5) + this.description.hashCode();
        h += (h << 5) + Objects.hashCode(this.icon);
        h += (h << 5) + this.name.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("MessageApplicationData{");
        builder.append("id=").append(Objects.toString(this.id_value));
        builder.append(", ");
        builder.append("coverImage=").append(this.coverImage().toString());
        builder.append(", ");
        builder.append("description=").append(this.description);
        if (this.icon != null) {
            builder.append(", ");
            builder.append("icon=").append(this.icon);
        }
        builder.append(", ");
        builder.append("name=").append(this.name);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableMessageApplicationData fromJson(Json json) {
        Builder builder = ImmutableMessageApplicationData.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.coverImage != null) {
            builder.coverImage(json.coverImage);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.icon != null) {
            builder.icon(json.icon);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        return builder.build();
    }

    public static ImmutableMessageApplicationData of(Id id, Possible<String> coverImage, String description, Optional<String> icon, String name) {
        return new ImmutableMessageApplicationData(id, coverImage, description, icon, name);
    }

    public static ImmutableMessageApplicationData copyOf(MessageApplicationData instance) {
        if (instance instanceof ImmutableMessageApplicationData) {
            return (ImmutableMessageApplicationData)instance;
        }
        return ImmutableMessageApplicationData.builder().from(instance).build();
    }

    public boolean isCoverImagePresent() {
        return !this.coverImage_absent;
    }

    public String coverImageOrElse(String defaultValue) {
        return !this.coverImage_absent ? this.coverImage_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_DESCRIPTION = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private long initBits = 3L;
        private Id id_id = null;
        private Possible<String> coverImage_possible = Possible.absent();
        @Nullable
        private String description;
        @Nullable
        private String icon;
        @Nullable
        private String name;

        private Builder() {
        }

        public final Builder from(MessageApplicationData instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.id());
            this.coverImage(instance.coverImage());
            this.description(instance.description());
            Optional<String> iconOptional = instance.icon();
            if (iconOptional.isPresent()) {
                this.icon(iconOptional);
            }
            this.name(instance.name());
            return this;
        }

        public Builder id(String value) {
            this.id_id = Id.of((String)value);
            return this;
        }

        public Builder id(long value) {
            this.id_id = Id.of((long)value);
            return this;
        }

        @JsonProperty(value="id")
        public Builder id(Id value) {
            this.id_id = value;
            return this;
        }

        @JsonProperty(value="cover_image")
        public Builder coverImage(Possible<String> value) {
            this.coverImage_possible = value;
            return this;
        }

        public Builder coverImage(String value) {
            this.coverImage_possible = Possible.of((Object)value);
            return this;
        }

        @JsonProperty(value="description")
        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder icon(String icon) {
            this.icon = Objects.requireNonNull(icon, "icon");
            return this;
        }

        @JsonProperty(value="icon")
        public final Builder icon(Optional<String> icon) {
            this.icon = icon.orElse(null);
            return this;
        }

        @JsonProperty(value="name")
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableMessageApplicationData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMessageApplicationData(null, this.id_build(), this.coverImage_build(), this.description, this.icon, this.name);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("description");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build MessageApplicationData, some of required attributes are not set " + attributes;
        }

        private Id id_build() {
            return this.id_id;
        }

        private Possible<String> coverImage_build() {
            return this.coverImage_possible;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements MessageApplicationData {
        @Nullable
        Id id;
        Possible<String> coverImage = Possible.absent();
        @Nullable
        String description;
        @Nullable
        Optional<String> icon = Optional.empty();
        @Nullable
        String name;

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(Id id) {
            this.id = id;
        }

        @JsonProperty(value="cover_image")
        public void setCoverImage(Possible<String> coverImage) {
            this.coverImage = coverImage;
        }

        @JsonProperty(value="description")
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="icon")
        public void setIcon(Optional<String> icon) {
            this.icon = icon;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @Override
        public Id id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<String> coverImage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String description() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> icon() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build MessageApplicationData, attribute initializers form cycle " + attributes;
        }
    }
}

