/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.MediaGalleryItemData;
import discord4j.discordjson.json.UnfurledMediaItemData;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class ImmutableMediaGalleryItemData
implements MediaGalleryItemData {
    private final UnfurledMediaItemData media;
    private final String description_value;
    private final boolean description_absent;
    private final Boolean spoiler_value;
    private final boolean spoiler_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableMediaGalleryItemData(UnfurledMediaItemData media, Possible<Optional<String>> description, Possible<Boolean> spoiler) {
        this.media = Objects.requireNonNull(media, "media");
        Possible<Optional<String>> description$impl = description;
        Possible<Boolean> spoiler$impl = spoiler;
        this.description_value = Possible.flatOpt(description$impl).orElse(null);
        this.description_absent = description$impl.isAbsent();
        this.spoiler_value = spoiler$impl.toOptional().orElse(null);
        this.spoiler_absent = spoiler$impl.isAbsent();
        this.initShim = null;
    }

    private ImmutableMediaGalleryItemData(ImmutableMediaGalleryItemData original, UnfurledMediaItemData media, Possible<Optional<String>> description, Possible<Boolean> spoiler) {
        this.media = media;
        Possible<Optional<String>> description$impl = description;
        Possible<Boolean> spoiler$impl = spoiler;
        this.description_value = Possible.flatOpt(description$impl).orElse(null);
        this.description_absent = description$impl.isAbsent();
        this.spoiler_value = spoiler$impl.toOptional().orElse(null);
        this.spoiler_absent = spoiler$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="media")
    public UnfurledMediaItemData media() {
        return this.media;
    }

    @Override
    @JsonProperty(value="description")
    public Possible<Optional<String>> description() {
        return this.description_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.description_value));
    }

    @Override
    @JsonProperty(value="spoiler")
    public Possible<Boolean> spoiler() {
        return this.spoiler_absent ? Possible.absent() : Possible.of((Object)this.spoiler_value);
    }

    public final ImmutableMediaGalleryItemData withMedia(UnfurledMediaItemData value) {
        if (this.media == value) {
            return this;
        }
        UnfurledMediaItemData newValue = Objects.requireNonNull(value, "media");
        return new ImmutableMediaGalleryItemData(this, newValue, this.description(), this.spoiler());
    }

    public ImmutableMediaGalleryItemData withDescription(Possible<Optional<String>> value) {
        Possible<Optional<String>> newValue = Objects.requireNonNull(value);
        return new ImmutableMediaGalleryItemData(this, this.media, newValue, this.spoiler());
    }

    @Deprecated
    public ImmutableMediaGalleryItemData withDescription(@Nullable String value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutableMediaGalleryItemData(this, this.media, (Possible<Optional<String>>)newValue, this.spoiler());
    }

    public ImmutableMediaGalleryItemData withDescriptionOrNull(@Nullable String value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutableMediaGalleryItemData(this, this.media, (Possible<Optional<String>>)newValue, this.spoiler());
    }

    public ImmutableMediaGalleryItemData withSpoiler(Possible<Boolean> value) {
        Possible<Boolean> newValue = Objects.requireNonNull(value);
        return new ImmutableMediaGalleryItemData(this, this.media, this.description(), newValue);
    }

    public ImmutableMediaGalleryItemData withSpoiler(Boolean value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableMediaGalleryItemData(this, this.media, this.description(), (Possible<Boolean>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMediaGalleryItemData && this.equalTo(0, (ImmutableMediaGalleryItemData)another);
    }

    private boolean equalTo(int synthetic, ImmutableMediaGalleryItemData another) {
        return this.media.equals(another.media) && this.description().equals(another.description()) && this.spoiler().equals(another.spoiler());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.media.hashCode();
        h += (h << 5) + this.description().hashCode();
        h += (h << 5) + this.spoiler().hashCode();
        return h;
    }

    public String toString() {
        return "MediaGalleryItemData{media=" + this.media + ", description=" + this.description().toString() + ", spoiler=" + this.spoiler().toString() + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableMediaGalleryItemData fromJson(Json json) {
        Builder builder = ImmutableMediaGalleryItemData.builder();
        if (json.media != null) {
            builder.media(json.media);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.spoiler != null) {
            builder.spoiler(json.spoiler);
        }
        return builder.build();
    }

    public static ImmutableMediaGalleryItemData of(UnfurledMediaItemData media, Possible<Optional<String>> description, Possible<Boolean> spoiler) {
        return new ImmutableMediaGalleryItemData(media, description, spoiler);
    }

    public static ImmutableMediaGalleryItemData copyOf(MediaGalleryItemData instance) {
        if (instance instanceof ImmutableMediaGalleryItemData) {
            return (ImmutableMediaGalleryItemData)instance;
        }
        return ImmutableMediaGalleryItemData.builder().from(instance).build();
    }

    public boolean isDescriptionPresent() {
        return !this.description_absent;
    }

    public String descriptionOrElse(String defaultValue) {
        return !this.description_absent ? this.description_value : defaultValue;
    }

    public boolean isSpoilerPresent() {
        return !this.spoiler_absent;
    }

    public Boolean spoilerOrElse(Boolean defaultValue) {
        return !this.spoiler_absent ? this.spoiler_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_MEDIA = 1L;
        private long initBits = 1L;
        private Possible<Optional<String>> description_possible = Possible.absent();
        private Possible<Boolean> spoiler_possible = Possible.absent();
        @Nullable
        private UnfurledMediaItemData media;

        private Builder() {
        }

        public final Builder from(MediaGalleryItemData instance) {
            Objects.requireNonNull(instance, "instance");
            this.media(instance.media());
            this.description(instance.description());
            this.spoiler(instance.spoiler());
            return this;
        }

        @JsonProperty(value="media")
        public final Builder media(UnfurledMediaItemData media) {
            this.media = Objects.requireNonNull(media, "media");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="description")
        public Builder description(Possible<Optional<String>> value) {
            this.description_possible = value;
            return this;
        }

        @Deprecated
        public Builder description(@Nullable String value) {
            this.description_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public Builder descriptionOrNull(@Nullable String value) {
            this.description_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @JsonProperty(value="spoiler")
        public Builder spoiler(Possible<Boolean> value) {
            this.spoiler_possible = value;
            return this;
        }

        public Builder spoiler(Boolean value) {
            this.spoiler_possible = Possible.of((Object)value);
            return this;
        }

        public ImmutableMediaGalleryItemData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMediaGalleryItemData(null, this.media, this.description_build(), this.spoiler_build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("media");
            }
            return "Cannot build MediaGalleryItemData, some of required attributes are not set " + attributes;
        }

        private Possible<Optional<String>> description_build() {
            return this.description_possible;
        }

        private Possible<Boolean> spoiler_build() {
            return this.spoiler_possible;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements MediaGalleryItemData {
        @Nullable
        UnfurledMediaItemData media;
        Possible<Optional<String>> description = Possible.absent();
        Possible<Boolean> spoiler = Possible.absent();

        Json() {
        }

        @JsonProperty(value="media")
        public void setMedia(UnfurledMediaItemData media) {
            this.media = media;
        }

        @JsonProperty(value="description")
        public void setDescription(Possible<Optional<String>> description) {
            this.description = description;
        }

        @JsonProperty(value="spoiler")
        public void setSpoiler(Possible<Boolean> spoiler) {
            this.spoiler = spoiler;
        }

        @Override
        public UnfurledMediaItemData media() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Optional<String>> description() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Boolean> spoiler() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build MediaGalleryItemData, attribute initializers form cycle " + attributes;
        }
    }
}

