/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.InteractionApplicationCommandCallbackData;
import discord4j.discordjson.json.InteractionResponseData;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ImmutableInteractionResponseData
implements InteractionResponseData {
    private final int type;
    private final InteractionApplicationCommandCallbackData data_value;
    private final boolean data_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableInteractionResponseData(int type, Possible<InteractionApplicationCommandCallbackData> data) {
        this.type = type;
        Possible<InteractionApplicationCommandCallbackData> data$impl = data;
        this.data_value = data$impl.toOptional().orElse(null);
        this.data_absent = data$impl.isAbsent();
        this.initShim = null;
    }

    private ImmutableInteractionResponseData(ImmutableInteractionResponseData original, int type, Possible<InteractionApplicationCommandCallbackData> data) {
        this.type = type;
        Possible<InteractionApplicationCommandCallbackData> data$impl = data;
        this.data_value = data$impl.toOptional().orElse(null);
        this.data_absent = data$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="type")
    public int type() {
        return this.type;
    }

    @Override
    @JsonProperty(value="data")
    public Possible<InteractionApplicationCommandCallbackData> data() {
        return this.data_absent ? Possible.absent() : Possible.of((Object)this.data_value);
    }

    public final ImmutableInteractionResponseData withType(int value) {
        if (this.type == value) {
            return this;
        }
        return new ImmutableInteractionResponseData(this, value, this.data());
    }

    public ImmutableInteractionResponseData withData(Possible<InteractionApplicationCommandCallbackData> value) {
        Possible<InteractionApplicationCommandCallbackData> newValue = Objects.requireNonNull(value);
        return new ImmutableInteractionResponseData(this, this.type, newValue);
    }

    public ImmutableInteractionResponseData withData(InteractionApplicationCommandCallbackData value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableInteractionResponseData(this, this.type, (Possible<InteractionApplicationCommandCallbackData>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInteractionResponseData && this.equalTo(0, (ImmutableInteractionResponseData)another);
    }

    private boolean equalTo(int synthetic, ImmutableInteractionResponseData another) {
        return this.type == another.type && this.data().equals(another.data());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type;
        h += (h << 5) + this.data().hashCode();
        return h;
    }

    public String toString() {
        return "InteractionResponseData{type=" + this.type + ", data=" + this.data().toString() + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableInteractionResponseData fromJson(Json json) {
        Builder builder = ImmutableInteractionResponseData.builder();
        if (json.typeIsSet) {
            builder.type(json.type);
        }
        if (json.data != null) {
            builder.data(json.data);
        }
        return builder.build();
    }

    public static ImmutableInteractionResponseData of(int type, Possible<InteractionApplicationCommandCallbackData> data) {
        return new ImmutableInteractionResponseData(type, data);
    }

    public static ImmutableInteractionResponseData copyOf(InteractionResponseData instance) {
        if (instance instanceof ImmutableInteractionResponseData) {
            return (ImmutableInteractionResponseData)instance;
        }
        return ImmutableInteractionResponseData.builder().from(instance).build();
    }

    public boolean isDataPresent() {
        return !this.data_absent;
    }

    public InteractionApplicationCommandCallbackData dataOrElse(InteractionApplicationCommandCallbackData defaultValue) {
        return !this.data_absent ? this.data_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private long initBits = 1L;
        private Possible<InteractionApplicationCommandCallbackData> data_possible = Possible.absent();
        private int type;

        private Builder() {
        }

        public final Builder from(InteractionResponseData instance) {
            Objects.requireNonNull(instance, "instance");
            this.type(instance.type());
            this.data(instance.data());
            return this;
        }

        @JsonProperty(value="type")
        public final Builder type(int type) {
            this.type = type;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="data")
        public Builder data(Possible<InteractionApplicationCommandCallbackData> value) {
            this.data_possible = value;
            return this;
        }

        public Builder data(InteractionApplicationCommandCallbackData value) {
            this.data_possible = Possible.of((Object)value);
            return this;
        }

        public ImmutableInteractionResponseData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInteractionResponseData(null, this.type, this.data_build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build InteractionResponseData, some of required attributes are not set " + attributes;
        }

        private Possible<InteractionApplicationCommandCallbackData> data_build() {
            return this.data_possible;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements InteractionResponseData {
        int type;
        boolean typeIsSet;
        Possible<InteractionApplicationCommandCallbackData> data = Possible.absent();

        Json() {
        }

        @JsonProperty(value="type")
        public void setType(int type) {
            this.type = type;
            this.typeIsSet = true;
        }

        @JsonProperty(value="data")
        public void setData(Possible<InteractionApplicationCommandCallbackData> data) {
            this.data = data;
        }

        @Override
        public int type() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<InteractionApplicationCommandCallbackData> data() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build InteractionResponseData, attribute initializers form cycle " + attributes;
        }
    }
}

