/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.IntegrationApplicationData;
import discord4j.discordjson.json.UserData;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class ImmutableIntegrationApplicationData
implements IntegrationApplicationData {
    private final long id_value;
    private final String name;
    @Nullable
    private final String icon;
    private final String description;
    private final String summary;
    private final UserData bot_value;
    private final boolean bot_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableIntegrationApplicationData(Id id, String name, Optional<String> icon, String description, String summary, Possible<UserData> bot) {
        Id id$impl = id;
        this.name = Objects.requireNonNull(name, "name");
        this.icon = icon.orElse(null);
        this.description = Objects.requireNonNull(description, "description");
        this.summary = Objects.requireNonNull(summary, "summary");
        Possible<UserData> bot$impl = bot;
        this.id_value = id$impl.asLong();
        this.bot_value = bot$impl.toOptional().orElse(null);
        this.bot_absent = bot$impl.isAbsent();
        this.initShim = null;
    }

    private ImmutableIntegrationApplicationData(ImmutableIntegrationApplicationData original, Id id, String name, @Nullable String icon, String description, String summary, Possible<UserData> bot) {
        Id id$impl = id;
        this.name = name;
        this.icon = icon;
        this.description = description;
        this.summary = summary;
        Possible<UserData> bot$impl = bot;
        this.id_value = id$impl.asLong();
        this.bot_value = bot$impl.toOptional().orElse(null);
        this.bot_absent = bot$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="id")
    public Id id() {
        return Id.of((long)this.id_value);
    }

    @Override
    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="icon")
    public Optional<String> icon() {
        return Optional.ofNullable(this.icon);
    }

    @Override
    @JsonProperty(value="description")
    public String description() {
        return this.description;
    }

    @Override
    @JsonProperty(value="summary")
    public String summary() {
        return this.summary;
    }

    @Override
    @JsonProperty(value="bot")
    public Possible<UserData> bot() {
        return this.bot_absent ? Possible.absent() : Possible.of((Object)this.bot_value);
    }

    public ImmutableIntegrationApplicationData withId(long value) {
        Id newValue = Id.of((long)value);
        return new ImmutableIntegrationApplicationData(this, newValue, this.name, this.icon, this.description, this.summary, this.bot());
    }

    public ImmutableIntegrationApplicationData withId(String value) {
        Id newValue = Id.of((String)value);
        return new ImmutableIntegrationApplicationData(this, newValue, this.name, this.icon, this.description, this.summary, this.bot());
    }

    public final ImmutableIntegrationApplicationData withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableIntegrationApplicationData(this, this.id(), newValue, this.icon, this.description, this.summary, this.bot());
    }

    public final ImmutableIntegrationApplicationData withIcon(String value) {
        String newValue = Objects.requireNonNull(value, "icon");
        if (Objects.equals(this.icon, newValue)) {
            return this;
        }
        return new ImmutableIntegrationApplicationData(this, this.id(), this.name, newValue, this.description, this.summary, this.bot());
    }

    public final ImmutableIntegrationApplicationData withIcon(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.icon, value)) {
            return this;
        }
        return new ImmutableIntegrationApplicationData(this, this.id(), this.name, value, this.description, this.summary, this.bot());
    }

    public final ImmutableIntegrationApplicationData withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (this.description.equals(newValue)) {
            return this;
        }
        return new ImmutableIntegrationApplicationData(this, this.id(), this.name, this.icon, newValue, this.summary, this.bot());
    }

    public final ImmutableIntegrationApplicationData withSummary(String value) {
        String newValue = Objects.requireNonNull(value, "summary");
        if (this.summary.equals(newValue)) {
            return this;
        }
        return new ImmutableIntegrationApplicationData(this, this.id(), this.name, this.icon, this.description, newValue, this.bot());
    }

    public ImmutableIntegrationApplicationData withBot(Possible<UserData> value) {
        Possible<UserData> newValue = Objects.requireNonNull(value);
        return new ImmutableIntegrationApplicationData(this, this.id(), this.name, this.icon, this.description, this.summary, newValue);
    }

    public ImmutableIntegrationApplicationData withBot(UserData value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableIntegrationApplicationData(this, this.id(), this.name, this.icon, this.description, this.summary, (Possible<UserData>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableIntegrationApplicationData && this.equalTo(0, (ImmutableIntegrationApplicationData)another);
    }

    private boolean equalTo(int synthetic, ImmutableIntegrationApplicationData another) {
        return Objects.equals(this.id_value, another.id_value) && this.name.equals(another.name) && Objects.equals(this.icon, another.icon) && this.description.equals(another.description) && this.summary.equals(another.summary) && this.bot().equals(another.bot());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.id_value);
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Objects.hashCode(this.icon);
        h += (h << 5) + this.description.hashCode();
        h += (h << 5) + this.summary.hashCode();
        h += (h << 5) + this.bot().hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("IntegrationApplicationData{");
        builder.append("id=").append(Objects.toString(this.id_value));
        builder.append(", ");
        builder.append("name=").append(this.name);
        if (this.icon != null) {
            builder.append(", ");
            builder.append("icon=").append(this.icon);
        }
        builder.append(", ");
        builder.append("description=").append(this.description);
        builder.append(", ");
        builder.append("summary=").append(this.summary);
        builder.append(", ");
        builder.append("bot=").append(this.bot().toString());
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableIntegrationApplicationData fromJson(Json json) {
        Builder builder = ImmutableIntegrationApplicationData.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.icon != null) {
            builder.icon(json.icon);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.summary != null) {
            builder.summary(json.summary);
        }
        if (json.bot != null) {
            builder.bot(json.bot);
        }
        return builder.build();
    }

    public static ImmutableIntegrationApplicationData of(Id id, String name, Optional<String> icon, String description, String summary, Possible<UserData> bot) {
        return new ImmutableIntegrationApplicationData(id, name, icon, description, summary, bot);
    }

    public static ImmutableIntegrationApplicationData copyOf(IntegrationApplicationData instance) {
        if (instance instanceof ImmutableIntegrationApplicationData) {
            return (ImmutableIntegrationApplicationData)instance;
        }
        return ImmutableIntegrationApplicationData.builder().from(instance).build();
    }

    public boolean isBotPresent() {
        return !this.bot_absent;
    }

    public UserData botOrElse(UserData defaultValue) {
        return !this.bot_absent ? this.bot_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_DESCRIPTION = 2L;
        private static final long INIT_BIT_SUMMARY = 4L;
        private long initBits = 7L;
        private Id id_id = null;
        private Possible<UserData> bot_possible = Possible.absent();
        @Nullable
        private String name;
        @Nullable
        private String icon;
        @Nullable
        private String description;
        @Nullable
        private String summary;

        private Builder() {
        }

        public final Builder from(IntegrationApplicationData instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.id());
            this.name(instance.name());
            Optional<String> iconOptional = instance.icon();
            if (iconOptional.isPresent()) {
                this.icon(iconOptional);
            }
            this.description(instance.description());
            this.summary(instance.summary());
            this.bot(instance.bot());
            return this;
        }

        public Builder id(String value) {
            this.id_id = Id.of((String)value);
            return this;
        }

        public Builder id(long value) {
            this.id_id = Id.of((long)value);
            return this;
        }

        @JsonProperty(value="id")
        public Builder id(Id value) {
            this.id_id = value;
            return this;
        }

        @JsonProperty(value="name")
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder icon(String icon) {
            this.icon = Objects.requireNonNull(icon, "icon");
            return this;
        }

        @JsonProperty(value="icon")
        public final Builder icon(Optional<String> icon) {
            this.icon = icon.orElse(null);
            return this;
        }

        @JsonProperty(value="description")
        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="summary")
        public final Builder summary(String summary) {
            this.summary = Objects.requireNonNull(summary, "summary");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="bot")
        public Builder bot(Possible<UserData> value) {
            this.bot_possible = value;
            return this;
        }

        public Builder bot(UserData value) {
            this.bot_possible = Possible.of((Object)value);
            return this;
        }

        public ImmutableIntegrationApplicationData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableIntegrationApplicationData(null, this.id_build(), this.name, this.icon, this.description, this.summary, this.bot_build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("description");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("summary");
            }
            return "Cannot build IntegrationApplicationData, some of required attributes are not set " + attributes;
        }

        private Id id_build() {
            return this.id_id;
        }

        private Possible<UserData> bot_build() {
            return this.bot_possible;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements IntegrationApplicationData {
        @Nullable
        Id id;
        @Nullable
        String name;
        @Nullable
        Optional<String> icon = Optional.empty();
        @Nullable
        String description;
        @Nullable
        String summary;
        Possible<UserData> bot = Possible.absent();

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(Id id) {
            this.id = id;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="icon")
        public void setIcon(Optional<String> icon) {
            this.icon = icon;
        }

        @JsonProperty(value="description")
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="summary")
        public void setSummary(String summary) {
            this.summary = summary;
        }

        @JsonProperty(value="bot")
        public void setBot(Possible<UserData> bot) {
            this.bot = bot;
        }

        @Override
        public Id id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> icon() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String description() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String summary() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<UserData> bot() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build IntegrationApplicationData, attribute initializers form cycle " + attributes;
        }
    }
}

