/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.GuildScheduledEventUserData;
import discord4j.discordjson.json.PartialMemberData;
import discord4j.discordjson.json.UserData;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ImmutableGuildScheduledEventUserData
implements GuildScheduledEventUserData {
    private final long guildScheduledEventId_value;
    private final UserData user;
    private final PartialMemberData member_value;
    private final boolean member_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableGuildScheduledEventUserData(Id guildScheduledEventId, UserData user, Possible<PartialMemberData> member) {
        Id guildScheduledEventId$impl = guildScheduledEventId;
        this.user = Objects.requireNonNull(user, "user");
        Possible<PartialMemberData> member$impl = member;
        this.guildScheduledEventId_value = guildScheduledEventId$impl.asLong();
        this.member_value = member$impl.toOptional().orElse(null);
        this.member_absent = member$impl.isAbsent();
        this.initShim = null;
    }

    private ImmutableGuildScheduledEventUserData(ImmutableGuildScheduledEventUserData original, Id guildScheduledEventId, UserData user, Possible<PartialMemberData> member) {
        Id guildScheduledEventId$impl = guildScheduledEventId;
        this.user = user;
        Possible<PartialMemberData> member$impl = member;
        this.guildScheduledEventId_value = guildScheduledEventId$impl.asLong();
        this.member_value = member$impl.toOptional().orElse(null);
        this.member_absent = member$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="guild_scheduled_event_id")
    public Id guildScheduledEventId() {
        return Id.of((long)this.guildScheduledEventId_value);
    }

    @Override
    @JsonProperty(value="user")
    public UserData user() {
        return this.user;
    }

    @Override
    @JsonProperty(value="member")
    public Possible<PartialMemberData> member() {
        return this.member_absent ? Possible.absent() : Possible.of((Object)this.member_value);
    }

    public ImmutableGuildScheduledEventUserData withGuildScheduledEventId(long value) {
        Id newValue = Id.of((long)value);
        return new ImmutableGuildScheduledEventUserData(this, newValue, this.user, this.member());
    }

    public ImmutableGuildScheduledEventUserData withGuildScheduledEventId(String value) {
        Id newValue = Id.of((String)value);
        return new ImmutableGuildScheduledEventUserData(this, newValue, this.user, this.member());
    }

    public final ImmutableGuildScheduledEventUserData withUser(UserData value) {
        if (this.user == value) {
            return this;
        }
        UserData newValue = Objects.requireNonNull(value, "user");
        return new ImmutableGuildScheduledEventUserData(this, this.guildScheduledEventId(), newValue, this.member());
    }

    public ImmutableGuildScheduledEventUserData withMember(Possible<PartialMemberData> value) {
        Possible<PartialMemberData> newValue = Objects.requireNonNull(value);
        return new ImmutableGuildScheduledEventUserData(this, this.guildScheduledEventId(), this.user, newValue);
    }

    public ImmutableGuildScheduledEventUserData withMember(PartialMemberData value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableGuildScheduledEventUserData(this, this.guildScheduledEventId(), this.user, (Possible<PartialMemberData>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGuildScheduledEventUserData && this.equalTo(0, (ImmutableGuildScheduledEventUserData)another);
    }

    private boolean equalTo(int synthetic, ImmutableGuildScheduledEventUserData another) {
        return Objects.equals(this.guildScheduledEventId_value, another.guildScheduledEventId_value) && this.user.equals(another.user) && this.member().equals(another.member());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.guildScheduledEventId_value);
        h += (h << 5) + this.user.hashCode();
        h += (h << 5) + this.member().hashCode();
        return h;
    }

    public String toString() {
        return "GuildScheduledEventUserData{guildScheduledEventId=" + Objects.toString(this.guildScheduledEventId_value) + ", user=" + this.user + ", member=" + this.member().toString() + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableGuildScheduledEventUserData fromJson(Json json) {
        Builder builder = ImmutableGuildScheduledEventUserData.builder();
        if (json.guildScheduledEventId != null) {
            builder.guildScheduledEventId(json.guildScheduledEventId);
        }
        if (json.user != null) {
            builder.user(json.user);
        }
        if (json.member != null) {
            builder.member(json.member);
        }
        return builder.build();
    }

    public static ImmutableGuildScheduledEventUserData of(Id guildScheduledEventId, UserData user, Possible<PartialMemberData> member) {
        return new ImmutableGuildScheduledEventUserData(guildScheduledEventId, user, member);
    }

    public static ImmutableGuildScheduledEventUserData copyOf(GuildScheduledEventUserData instance) {
        if (instance instanceof ImmutableGuildScheduledEventUserData) {
            return (ImmutableGuildScheduledEventUserData)instance;
        }
        return ImmutableGuildScheduledEventUserData.builder().from(instance).build();
    }

    public boolean isMemberPresent() {
        return !this.member_absent;
    }

    public PartialMemberData memberOrElse(PartialMemberData defaultValue) {
        return !this.member_absent ? this.member_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_USER = 1L;
        private long initBits = 1L;
        private Id guildScheduledEventId_id = null;
        private Possible<PartialMemberData> member_possible = Possible.absent();
        @Nullable
        private UserData user;

        private Builder() {
        }

        public final Builder from(GuildScheduledEventUserData instance) {
            Objects.requireNonNull(instance, "instance");
            this.guildScheduledEventId(instance.guildScheduledEventId());
            this.user(instance.user());
            this.member(instance.member());
            return this;
        }

        public Builder guildScheduledEventId(String value) {
            this.guildScheduledEventId_id = Id.of((String)value);
            return this;
        }

        public Builder guildScheduledEventId(long value) {
            this.guildScheduledEventId_id = Id.of((long)value);
            return this;
        }

        @JsonProperty(value="guild_scheduled_event_id")
        public Builder guildScheduledEventId(Id value) {
            this.guildScheduledEventId_id = value;
            return this;
        }

        @JsonProperty(value="user")
        public final Builder user(UserData user) {
            this.user = Objects.requireNonNull(user, "user");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="member")
        public Builder member(Possible<PartialMemberData> value) {
            this.member_possible = value;
            return this;
        }

        public Builder member(PartialMemberData value) {
            this.member_possible = Possible.of((Object)value);
            return this;
        }

        public ImmutableGuildScheduledEventUserData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGuildScheduledEventUserData(null, this.guildScheduledEventId_build(), this.user, this.member_build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("user");
            }
            return "Cannot build GuildScheduledEventUserData, some of required attributes are not set " + attributes;
        }

        private Id guildScheduledEventId_build() {
            return this.guildScheduledEventId_id;
        }

        private Possible<PartialMemberData> member_build() {
            return this.member_possible;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements GuildScheduledEventUserData {
        @Nullable
        Id guildScheduledEventId;
        @Nullable
        UserData user;
        Possible<PartialMemberData> member = Possible.absent();

        Json() {
        }

        @JsonProperty(value="guild_scheduled_event_id")
        public void setGuildScheduledEventId(Id guildScheduledEventId) {
            this.guildScheduledEventId = guildScheduledEventId;
        }

        @JsonProperty(value="user")
        public void setUser(UserData user) {
            this.user = user;
        }

        @JsonProperty(value="member")
        public void setMember(Possible<PartialMemberData> member) {
            this.member = member;
        }

        @Override
        public Id guildScheduledEventId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UserData user() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<PartialMemberData> member() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build GuildScheduledEventUserData, attribute initializers form cycle " + attributes;
        }
    }
}

