/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.BanData;
import discord4j.discordjson.json.UserData;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class ImmutableBanData
implements BanData {
    @Nullable
    private final String reason;
    private final UserData user;

    private ImmutableBanData(Optional<String> reason, UserData user) {
        this.reason = reason.orElse(null);
        this.user = Objects.requireNonNull(user, "user");
    }

    private ImmutableBanData(ImmutableBanData original, @Nullable String reason, UserData user) {
        this.reason = reason;
        this.user = user;
    }

    @Override
    @JsonProperty(value="reason")
    public Optional<String> reason() {
        return Optional.ofNullable(this.reason);
    }

    @Override
    @JsonProperty(value="user")
    public UserData user() {
        return this.user;
    }

    public final ImmutableBanData withReason(String value) {
        String newValue = Objects.requireNonNull(value, "reason");
        if (Objects.equals(this.reason, newValue)) {
            return this;
        }
        return new ImmutableBanData(this, newValue, this.user);
    }

    public final ImmutableBanData withReason(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.reason, value)) {
            return this;
        }
        return new ImmutableBanData(this, value, this.user);
    }

    public final ImmutableBanData withUser(UserData value) {
        if (this.user == value) {
            return this;
        }
        UserData newValue = Objects.requireNonNull(value, "user");
        return new ImmutableBanData(this, this.reason, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBanData && this.equalTo(0, (ImmutableBanData)another);
    }

    private boolean equalTo(int synthetic, ImmutableBanData another) {
        return Objects.equals(this.reason, another.reason) && this.user.equals(another.user);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.reason);
        h += (h << 5) + this.user.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("BanData{");
        if (this.reason != null) {
            builder.append("reason=").append(this.reason);
        }
        if (builder.length() > 8) {
            builder.append(", ");
        }
        builder.append("user=").append(this.user);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableBanData fromJson(Json json) {
        Builder builder = ImmutableBanData.builder();
        if (json.reason != null) {
            builder.reason(json.reason);
        }
        if (json.user != null) {
            builder.user(json.user);
        }
        return builder.build();
    }

    public static ImmutableBanData of(Optional<String> reason, UserData user) {
        return new ImmutableBanData(reason, user);
    }

    public static ImmutableBanData copyOf(BanData instance) {
        if (instance instanceof ImmutableBanData) {
            return (ImmutableBanData)instance;
        }
        return ImmutableBanData.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_USER = 1L;
        private long initBits = 1L;
        @Nullable
        private String reason;
        @Nullable
        private UserData user;

        private Builder() {
        }

        public final Builder from(BanData instance) {
            Objects.requireNonNull(instance, "instance");
            Optional<String> reasonOptional = instance.reason();
            if (reasonOptional.isPresent()) {
                this.reason(reasonOptional);
            }
            this.user(instance.user());
            return this;
        }

        public final Builder reason(String reason) {
            this.reason = Objects.requireNonNull(reason, "reason");
            return this;
        }

        @JsonProperty(value="reason")
        public final Builder reason(Optional<String> reason) {
            this.reason = reason.orElse(null);
            return this;
        }

        @JsonProperty(value="user")
        public final Builder user(UserData user) {
            this.user = Objects.requireNonNull(user, "user");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableBanData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBanData(null, this.reason, this.user);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("user");
            }
            return "Cannot build BanData, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements BanData {
        @Nullable
        Optional<String> reason = Optional.empty();
        @Nullable
        UserData user;

        Json() {
        }

        @JsonProperty(value="reason")
        public void setReason(Optional<String> reason) {
            this.reason = reason;
        }

        @JsonProperty(value="user")
        public void setUser(UserData user) {
            this.user = user;
        }

        @Override
        public Optional<String> reason() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UserData user() {
            throw new UnsupportedOperationException();
        }
    }
}

