/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.ApplicationTeamData;
import discord4j.discordjson.json.ApplicationTeamMemberData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class ImmutableApplicationTeamData
implements ApplicationTeamData {
    @Nullable
    private final String icon;
    private final long id_value;
    private final List<ApplicationTeamMemberData> members;
    private final String name;
    private final long ownerUserId_value;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableApplicationTeamData(Optional<String> icon, Id id, Iterable<? extends ApplicationTeamMemberData> members, String name, Id ownerUserId) {
        this.icon = icon.orElse(null);
        Id id$impl = id;
        this.members = ImmutableApplicationTeamData.createUnmodifiableList(false, ImmutableApplicationTeamData.createSafeList(members, true, false));
        this.name = Objects.requireNonNull(name, "name");
        Id ownerUserId$impl = ownerUserId;
        this.id_value = id$impl.asLong();
        this.ownerUserId_value = ownerUserId$impl.asLong();
        this.initShim = null;
    }

    private ImmutableApplicationTeamData(ImmutableApplicationTeamData original, @Nullable String icon, Id id, List<ApplicationTeamMemberData> members, String name, Id ownerUserId) {
        this.icon = icon;
        Id id$impl = id;
        this.members = members;
        this.name = name;
        Id ownerUserId$impl = ownerUserId;
        this.id_value = id$impl.asLong();
        this.ownerUserId_value = ownerUserId$impl.asLong();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="icon")
    public Optional<String> icon() {
        return Optional.ofNullable(this.icon);
    }

    @Override
    @JsonProperty(value="id")
    public Id id() {
        return Id.of((long)this.id_value);
    }

    @Override
    @JsonProperty(value="members")
    public List<ApplicationTeamMemberData> members() {
        return this.members;
    }

    @Override
    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="owner_user_id")
    public Id ownerUserId() {
        return Id.of((long)this.ownerUserId_value);
    }

    public final ImmutableApplicationTeamData withIcon(String value) {
        String newValue = Objects.requireNonNull(value, "icon");
        if (Objects.equals(this.icon, newValue)) {
            return this;
        }
        return new ImmutableApplicationTeamData(this, newValue, this.id(), this.members, this.name, this.ownerUserId());
    }

    public final ImmutableApplicationTeamData withIcon(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.icon, value)) {
            return this;
        }
        return new ImmutableApplicationTeamData(this, value, this.id(), this.members, this.name, this.ownerUserId());
    }

    public ImmutableApplicationTeamData withId(long value) {
        Id newValue = Id.of((long)value);
        return new ImmutableApplicationTeamData(this, this.icon, newValue, this.members, this.name, this.ownerUserId());
    }

    public ImmutableApplicationTeamData withId(String value) {
        Id newValue = Id.of((String)value);
        return new ImmutableApplicationTeamData(this, this.icon, newValue, this.members, this.name, this.ownerUserId());
    }

    public final ImmutableApplicationTeamData withMembers(ApplicationTeamMemberData ... elements) {
        List<ApplicationTeamMemberData> newValue = ImmutableApplicationTeamData.createUnmodifiableList(false, ImmutableApplicationTeamData.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableApplicationTeamData(this, this.icon, this.id(), newValue, this.name, this.ownerUserId());
    }

    public final ImmutableApplicationTeamData withMembers(Iterable<? extends ApplicationTeamMemberData> elements) {
        if (this.members == elements) {
            return this;
        }
        List<ApplicationTeamMemberData> newValue = ImmutableApplicationTeamData.createUnmodifiableList(false, ImmutableApplicationTeamData.createSafeList(elements, true, false));
        return new ImmutableApplicationTeamData(this, this.icon, this.id(), newValue, this.name, this.ownerUserId());
    }

    public final ImmutableApplicationTeamData withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableApplicationTeamData(this, this.icon, this.id(), this.members, newValue, this.ownerUserId());
    }

    public ImmutableApplicationTeamData withOwnerUserId(long value) {
        Id newValue = Id.of((long)value);
        return new ImmutableApplicationTeamData(this, this.icon, this.id(), this.members, this.name, newValue);
    }

    public ImmutableApplicationTeamData withOwnerUserId(String value) {
        Id newValue = Id.of((String)value);
        return new ImmutableApplicationTeamData(this, this.icon, this.id(), this.members, this.name, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableApplicationTeamData && this.equalTo(0, (ImmutableApplicationTeamData)another);
    }

    private boolean equalTo(int synthetic, ImmutableApplicationTeamData another) {
        return Objects.equals(this.icon, another.icon) && Objects.equals(this.id_value, another.id_value) && this.members.equals(another.members) && this.name.equals(another.name) && Objects.equals(this.ownerUserId_value, another.ownerUserId_value);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.icon);
        h += (h << 5) + Objects.hashCode(this.id_value);
        h += (h << 5) + this.members.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Objects.hashCode(this.ownerUserId_value);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ApplicationTeamData{");
        if (this.icon != null) {
            builder.append("icon=").append(this.icon);
        }
        if (builder.length() > 20) {
            builder.append(", ");
        }
        builder.append("id=").append(Objects.toString(this.id_value));
        builder.append(", ");
        builder.append("members=").append(this.members);
        builder.append(", ");
        builder.append("name=").append(this.name);
        builder.append(", ");
        builder.append("ownerUserId=").append(Objects.toString(this.ownerUserId_value));
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableApplicationTeamData fromJson(Json json) {
        Builder builder = ImmutableApplicationTeamData.builder();
        if (json.icon != null) {
            builder.icon(json.icon);
        }
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.members != null) {
            builder.addAllMembers(json.members);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.ownerUserId != null) {
            builder.ownerUserId(json.ownerUserId);
        }
        return builder.build();
    }

    public static ImmutableApplicationTeamData of(Optional<String> icon, Id id, List<ApplicationTeamMemberData> members, String name, Id ownerUserId) {
        return ImmutableApplicationTeamData.of(icon, id, members, name, ownerUserId);
    }

    public static ImmutableApplicationTeamData of(Optional<String> icon, Id id, Iterable<? extends ApplicationTeamMemberData> members, String name, Id ownerUserId) {
        return new ImmutableApplicationTeamData(icon, id, members, name, ownerUserId);
    }

    public static ImmutableApplicationTeamData copyOf(ApplicationTeamData instance) {
        if (instance instanceof ImmutableApplicationTeamData) {
            return (ImmutableApplicationTeamData)instance;
        }
        return ImmutableApplicationTeamData.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private long initBits = 1L;
        private Id id_id = null;
        private Id ownerUserId_id = null;
        @Nullable
        private String icon;
        private List<ApplicationTeamMemberData> members = new ArrayList<ApplicationTeamMemberData>();
        @Nullable
        private String name;

        private Builder() {
        }

        public final Builder from(ApplicationTeamData instance) {
            Objects.requireNonNull(instance, "instance");
            Optional<String> iconOptional = instance.icon();
            if (iconOptional.isPresent()) {
                this.icon(iconOptional);
            }
            this.id(instance.id());
            this.addAllMembers(instance.members());
            this.name(instance.name());
            this.ownerUserId(instance.ownerUserId());
            return this;
        }

        public final Builder icon(String icon) {
            this.icon = Objects.requireNonNull(icon, "icon");
            return this;
        }

        @JsonProperty(value="icon")
        public final Builder icon(Optional<String> icon) {
            this.icon = icon.orElse(null);
            return this;
        }

        public Builder id(String value) {
            this.id_id = Id.of((String)value);
            return this;
        }

        public Builder id(long value) {
            this.id_id = Id.of((long)value);
            return this;
        }

        @JsonProperty(value="id")
        public Builder id(Id value) {
            this.id_id = value;
            return this;
        }

        public final Builder addMember(ApplicationTeamMemberData element) {
            this.members.add(Objects.requireNonNull(element, "members element"));
            return this;
        }

        public final Builder addMembers(ApplicationTeamMemberData ... elements) {
            for (ApplicationTeamMemberData element : elements) {
                this.members.add(Objects.requireNonNull(element, "members element"));
            }
            return this;
        }

        @JsonProperty(value="members")
        public final Builder members(Iterable<? extends ApplicationTeamMemberData> elements) {
            this.members.clear();
            return this.addAllMembers(elements);
        }

        public final Builder addAllMembers(Iterable<? extends ApplicationTeamMemberData> elements) {
            for (ApplicationTeamMemberData applicationTeamMemberData : elements) {
                this.members.add(Objects.requireNonNull(applicationTeamMemberData, "members element"));
            }
            return this;
        }

        @JsonProperty(value="name")
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public Builder ownerUserId(String value) {
            this.ownerUserId_id = Id.of((String)value);
            return this;
        }

        public Builder ownerUserId(long value) {
            this.ownerUserId_id = Id.of((long)value);
            return this;
        }

        @JsonProperty(value="owner_user_id")
        public Builder ownerUserId(Id value) {
            this.ownerUserId_id = value;
            return this;
        }

        public ImmutableApplicationTeamData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableApplicationTeamData(null, this.icon, this.id_build(), ImmutableApplicationTeamData.createUnmodifiableList(true, this.members), this.name, this.ownerUserId_build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build ApplicationTeamData, some of required attributes are not set " + attributes;
        }

        private Id id_build() {
            return this.id_id;
        }

        private Id ownerUserId_build() {
            return this.ownerUserId_id;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements ApplicationTeamData {
        @Nullable
        Optional<String> icon = Optional.empty();
        @Nullable
        Id id;
        @Nullable
        List<ApplicationTeamMemberData> members = Collections.emptyList();
        @Nullable
        String name;
        @Nullable
        Id ownerUserId;

        Json() {
        }

        @JsonProperty(value="icon")
        public void setIcon(Optional<String> icon) {
            this.icon = icon;
        }

        @JsonProperty(value="id")
        public void setId(Id id) {
            this.id = id;
        }

        @JsonProperty(value="members")
        public void setMembers(List<ApplicationTeamMemberData> members) {
            this.members = members;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="owner_user_id")
        public void setOwnerUserId(Id ownerUserId) {
            this.ownerUserId = ownerUserId;
        }

        @Override
        public Optional<String> icon() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Id id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<ApplicationTeamMemberData> members() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Id ownerUserId() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build ApplicationTeamData, attribute initializers form cycle " + attributes;
        }
    }
}

