/*
 * Decompiled with CFR 0.152.
 */
package discord4j.gateway.json;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import discord4j.discordjson.json.gateway.Heartbeat;
import discord4j.discordjson.json.gateway.Identify;
import discord4j.discordjson.json.gateway.Opcode;
import discord4j.discordjson.json.gateway.OpcodeConverter;
import discord4j.discordjson.json.gateway.PayloadData;
import discord4j.discordjson.json.gateway.RequestGuildMembers;
import discord4j.discordjson.json.gateway.RequestSoundboardSounds;
import discord4j.discordjson.json.gateway.Resume;
import discord4j.discordjson.json.gateway.StatusUpdate;
import discord4j.discordjson.json.gateway.VoiceStateUpdate;
import discord4j.gateway.json.jackson.PayloadDeserializer;
import java.util.Objects;
import reactor.util.annotation.Nullable;

@JsonDeserialize(using=PayloadDeserializer.class)
public class GatewayPayload<T extends PayloadData> {
    @JsonSerialize(converter=OpcodeConverter.class)
    private Opcode<T> op;
    @JsonProperty(value="d")
    @Nullable
    private T data;
    @JsonProperty(value="s")
    @Nullable
    private Integer sequence;
    @JsonProperty(value="t")
    @Nullable
    private String type;

    public GatewayPayload(Opcode<T> op, @Nullable T data, @Nullable Integer sequence, @Nullable String type) {
        this.op = op;
        this.data = data;
        this.sequence = sequence;
        this.type = type;
    }

    public static GatewayPayload<Heartbeat> heartbeat(Heartbeat data) {
        return new GatewayPayload<Heartbeat>(Opcode.HEARTBEAT, data, null, null);
    }

    public static GatewayPayload<Identify> identify(Identify data) {
        return new GatewayPayload<Identify>(Opcode.IDENTIFY, data, null, null);
    }

    public static GatewayPayload<StatusUpdate> statusUpdate(StatusUpdate data) {
        return new GatewayPayload<StatusUpdate>(Opcode.STATUS_UPDATE, data, null, null);
    }

    public static GatewayPayload<VoiceStateUpdate> voiceStateUpdate(VoiceStateUpdate data) {
        return new GatewayPayload<VoiceStateUpdate>(Opcode.VOICE_STATE_UPDATE, data, null, null);
    }

    public static GatewayPayload<Resume> resume(Resume data) {
        return new GatewayPayload<Resume>(Opcode.RESUME, data, null, null);
    }

    public static GatewayPayload<RequestGuildMembers> requestGuildMembers(RequestGuildMembers data) {
        return new GatewayPayload<RequestGuildMembers>(Opcode.REQUEST_GUILD_MEMBERS, data, null, null);
    }

    public static GatewayPayload<RequestSoundboardSounds> requestSoundboardSounds(RequestSoundboardSounds data) {
        return new GatewayPayload<RequestSoundboardSounds>(Opcode.REQUEST_SOUNDBOARD_SOUNDS, data, null, null);
    }

    public Opcode<T> getOp() {
        return this.op;
    }

    @Nullable
    public T getData() {
        return this.data;
    }

    @Nullable
    public Integer getSequence() {
        return this.sequence;
    }

    @Nullable
    public String getType() {
        return this.type;
    }

    public int hashCode() {
        return Objects.hash(this.op, this.data, this.sequence, this.type);
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == null || obj.getClass() != GatewayPayload.class) {
            return false;
        }
        GatewayPayload other = (GatewayPayload)obj;
        return this.op == other.op && Objects.equals(this.data, other.data) && Objects.equals(this.sequence, other.sequence) && Objects.equals(this.type, other.type);
    }

    public String toString() {
        return "GatewayPayload{op=" + this.op + ", data=" + this.data + ", sequence=" + this.sequence + ", type='" + this.type + '\'' + '}';
    }
}

