/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json.gateway;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.gateway.MessagePollVoteRemove;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ImmutableMessagePollVoteRemove
implements MessagePollVoteRemove {
    private final long userId_value;
    private final long channelId_value;
    private final long messageId_value;
    private final long guildId_value;
    private final boolean guildId_absent;
    private final int answerId;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableMessagePollVoteRemove(Id userId, Id channelId, Id messageId, Possible<Id> guildId, int answerId) {
        Id userId$impl = userId;
        Id channelId$impl = channelId;
        Id messageId$impl = messageId;
        Possible<Id> guildId$impl = guildId;
        this.answerId = answerId;
        this.userId_value = userId$impl.asLong();
        this.channelId_value = channelId$impl.asLong();
        this.messageId_value = messageId$impl.asLong();
        this.guildId_value = guildId$impl.toOptional().map(Id::asLong).orElse(0L);
        this.guildId_absent = guildId$impl.isAbsent();
        this.initShim = null;
    }

    private ImmutableMessagePollVoteRemove(ImmutableMessagePollVoteRemove original, Id userId, Id channelId, Id messageId, Possible<Id> guildId, int answerId) {
        Id userId$impl = userId;
        Id channelId$impl = channelId;
        Id messageId$impl = messageId;
        Possible<Id> guildId$impl = guildId;
        this.answerId = answerId;
        this.userId_value = userId$impl.asLong();
        this.channelId_value = channelId$impl.asLong();
        this.messageId_value = messageId$impl.asLong();
        this.guildId_value = guildId$impl.toOptional().map(Id::asLong).orElse(0L);
        this.guildId_absent = guildId$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="user_id")
    public Id userId() {
        return Id.of((long)this.userId_value);
    }

    @Override
    @JsonProperty(value="channel_id")
    public Id channelId() {
        return Id.of((long)this.channelId_value);
    }

    @Override
    @JsonProperty(value="message_id")
    public Id messageId() {
        return Id.of((long)this.messageId_value);
    }

    @Override
    @JsonProperty(value="guild_id")
    public Possible<Id> guildId() {
        return this.guildId_absent ? Possible.absent() : Possible.of((Object)Id.of((long)this.guildId_value));
    }

    @Override
    @JsonProperty(value="answer_id")
    public int answerId() {
        return this.answerId;
    }

    public ImmutableMessagePollVoteRemove withUserId(long value) {
        Id newValue = Id.of((long)value);
        return new ImmutableMessagePollVoteRemove(this, newValue, this.channelId(), this.messageId(), this.guildId(), this.answerId);
    }

    public ImmutableMessagePollVoteRemove withUserId(String value) {
        Id newValue = Id.of((String)value);
        return new ImmutableMessagePollVoteRemove(this, newValue, this.channelId(), this.messageId(), this.guildId(), this.answerId);
    }

    public ImmutableMessagePollVoteRemove withChannelId(long value) {
        Id newValue = Id.of((long)value);
        return new ImmutableMessagePollVoteRemove(this, this.userId(), newValue, this.messageId(), this.guildId(), this.answerId);
    }

    public ImmutableMessagePollVoteRemove withChannelId(String value) {
        Id newValue = Id.of((String)value);
        return new ImmutableMessagePollVoteRemove(this, this.userId(), newValue, this.messageId(), this.guildId(), this.answerId);
    }

    public ImmutableMessagePollVoteRemove withMessageId(long value) {
        Id newValue = Id.of((long)value);
        return new ImmutableMessagePollVoteRemove(this, this.userId(), this.channelId(), newValue, this.guildId(), this.answerId);
    }

    public ImmutableMessagePollVoteRemove withMessageId(String value) {
        Id newValue = Id.of((String)value);
        return new ImmutableMessagePollVoteRemove(this, this.userId(), this.channelId(), newValue, this.guildId(), this.answerId);
    }

    public ImmutableMessagePollVoteRemove withGuildId(Possible<Id> value) {
        Possible<Id> newValue = Objects.requireNonNull(value);
        return new ImmutableMessagePollVoteRemove(this, this.userId(), this.channelId(), this.messageId(), newValue, this.answerId);
    }

    public ImmutableMessagePollVoteRemove withGuildId(long value) {
        Possible newValue = Possible.of((Object)Id.of((long)value));
        return new ImmutableMessagePollVoteRemove(this, this.userId(), this.channelId(), this.messageId(), (Possible<Id>)newValue, this.answerId);
    }

    public final ImmutableMessagePollVoteRemove withAnswerId(int value) {
        if (this.answerId == value) {
            return this;
        }
        return new ImmutableMessagePollVoteRemove(this, this.userId(), this.channelId(), this.messageId(), this.guildId(), value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessagePollVoteRemove && this.equalTo(0, (ImmutableMessagePollVoteRemove)another);
    }

    private boolean equalTo(int synthetic, ImmutableMessagePollVoteRemove another) {
        return Objects.equals(this.userId_value, another.userId_value) && Objects.equals(this.channelId_value, another.channelId_value) && Objects.equals(this.messageId_value, another.messageId_value) && this.guildId().equals(another.guildId()) && this.answerId == another.answerId;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.userId_value);
        h += (h << 5) + Objects.hashCode(this.channelId_value);
        h += (h << 5) + Objects.hashCode(this.messageId_value);
        h += (h << 5) + this.guildId().hashCode();
        h += (h << 5) + this.answerId;
        return h;
    }

    public String toString() {
        return "MessagePollVoteRemove{userId=" + Objects.toString(this.userId_value) + ", channelId=" + Objects.toString(this.channelId_value) + ", messageId=" + Objects.toString(this.messageId_value) + ", guildId=" + this.guildId().toString() + ", answerId=" + this.answerId + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableMessagePollVoteRemove fromJson(Json json) {
        Builder builder = ImmutableMessagePollVoteRemove.builder();
        if (json.userId != null) {
            builder.userId(json.userId);
        }
        if (json.channelId != null) {
            builder.channelId(json.channelId);
        }
        if (json.messageId != null) {
            builder.messageId(json.messageId);
        }
        if (json.guildId != null) {
            builder.guildId(json.guildId);
        }
        if (json.answerIdIsSet) {
            builder.answerId(json.answerId);
        }
        return builder.build();
    }

    public static ImmutableMessagePollVoteRemove of(Id userId, Id channelId, Id messageId, Possible<Id> guildId, int answerId) {
        return new ImmutableMessagePollVoteRemove(userId, channelId, messageId, guildId, answerId);
    }

    public static ImmutableMessagePollVoteRemove copyOf(MessagePollVoteRemove instance) {
        if (instance instanceof ImmutableMessagePollVoteRemove) {
            return (ImmutableMessagePollVoteRemove)instance;
        }
        return ImmutableMessagePollVoteRemove.builder().from(instance).build();
    }

    public boolean isGuildIdPresent() {
        return !this.guildId_absent;
    }

    public long guildIdOrElse(long defaultValue) {
        return !this.guildId_absent ? this.guildId_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ANSWER_ID = 1L;
        private long initBits = 1L;
        private Id userId_id = null;
        private Id channelId_id = null;
        private Id messageId_id = null;
        private Possible<Id> guildId_possible = Possible.absent();
        private int answerId;

        private Builder() {
        }

        public final Builder from(MessagePollVoteRemove instance) {
            Objects.requireNonNull(instance, "instance");
            this.userId(instance.userId());
            this.channelId(instance.channelId());
            this.messageId(instance.messageId());
            this.guildId(instance.guildId());
            this.answerId(instance.answerId());
            return this;
        }

        public Builder userId(String value) {
            this.userId_id = Id.of((String)value);
            return this;
        }

        public Builder userId(long value) {
            this.userId_id = Id.of((long)value);
            return this;
        }

        @JsonProperty(value="user_id")
        public Builder userId(Id value) {
            this.userId_id = value;
            return this;
        }

        public Builder channelId(String value) {
            this.channelId_id = Id.of((String)value);
            return this;
        }

        public Builder channelId(long value) {
            this.channelId_id = Id.of((long)value);
            return this;
        }

        @JsonProperty(value="channel_id")
        public Builder channelId(Id value) {
            this.channelId_id = value;
            return this;
        }

        public Builder messageId(String value) {
            this.messageId_id = Id.of((String)value);
            return this;
        }

        public Builder messageId(long value) {
            this.messageId_id = Id.of((long)value);
            return this;
        }

        @JsonProperty(value="message_id")
        public Builder messageId(Id value) {
            this.messageId_id = value;
            return this;
        }

        public Builder guildId(String value) {
            this.guildId_possible = Possible.of((Object)Id.of((String)value));
            return this;
        }

        public Builder guildId(long value) {
            this.guildId_possible = Possible.of((Object)Id.of((long)value));
            return this;
        }

        public Builder guildId(Id value) {
            this.guildId_possible = Possible.of((Object)value);
            return this;
        }

        @JsonProperty(value="guild_id")
        public Builder guildId(Possible<Id> value) {
            this.guildId_possible = value;
            return this;
        }

        @JsonProperty(value="answer_id")
        public final Builder answerId(int answerId) {
            this.answerId = answerId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableMessagePollVoteRemove build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMessagePollVoteRemove(null, this.userId_build(), this.channelId_build(), this.messageId_build(), this.guildId_build(), this.answerId);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("answerId");
            }
            return "Cannot build MessagePollVoteRemove, some of required attributes are not set " + attributes;
        }

        private Id userId_build() {
            return this.userId_id;
        }

        private Id channelId_build() {
            return this.channelId_id;
        }

        private Id messageId_build() {
            return this.messageId_id;
        }

        private Possible<Id> guildId_build() {
            return this.guildId_possible;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements MessagePollVoteRemove {
        @Nullable
        Id userId;
        @Nullable
        Id channelId;
        @Nullable
        Id messageId;
        Possible<Id> guildId = Possible.absent();
        int answerId;
        boolean answerIdIsSet;

        Json() {
        }

        @JsonProperty(value="user_id")
        public void setUserId(Id userId) {
            this.userId = userId;
        }

        @JsonProperty(value="channel_id")
        public void setChannelId(Id channelId) {
            this.channelId = channelId;
        }

        @JsonProperty(value="message_id")
        public void setMessageId(Id messageId) {
            this.messageId = messageId;
        }

        @JsonProperty(value="guild_id")
        public void setGuildId(Possible<Id> guildId) {
            this.guildId = guildId;
        }

        @JsonProperty(value="answer_id")
        public void setAnswerId(int answerId) {
            this.answerId = answerId;
            this.answerIdIsSet = true;
        }

        @Override
        public Id userId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Id channelId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Id messageId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Id> guildId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int answerId() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build MessagePollVoteRemove, attribute initializers form cycle " + attributes;
        }
    }
}

