/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json.gateway;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.InteractionData;
import discord4j.discordjson.json.gateway.InteractionCreate;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ImmutableInteractionCreate
implements InteractionCreate {
    private final InteractionData interaction;

    private ImmutableInteractionCreate(InteractionData interaction) {
        this.interaction = Objects.requireNonNull(interaction, "interaction");
    }

    private ImmutableInteractionCreate(ImmutableInteractionCreate original, InteractionData interaction) {
        this.interaction = interaction;
    }

    @Override
    @JsonProperty(value="interaction")
    @JsonUnwrapped
    public InteractionData interaction() {
        return this.interaction;
    }

    public final ImmutableInteractionCreate withInteraction(InteractionData value) {
        if (this.interaction == value) {
            return this;
        }
        InteractionData newValue = Objects.requireNonNull(value, "interaction");
        return new ImmutableInteractionCreate(this, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInteractionCreate && this.equalTo(0, (ImmutableInteractionCreate)another);
    }

    private boolean equalTo(int synthetic, ImmutableInteractionCreate another) {
        return this.interaction.equals(another.interaction);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.interaction.hashCode();
        return h;
    }

    public String toString() {
        return "InteractionCreate{interaction=" + this.interaction + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableInteractionCreate fromJson(Json json) {
        Builder builder = ImmutableInteractionCreate.builder();
        if (json.interaction != null) {
            builder.interaction(json.interaction);
        }
        return builder.build();
    }

    public static ImmutableInteractionCreate of(InteractionData interaction) {
        return new ImmutableInteractionCreate(interaction);
    }

    public static ImmutableInteractionCreate copyOf(InteractionCreate instance) {
        if (instance instanceof ImmutableInteractionCreate) {
            return (ImmutableInteractionCreate)instance;
        }
        return ImmutableInteractionCreate.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_INTERACTION = 1L;
        private long initBits = 1L;
        @Nullable
        private InteractionData interaction;

        private Builder() {
        }

        public final Builder from(InteractionCreate instance) {
            Objects.requireNonNull(instance, "instance");
            this.interaction(instance.interaction());
            return this;
        }

        @JsonProperty(value="interaction")
        @JsonUnwrapped
        public final Builder interaction(InteractionData interaction) {
            this.interaction = Objects.requireNonNull(interaction, "interaction");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableInteractionCreate build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInteractionCreate(null, this.interaction);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("interaction");
            }
            return "Cannot build InteractionCreate, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements InteractionCreate {
        @Nullable
        InteractionData interaction;

        Json() {
        }

        @JsonProperty(value="interaction")
        @JsonUnwrapped
        public void setInteraction(InteractionData interaction) {
            this.interaction = interaction;
        }

        @Override
        public InteractionData interaction() {
            throw new UnsupportedOperationException();
        }
    }
}

