/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json.gateway;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.EntitlementData;
import discord4j.discordjson.json.gateway.EntitlementUpdate;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ImmutableEntitlementUpdate
implements EntitlementUpdate {
    private final EntitlementData entitlement;

    private ImmutableEntitlementUpdate(EntitlementData entitlement) {
        this.entitlement = Objects.requireNonNull(entitlement, "entitlement");
    }

    private ImmutableEntitlementUpdate(ImmutableEntitlementUpdate original, EntitlementData entitlement) {
        this.entitlement = entitlement;
    }

    @Override
    @JsonProperty(value="entitlement")
    @JsonUnwrapped
    public EntitlementData entitlement() {
        return this.entitlement;
    }

    public final ImmutableEntitlementUpdate withEntitlement(EntitlementData value) {
        if (this.entitlement == value) {
            return this;
        }
        EntitlementData newValue = Objects.requireNonNull(value, "entitlement");
        return new ImmutableEntitlementUpdate(this, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEntitlementUpdate && this.equalTo(0, (ImmutableEntitlementUpdate)another);
    }

    private boolean equalTo(int synthetic, ImmutableEntitlementUpdate another) {
        return this.entitlement.equals(another.entitlement);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.entitlement.hashCode();
        return h;
    }

    public String toString() {
        return "EntitlementUpdate{entitlement=" + this.entitlement + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableEntitlementUpdate fromJson(Json json) {
        Builder builder = ImmutableEntitlementUpdate.builder();
        if (json.entitlement != null) {
            builder.entitlement(json.entitlement);
        }
        return builder.build();
    }

    public static ImmutableEntitlementUpdate of(EntitlementData entitlement) {
        return new ImmutableEntitlementUpdate(entitlement);
    }

    public static ImmutableEntitlementUpdate copyOf(EntitlementUpdate instance) {
        if (instance instanceof ImmutableEntitlementUpdate) {
            return (ImmutableEntitlementUpdate)instance;
        }
        return ImmutableEntitlementUpdate.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ENTITLEMENT = 1L;
        private long initBits = 1L;
        @Nullable
        private EntitlementData entitlement;

        private Builder() {
        }

        public final Builder from(EntitlementUpdate instance) {
            Objects.requireNonNull(instance, "instance");
            this.entitlement(instance.entitlement());
            return this;
        }

        @JsonProperty(value="entitlement")
        @JsonUnwrapped
        public final Builder entitlement(EntitlementData entitlement) {
            this.entitlement = Objects.requireNonNull(entitlement, "entitlement");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableEntitlementUpdate build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableEntitlementUpdate(null, this.entitlement);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("entitlement");
            }
            return "Cannot build EntitlementUpdate, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements EntitlementUpdate {
        @Nullable
        EntitlementData entitlement;

        Json() {
        }

        @JsonProperty(value="entitlement")
        @JsonUnwrapped
        public void setEntitlement(EntitlementData entitlement) {
            this.entitlement = entitlement;
        }

        @Override
        public EntitlementData entitlement() {
            throw new UnsupportedOperationException();
        }
    }
}

