/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.AvatarDecorationData;
import discord4j.discordjson.json.UserData;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class ImmutableUserData
implements UserData {
    private final long id_value;
    @Nullable
    private final String globalName;
    private final String username;
    private final String discriminator;
    @Nullable
    private final String avatar;
    private final String banner_value;
    private final boolean banner_absent;
    private final Integer accentColor_value;
    private final boolean accentColor_absent;
    private final Boolean bot_value;
    private final boolean bot_absent;
    private final Boolean system_value;
    private final boolean system_absent;
    private final Boolean mfaEnabled_value;
    private final boolean mfaEnabled_absent;
    private final String locale_value;
    private final boolean locale_absent;
    private final Boolean verified_value;
    private final boolean verified_absent;
    private final String email_value;
    private final boolean email_absent;
    private final Long flags_value;
    private final boolean flags_absent;
    private final Integer premiumType_value;
    private final boolean premiumType_absent;
    private final Long publicFlags_value;
    private final boolean publicFlags_absent;
    private final AvatarDecorationData avatarDecoration_value;
    private final boolean avatarDecoration_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableUserData(Id id, Optional<String> globalName, String username, String discriminator, Optional<String> avatar, Possible<Optional<String>> banner, Possible<Optional<Integer>> accentColor, Possible<Boolean> bot, Possible<Boolean> system, Possible<Boolean> mfaEnabled, Possible<String> locale, Possible<Boolean> verified, Possible<Optional<String>> email, Possible<Long> flags, Possible<Integer> premiumType, Possible<Long> publicFlags, Possible<Optional<AvatarDecorationData>> avatarDecoration) {
        Id id$impl = id;
        this.globalName = globalName.orElse(null);
        this.username = Objects.requireNonNull(username, "username");
        this.discriminator = Objects.requireNonNull(discriminator, "discriminator");
        this.avatar = avatar.orElse(null);
        Possible<Optional<String>> banner$impl = banner;
        Possible<Optional<Integer>> accentColor$impl = accentColor;
        Possible<Boolean> bot$impl = bot;
        Possible<Boolean> system$impl = system;
        Possible<Boolean> mfaEnabled$impl = mfaEnabled;
        Possible<String> locale$impl = locale;
        Possible<Boolean> verified$impl = verified;
        Possible<Optional<String>> email$impl = email;
        Possible<Long> flags$impl = flags;
        Possible<Integer> premiumType$impl = premiumType;
        Possible<Long> publicFlags$impl = publicFlags;
        Possible<Optional<AvatarDecorationData>> avatarDecoration$impl = avatarDecoration;
        this.id_value = id$impl.asLong();
        this.banner_value = Possible.flatOpt(banner$impl).orElse(null);
        this.banner_absent = banner$impl.isAbsent();
        this.accentColor_value = Possible.flatOpt(accentColor$impl).orElse(null);
        this.accentColor_absent = accentColor$impl.isAbsent();
        this.bot_value = bot$impl.toOptional().orElse(null);
        this.bot_absent = bot$impl.isAbsent();
        this.system_value = system$impl.toOptional().orElse(null);
        this.system_absent = system$impl.isAbsent();
        this.mfaEnabled_value = mfaEnabled$impl.toOptional().orElse(null);
        this.mfaEnabled_absent = mfaEnabled$impl.isAbsent();
        this.locale_value = locale$impl.toOptional().orElse(null);
        this.locale_absent = locale$impl.isAbsent();
        this.verified_value = verified$impl.toOptional().orElse(null);
        this.verified_absent = verified$impl.isAbsent();
        this.email_value = Possible.flatOpt(email$impl).orElse(null);
        this.email_absent = email$impl.isAbsent();
        this.flags_value = flags$impl.toOptional().orElse(null);
        this.flags_absent = flags$impl.isAbsent();
        this.premiumType_value = premiumType$impl.toOptional().orElse(null);
        this.premiumType_absent = premiumType$impl.isAbsent();
        this.publicFlags_value = publicFlags$impl.toOptional().orElse(null);
        this.publicFlags_absent = publicFlags$impl.isAbsent();
        this.avatarDecoration_value = Possible.flatOpt(avatarDecoration$impl).orElse(null);
        this.avatarDecoration_absent = avatarDecoration$impl.isAbsent();
        this.initShim = null;
    }

    private ImmutableUserData(ImmutableUserData original, Id id, @Nullable String globalName, String username, String discriminator, @Nullable String avatar, Possible<Optional<String>> banner, Possible<Optional<Integer>> accentColor, Possible<Boolean> bot, Possible<Boolean> system, Possible<Boolean> mfaEnabled, Possible<String> locale, Possible<Boolean> verified, Possible<Optional<String>> email, Possible<Long> flags, Possible<Integer> premiumType, Possible<Long> publicFlags, Possible<Optional<AvatarDecorationData>> avatarDecoration) {
        Id id$impl = id;
        this.globalName = globalName;
        this.username = username;
        this.discriminator = discriminator;
        this.avatar = avatar;
        Possible<Optional<String>> banner$impl = banner;
        Possible<Optional<Integer>> accentColor$impl = accentColor;
        Possible<Boolean> bot$impl = bot;
        Possible<Boolean> system$impl = system;
        Possible<Boolean> mfaEnabled$impl = mfaEnabled;
        Possible<String> locale$impl = locale;
        Possible<Boolean> verified$impl = verified;
        Possible<Optional<String>> email$impl = email;
        Possible<Long> flags$impl = flags;
        Possible<Integer> premiumType$impl = premiumType;
        Possible<Long> publicFlags$impl = publicFlags;
        Possible<Optional<AvatarDecorationData>> avatarDecoration$impl = avatarDecoration;
        this.id_value = id$impl.asLong();
        this.banner_value = Possible.flatOpt(banner$impl).orElse(null);
        this.banner_absent = banner$impl.isAbsent();
        this.accentColor_value = Possible.flatOpt(accentColor$impl).orElse(null);
        this.accentColor_absent = accentColor$impl.isAbsent();
        this.bot_value = bot$impl.toOptional().orElse(null);
        this.bot_absent = bot$impl.isAbsent();
        this.system_value = system$impl.toOptional().orElse(null);
        this.system_absent = system$impl.isAbsent();
        this.mfaEnabled_value = mfaEnabled$impl.toOptional().orElse(null);
        this.mfaEnabled_absent = mfaEnabled$impl.isAbsent();
        this.locale_value = locale$impl.toOptional().orElse(null);
        this.locale_absent = locale$impl.isAbsent();
        this.verified_value = verified$impl.toOptional().orElse(null);
        this.verified_absent = verified$impl.isAbsent();
        this.email_value = Possible.flatOpt(email$impl).orElse(null);
        this.email_absent = email$impl.isAbsent();
        this.flags_value = flags$impl.toOptional().orElse(null);
        this.flags_absent = flags$impl.isAbsent();
        this.premiumType_value = premiumType$impl.toOptional().orElse(null);
        this.premiumType_absent = premiumType$impl.isAbsent();
        this.publicFlags_value = publicFlags$impl.toOptional().orElse(null);
        this.publicFlags_absent = publicFlags$impl.isAbsent();
        this.avatarDecoration_value = Possible.flatOpt(avatarDecoration$impl).orElse(null);
        this.avatarDecoration_absent = avatarDecoration$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="id")
    public Id id() {
        return Id.of((long)this.id_value);
    }

    @Override
    @JsonProperty(value="global_name")
    public Optional<String> globalName() {
        return Optional.ofNullable(this.globalName);
    }

    @Override
    @JsonProperty(value="username")
    public String username() {
        return this.username;
    }

    @Override
    @JsonProperty(value="discriminator")
    @Deprecated
    public String discriminator() {
        return this.discriminator;
    }

    @Override
    @JsonProperty(value="avatar")
    public Optional<String> avatar() {
        return Optional.ofNullable(this.avatar);
    }

    @Override
    @JsonProperty(value="banner")
    public Possible<Optional<String>> banner() {
        return this.banner_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.banner_value));
    }

    @Override
    @JsonProperty(value="accent_color")
    public Possible<Optional<Integer>> accentColor() {
        return this.accentColor_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.accentColor_value));
    }

    @Override
    @JsonProperty(value="bot")
    public Possible<Boolean> bot() {
        return this.bot_absent ? Possible.absent() : Possible.of((Object)this.bot_value);
    }

    @Override
    @JsonProperty(value="system")
    public Possible<Boolean> system() {
        return this.system_absent ? Possible.absent() : Possible.of((Object)this.system_value);
    }

    @Override
    @JsonProperty(value="mfa_enabled")
    public Possible<Boolean> mfaEnabled() {
        return this.mfaEnabled_absent ? Possible.absent() : Possible.of((Object)this.mfaEnabled_value);
    }

    @Override
    @JsonProperty(value="locale")
    public Possible<String> locale() {
        return this.locale_absent ? Possible.absent() : Possible.of((Object)this.locale_value);
    }

    @Override
    @JsonProperty(value="verified")
    public Possible<Boolean> verified() {
        return this.verified_absent ? Possible.absent() : Possible.of((Object)this.verified_value);
    }

    @Override
    @JsonProperty(value="email")
    public Possible<Optional<String>> email() {
        return this.email_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.email_value));
    }

    @Override
    @JsonProperty(value="flags")
    public Possible<Long> flags() {
        return this.flags_absent ? Possible.absent() : Possible.of((Object)this.flags_value);
    }

    @Override
    @JsonProperty(value="premium_type")
    public Possible<Integer> premiumType() {
        return this.premiumType_absent ? Possible.absent() : Possible.of((Object)this.premiumType_value);
    }

    @Override
    @JsonProperty(value="public_flags")
    public Possible<Long> publicFlags() {
        return this.publicFlags_absent ? Possible.absent() : Possible.of((Object)this.publicFlags_value);
    }

    @Override
    @JsonProperty(value="avatar_decoration_data")
    public Possible<Optional<AvatarDecorationData>> avatarDecoration() {
        return this.avatarDecoration_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.avatarDecoration_value));
    }

    public ImmutableUserData withId(long value) {
        Id newValue = Id.of((long)value);
        return new ImmutableUserData(this, newValue, this.globalName, this.username, this.discriminator, this.avatar, this.banner(), this.accentColor(), this.bot(), this.system(), this.mfaEnabled(), this.locale(), this.verified(), this.email(), this.flags(), this.premiumType(), this.publicFlags(), this.avatarDecoration());
    }

    public ImmutableUserData withId(String value) {
        Id newValue = Id.of((String)value);
        return new ImmutableUserData(this, newValue, this.globalName, this.username, this.discriminator, this.avatar, this.banner(), this.accentColor(), this.bot(), this.system(), this.mfaEnabled(), this.locale(), this.verified(), this.email(), this.flags(), this.premiumType(), this.publicFlags(), this.avatarDecoration());
    }

    public final ImmutableUserData withGlobalName(String value) {
        String newValue = Objects.requireNonNull(value, "globalName");
        if (Objects.equals(this.globalName, newValue)) {
            return this;
        }
        return new ImmutableUserData(this, this.id(), newValue, this.username, this.discriminator, this.avatar, this.banner(), this.accentColor(), this.bot(), this.system(), this.mfaEnabled(), this.locale(), this.verified(), this.email(), this.flags(), this.premiumType(), this.publicFlags(), this.avatarDecoration());
    }

    public final ImmutableUserData withGlobalName(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.globalName, value)) {
            return this;
        }
        return new ImmutableUserData(this, this.id(), value, this.username, this.discriminator, this.avatar, this.banner(), this.accentColor(), this.bot(), this.system(), this.mfaEnabled(), this.locale(), this.verified(), this.email(), this.flags(), this.premiumType(), this.publicFlags(), this.avatarDecoration());
    }

    public final ImmutableUserData withUsername(String value) {
        String newValue = Objects.requireNonNull(value, "username");
        if (this.username.equals(newValue)) {
            return this;
        }
        return new ImmutableUserData(this, this.id(), this.globalName, newValue, this.discriminator, this.avatar, this.banner(), this.accentColor(), this.bot(), this.system(), this.mfaEnabled(), this.locale(), this.verified(), this.email(), this.flags(), this.premiumType(), this.publicFlags(), this.avatarDecoration());
    }

    @Deprecated
    public final ImmutableUserData withDiscriminator(String value) {
        String newValue = Objects.requireNonNull(value, "discriminator");
        if (this.discriminator.equals(newValue)) {
            return this;
        }
        return new ImmutableUserData(this, this.id(), this.globalName, this.username, newValue, this.avatar, this.banner(), this.accentColor(), this.bot(), this.system(), this.mfaEnabled(), this.locale(), this.verified(), this.email(), this.flags(), this.premiumType(), this.publicFlags(), this.avatarDecoration());
    }

    public final ImmutableUserData withAvatar(String value) {
        String newValue = Objects.requireNonNull(value, "avatar");
        if (Objects.equals(this.avatar, newValue)) {
            return this;
        }
        return new ImmutableUserData(this, this.id(), this.globalName, this.username, this.discriminator, newValue, this.banner(), this.accentColor(), this.bot(), this.system(), this.mfaEnabled(), this.locale(), this.verified(), this.email(), this.flags(), this.premiumType(), this.publicFlags(), this.avatarDecoration());
    }

    public final ImmutableUserData withAvatar(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.avatar, value)) {
            return this;
        }
        return new ImmutableUserData(this, this.id(), this.globalName, this.username, this.discriminator, value, this.banner(), this.accentColor(), this.bot(), this.system(), this.mfaEnabled(), this.locale(), this.verified(), this.email(), this.flags(), this.premiumType(), this.publicFlags(), this.avatarDecoration());
    }

    public ImmutableUserData withBanner(Possible<Optional<String>> value) {
        Possible<Optional<String>> newValue = Objects.requireNonNull(value);
        return new ImmutableUserData(this, this.id(), this.globalName, this.username, this.discriminator, this.avatar, newValue, this.accentColor(), this.bot(), this.system(), this.mfaEnabled(), this.locale(), this.verified(), this.email(), this.flags(), this.premiumType(), this.publicFlags(), this.avatarDecoration());
    }

    @Deprecated
    public ImmutableUserData withBanner(@Nullable String value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutableUserData(this, this.id(), this.globalName, this.username, this.discriminator, this.avatar, (Possible<Optional<String>>)newValue, this.accentColor(), this.bot(), this.system(), this.mfaEnabled(), this.locale(), this.verified(), this.email(), this.flags(), this.premiumType(), this.publicFlags(), this.avatarDecoration());
    }

    public ImmutableUserData withBannerOrNull(@Nullable String value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutableUserData(this, this.id(), this.globalName, this.username, this.discriminator, this.avatar, (Possible<Optional<String>>)newValue, this.accentColor(), this.bot(), this.system(), this.mfaEnabled(), this.locale(), this.verified(), this.email(), this.flags(), this.premiumType(), this.publicFlags(), this.avatarDecoration());
    }

    public ImmutableUserData withAccentColor(Possible<Optional<Integer>> value) {
        Possible<Optional<Integer>> newValue = Objects.requireNonNull(value);
        return new ImmutableUserData(this, this.id(), this.globalName, this.username, this.discriminator, this.avatar, this.banner(), newValue, this.bot(), this.system(), this.mfaEnabled(), this.locale(), this.verified(), this.email(), this.flags(), this.premiumType(), this.publicFlags(), this.avatarDecoration());
    }

    @Deprecated
    public ImmutableUserData withAccentColor(@Nullable Integer value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutableUserData(this, this.id(), this.globalName, this.username, this.discriminator, this.avatar, this.banner(), (Possible<Optional<Integer>>)newValue, this.bot(), this.system(), this.mfaEnabled(), this.locale(), this.verified(), this.email(), this.flags(), this.premiumType(), this.publicFlags(), this.avatarDecoration());
    }

    public ImmutableUserData withAccentColorOrNull(@Nullable Integer value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutableUserData(this, this.id(), this.globalName, this.username, this.discriminator, this.avatar, this.banner(), (Possible<Optional<Integer>>)newValue, this.bot(), this.system(), this.mfaEnabled(), this.locale(), this.verified(), this.email(), this.flags(), this.premiumType(), this.publicFlags(), this.avatarDecoration());
    }

    public ImmutableUserData withBot(Possible<Boolean> value) {
        Possible<Boolean> newValue = Objects.requireNonNull(value);
        return new ImmutableUserData(this, this.id(), this.globalName, this.username, this.discriminator, this.avatar, this.banner(), this.accentColor(), newValue, this.system(), this.mfaEnabled(), this.locale(), this.verified(), this.email(), this.flags(), this.premiumType(), this.publicFlags(), this.avatarDecoration());
    }

    public ImmutableUserData withBot(Boolean value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableUserData(this, this.id(), this.globalName, this.username, this.discriminator, this.avatar, this.banner(), this.accentColor(), (Possible<Boolean>)newValue, this.system(), this.mfaEnabled(), this.locale(), this.verified(), this.email(), this.flags(), this.premiumType(), this.publicFlags(), this.avatarDecoration());
    }

    public ImmutableUserData withSystem(Possible<Boolean> value) {
        Possible<Boolean> newValue = Objects.requireNonNull(value);
        return new ImmutableUserData(this, this.id(), this.globalName, this.username, this.discriminator, this.avatar, this.banner(), this.accentColor(), this.bot(), newValue, this.mfaEnabled(), this.locale(), this.verified(), this.email(), this.flags(), this.premiumType(), this.publicFlags(), this.avatarDecoration());
    }

    public ImmutableUserData withSystem(Boolean value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableUserData(this, this.id(), this.globalName, this.username, this.discriminator, this.avatar, this.banner(), this.accentColor(), this.bot(), (Possible<Boolean>)newValue, this.mfaEnabled(), this.locale(), this.verified(), this.email(), this.flags(), this.premiumType(), this.publicFlags(), this.avatarDecoration());
    }

    public ImmutableUserData withMfaEnabled(Possible<Boolean> value) {
        Possible<Boolean> newValue = Objects.requireNonNull(value);
        return new ImmutableUserData(this, this.id(), this.globalName, this.username, this.discriminator, this.avatar, this.banner(), this.accentColor(), this.bot(), this.system(), newValue, this.locale(), this.verified(), this.email(), this.flags(), this.premiumType(), this.publicFlags(), this.avatarDecoration());
    }

    public ImmutableUserData withMfaEnabled(Boolean value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableUserData(this, this.id(), this.globalName, this.username, this.discriminator, this.avatar, this.banner(), this.accentColor(), this.bot(), this.system(), (Possible<Boolean>)newValue, this.locale(), this.verified(), this.email(), this.flags(), this.premiumType(), this.publicFlags(), this.avatarDecoration());
    }

    public ImmutableUserData withLocale(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return new ImmutableUserData(this, this.id(), this.globalName, this.username, this.discriminator, this.avatar, this.banner(), this.accentColor(), this.bot(), this.system(), this.mfaEnabled(), newValue, this.verified(), this.email(), this.flags(), this.premiumType(), this.publicFlags(), this.avatarDecoration());
    }

    public ImmutableUserData withLocale(String value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableUserData(this, this.id(), this.globalName, this.username, this.discriminator, this.avatar, this.banner(), this.accentColor(), this.bot(), this.system(), this.mfaEnabled(), (Possible<String>)newValue, this.verified(), this.email(), this.flags(), this.premiumType(), this.publicFlags(), this.avatarDecoration());
    }

    public ImmutableUserData withVerified(Possible<Boolean> value) {
        Possible<Boolean> newValue = Objects.requireNonNull(value);
        return new ImmutableUserData(this, this.id(), this.globalName, this.username, this.discriminator, this.avatar, this.banner(), this.accentColor(), this.bot(), this.system(), this.mfaEnabled(), this.locale(), newValue, this.email(), this.flags(), this.premiumType(), this.publicFlags(), this.avatarDecoration());
    }

    public ImmutableUserData withVerified(Boolean value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableUserData(this, this.id(), this.globalName, this.username, this.discriminator, this.avatar, this.banner(), this.accentColor(), this.bot(), this.system(), this.mfaEnabled(), this.locale(), (Possible<Boolean>)newValue, this.email(), this.flags(), this.premiumType(), this.publicFlags(), this.avatarDecoration());
    }

    public ImmutableUserData withEmail(Possible<Optional<String>> value) {
        Possible<Optional<String>> newValue = Objects.requireNonNull(value);
        return new ImmutableUserData(this, this.id(), this.globalName, this.username, this.discriminator, this.avatar, this.banner(), this.accentColor(), this.bot(), this.system(), this.mfaEnabled(), this.locale(), this.verified(), newValue, this.flags(), this.premiumType(), this.publicFlags(), this.avatarDecoration());
    }

    @Deprecated
    public ImmutableUserData withEmail(@Nullable String value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutableUserData(this, this.id(), this.globalName, this.username, this.discriminator, this.avatar, this.banner(), this.accentColor(), this.bot(), this.system(), this.mfaEnabled(), this.locale(), this.verified(), (Possible<Optional<String>>)newValue, this.flags(), this.premiumType(), this.publicFlags(), this.avatarDecoration());
    }

    public ImmutableUserData withEmailOrNull(@Nullable String value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutableUserData(this, this.id(), this.globalName, this.username, this.discriminator, this.avatar, this.banner(), this.accentColor(), this.bot(), this.system(), this.mfaEnabled(), this.locale(), this.verified(), (Possible<Optional<String>>)newValue, this.flags(), this.premiumType(), this.publicFlags(), this.avatarDecoration());
    }

    public ImmutableUserData withFlags(Possible<Long> value) {
        Possible<Long> newValue = Objects.requireNonNull(value);
        return new ImmutableUserData(this, this.id(), this.globalName, this.username, this.discriminator, this.avatar, this.banner(), this.accentColor(), this.bot(), this.system(), this.mfaEnabled(), this.locale(), this.verified(), this.email(), newValue, this.premiumType(), this.publicFlags(), this.avatarDecoration());
    }

    public ImmutableUserData withFlags(Long value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableUserData(this, this.id(), this.globalName, this.username, this.discriminator, this.avatar, this.banner(), this.accentColor(), this.bot(), this.system(), this.mfaEnabled(), this.locale(), this.verified(), this.email(), (Possible<Long>)newValue, this.premiumType(), this.publicFlags(), this.avatarDecoration());
    }

    public ImmutableUserData withPremiumType(Possible<Integer> value) {
        Possible<Integer> newValue = Objects.requireNonNull(value);
        return new ImmutableUserData(this, this.id(), this.globalName, this.username, this.discriminator, this.avatar, this.banner(), this.accentColor(), this.bot(), this.system(), this.mfaEnabled(), this.locale(), this.verified(), this.email(), this.flags(), newValue, this.publicFlags(), this.avatarDecoration());
    }

    public ImmutableUserData withPremiumType(Integer value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableUserData(this, this.id(), this.globalName, this.username, this.discriminator, this.avatar, this.banner(), this.accentColor(), this.bot(), this.system(), this.mfaEnabled(), this.locale(), this.verified(), this.email(), this.flags(), (Possible<Integer>)newValue, this.publicFlags(), this.avatarDecoration());
    }

    public ImmutableUserData withPublicFlags(Possible<Long> value) {
        Possible<Long> newValue = Objects.requireNonNull(value);
        return new ImmutableUserData(this, this.id(), this.globalName, this.username, this.discriminator, this.avatar, this.banner(), this.accentColor(), this.bot(), this.system(), this.mfaEnabled(), this.locale(), this.verified(), this.email(), this.flags(), this.premiumType(), newValue, this.avatarDecoration());
    }

    public ImmutableUserData withPublicFlags(Long value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableUserData(this, this.id(), this.globalName, this.username, this.discriminator, this.avatar, this.banner(), this.accentColor(), this.bot(), this.system(), this.mfaEnabled(), this.locale(), this.verified(), this.email(), this.flags(), this.premiumType(), (Possible<Long>)newValue, this.avatarDecoration());
    }

    public ImmutableUserData withAvatarDecoration(Possible<Optional<AvatarDecorationData>> value) {
        Possible<Optional<AvatarDecorationData>> newValue = Objects.requireNonNull(value);
        return new ImmutableUserData(this, this.id(), this.globalName, this.username, this.discriminator, this.avatar, this.banner(), this.accentColor(), this.bot(), this.system(), this.mfaEnabled(), this.locale(), this.verified(), this.email(), this.flags(), this.premiumType(), this.publicFlags(), newValue);
    }

    @Deprecated
    public ImmutableUserData withAvatarDecoration(@Nullable AvatarDecorationData value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutableUserData(this, this.id(), this.globalName, this.username, this.discriminator, this.avatar, this.banner(), this.accentColor(), this.bot(), this.system(), this.mfaEnabled(), this.locale(), this.verified(), this.email(), this.flags(), this.premiumType(), this.publicFlags(), (Possible<Optional<AvatarDecorationData>>)newValue);
    }

    public ImmutableUserData withAvatarDecorationOrNull(@Nullable AvatarDecorationData value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutableUserData(this, this.id(), this.globalName, this.username, this.discriminator, this.avatar, this.banner(), this.accentColor(), this.bot(), this.system(), this.mfaEnabled(), this.locale(), this.verified(), this.email(), this.flags(), this.premiumType(), this.publicFlags(), (Possible<Optional<AvatarDecorationData>>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUserData && this.equalTo(0, (ImmutableUserData)another);
    }

    private boolean equalTo(int synthetic, ImmutableUserData another) {
        return Objects.equals(this.id_value, another.id_value) && Objects.equals(this.globalName, another.globalName) && this.username.equals(another.username) && this.discriminator.equals(another.discriminator) && Objects.equals(this.avatar, another.avatar) && this.banner().equals(another.banner()) && this.accentColor().equals(another.accentColor()) && this.bot().equals(another.bot()) && this.system().equals(another.system()) && this.mfaEnabled().equals(another.mfaEnabled()) && this.locale().equals(another.locale()) && this.verified().equals(another.verified()) && this.email().equals(another.email()) && this.flags().equals(another.flags()) && this.premiumType().equals(another.premiumType()) && this.publicFlags().equals(another.publicFlags()) && this.avatarDecoration().equals(another.avatarDecoration());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.id_value);
        h += (h << 5) + Objects.hashCode(this.globalName);
        h += (h << 5) + this.username.hashCode();
        h += (h << 5) + this.discriminator.hashCode();
        h += (h << 5) + Objects.hashCode(this.avatar);
        h += (h << 5) + this.banner().hashCode();
        h += (h << 5) + this.accentColor().hashCode();
        h += (h << 5) + this.bot().hashCode();
        h += (h << 5) + this.system().hashCode();
        h += (h << 5) + this.mfaEnabled().hashCode();
        h += (h << 5) + this.locale().hashCode();
        h += (h << 5) + this.verified().hashCode();
        h += (h << 5) + this.email().hashCode();
        h += (h << 5) + this.flags().hashCode();
        h += (h << 5) + this.premiumType().hashCode();
        h += (h << 5) + this.publicFlags().hashCode();
        h += (h << 5) + this.avatarDecoration().hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("UserData{");
        builder.append("id=").append(Objects.toString(this.id_value));
        if (this.globalName != null) {
            builder.append(", ");
            builder.append("globalName=").append(this.globalName);
        }
        builder.append(", ");
        builder.append("username=").append(this.username);
        builder.append(", ");
        builder.append("discriminator=").append(this.discriminator);
        if (this.avatar != null) {
            builder.append(", ");
            builder.append("avatar=").append(this.avatar);
        }
        builder.append(", ");
        builder.append("banner=").append(this.banner().toString());
        builder.append(", ");
        builder.append("accentColor=").append(this.accentColor().toString());
        builder.append(", ");
        builder.append("bot=").append(this.bot().toString());
        builder.append(", ");
        builder.append("system=").append(this.system().toString());
        builder.append(", ");
        builder.append("mfaEnabled=").append(this.mfaEnabled().toString());
        builder.append(", ");
        builder.append("locale=").append(this.locale().toString());
        builder.append(", ");
        builder.append("verified=").append(this.verified().toString());
        builder.append(", ");
        builder.append("email=").append(this.email().toString());
        builder.append(", ");
        builder.append("flags=").append(this.flags().toString());
        builder.append(", ");
        builder.append("premiumType=").append(this.premiumType().toString());
        builder.append(", ");
        builder.append("publicFlags=").append(this.publicFlags().toString());
        builder.append(", ");
        builder.append("avatarDecoration=").append(this.avatarDecoration().toString());
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableUserData fromJson(Json json) {
        Builder builder = ImmutableUserData.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.globalName != null) {
            builder.globalName(json.globalName);
        }
        if (json.username != null) {
            builder.username(json.username);
        }
        if (json.discriminator != null) {
            builder.discriminator(json.discriminator);
        }
        if (json.avatar != null) {
            builder.avatar(json.avatar);
        }
        if (json.banner != null) {
            builder.banner(json.banner);
        }
        if (json.accentColor != null) {
            builder.accentColor(json.accentColor);
        }
        if (json.bot != null) {
            builder.bot(json.bot);
        }
        if (json.system != null) {
            builder.system(json.system);
        }
        if (json.mfaEnabled != null) {
            builder.mfaEnabled(json.mfaEnabled);
        }
        if (json.locale != null) {
            builder.locale(json.locale);
        }
        if (json.verified != null) {
            builder.verified(json.verified);
        }
        if (json.email != null) {
            builder.email(json.email);
        }
        if (json.flags != null) {
            builder.flags(json.flags);
        }
        if (json.premiumType != null) {
            builder.premiumType(json.premiumType);
        }
        if (json.publicFlags != null) {
            builder.publicFlags(json.publicFlags);
        }
        if (json.avatarDecoration != null) {
            builder.avatarDecoration(json.avatarDecoration);
        }
        return builder.build();
    }

    public static ImmutableUserData of(Id id, Optional<String> globalName, String username, String discriminator, Optional<String> avatar, Possible<Optional<String>> banner, Possible<Optional<Integer>> accentColor, Possible<Boolean> bot, Possible<Boolean> system, Possible<Boolean> mfaEnabled, Possible<String> locale, Possible<Boolean> verified, Possible<Optional<String>> email, Possible<Long> flags, Possible<Integer> premiumType, Possible<Long> publicFlags, Possible<Optional<AvatarDecorationData>> avatarDecoration) {
        return new ImmutableUserData(id, globalName, username, discriminator, avatar, banner, accentColor, bot, system, mfaEnabled, locale, verified, email, flags, premiumType, publicFlags, avatarDecoration);
    }

    public static ImmutableUserData copyOf(UserData instance) {
        if (instance instanceof ImmutableUserData) {
            return (ImmutableUserData)instance;
        }
        return ImmutableUserData.builder().from(instance).build();
    }

    public boolean isBannerPresent() {
        return !this.banner_absent;
    }

    public String bannerOrElse(String defaultValue) {
        return !this.banner_absent ? this.banner_value : defaultValue;
    }

    public boolean isAccentColorPresent() {
        return !this.accentColor_absent;
    }

    public Integer accentColorOrElse(Integer defaultValue) {
        return !this.accentColor_absent ? this.accentColor_value : defaultValue;
    }

    public boolean isBotPresent() {
        return !this.bot_absent;
    }

    public Boolean botOrElse(Boolean defaultValue) {
        return !this.bot_absent ? this.bot_value : defaultValue;
    }

    public boolean isSystemPresent() {
        return !this.system_absent;
    }

    public Boolean systemOrElse(Boolean defaultValue) {
        return !this.system_absent ? this.system_value : defaultValue;
    }

    public boolean isMfaEnabledPresent() {
        return !this.mfaEnabled_absent;
    }

    public Boolean mfaEnabledOrElse(Boolean defaultValue) {
        return !this.mfaEnabled_absent ? this.mfaEnabled_value : defaultValue;
    }

    public boolean isLocalePresent() {
        return !this.locale_absent;
    }

    public String localeOrElse(String defaultValue) {
        return !this.locale_absent ? this.locale_value : defaultValue;
    }

    public boolean isVerifiedPresent() {
        return !this.verified_absent;
    }

    public Boolean verifiedOrElse(Boolean defaultValue) {
        return !this.verified_absent ? this.verified_value : defaultValue;
    }

    public boolean isEmailPresent() {
        return !this.email_absent;
    }

    public String emailOrElse(String defaultValue) {
        return !this.email_absent ? this.email_value : defaultValue;
    }

    public boolean isFlagsPresent() {
        return !this.flags_absent;
    }

    public Long flagsOrElse(Long defaultValue) {
        return !this.flags_absent ? this.flags_value : defaultValue;
    }

    public boolean isPremiumTypePresent() {
        return !this.premiumType_absent;
    }

    public Integer premiumTypeOrElse(Integer defaultValue) {
        return !this.premiumType_absent ? this.premiumType_value : defaultValue;
    }

    public boolean isPublicFlagsPresent() {
        return !this.publicFlags_absent;
    }

    public Long publicFlagsOrElse(Long defaultValue) {
        return !this.publicFlags_absent ? this.publicFlags_value : defaultValue;
    }

    public boolean isAvatarDecorationPresent() {
        return !this.avatarDecoration_absent;
    }

    public AvatarDecorationData avatarDecorationOrElse(AvatarDecorationData defaultValue) {
        return !this.avatarDecoration_absent ? this.avatarDecoration_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_USERNAME = 1L;
        private static final long INIT_BIT_DISCRIMINATOR = 2L;
        private long initBits = 3L;
        private Id id_id = null;
        private Possible<Optional<String>> banner_possible = Possible.absent();
        private Possible<Optional<Integer>> accentColor_possible = Possible.absent();
        private Possible<Boolean> bot_possible = Possible.absent();
        private Possible<Boolean> system_possible = Possible.absent();
        private Possible<Boolean> mfaEnabled_possible = Possible.absent();
        private Possible<String> locale_possible = Possible.absent();
        private Possible<Boolean> verified_possible = Possible.absent();
        private Possible<Optional<String>> email_possible = Possible.absent();
        private Possible<Long> flags_possible = Possible.absent();
        private Possible<Integer> premiumType_possible = Possible.absent();
        private Possible<Long> publicFlags_possible = Possible.absent();
        private Possible<Optional<AvatarDecorationData>> avatarDecoration_possible = Possible.absent();
        @Nullable
        private String globalName;
        @Nullable
        private String username;
        @Nullable
        private String discriminator;
        @Nullable
        private String avatar;

        private Builder() {
        }

        public final Builder from(UserData instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.id());
            Optional<String> globalNameOptional = instance.globalName();
            if (globalNameOptional.isPresent()) {
                this.globalName(globalNameOptional);
            }
            this.username(instance.username());
            this.discriminator(instance.discriminator());
            Optional<String> avatarOptional = instance.avatar();
            if (avatarOptional.isPresent()) {
                this.avatar(avatarOptional);
            }
            this.banner(instance.banner());
            this.accentColor(instance.accentColor());
            this.bot(instance.bot());
            this.system(instance.system());
            this.mfaEnabled(instance.mfaEnabled());
            this.locale(instance.locale());
            this.verified(instance.verified());
            this.email(instance.email());
            this.flags(instance.flags());
            this.premiumType(instance.premiumType());
            this.publicFlags(instance.publicFlags());
            this.avatarDecoration(instance.avatarDecoration());
            return this;
        }

        public Builder id(String value) {
            this.id_id = Id.of((String)value);
            return this;
        }

        public Builder id(long value) {
            this.id_id = Id.of((long)value);
            return this;
        }

        @JsonProperty(value="id")
        public Builder id(Id value) {
            this.id_id = value;
            return this;
        }

        public final Builder globalName(String globalName) {
            this.globalName = Objects.requireNonNull(globalName, "globalName");
            return this;
        }

        @JsonProperty(value="global_name")
        public final Builder globalName(Optional<String> globalName) {
            this.globalName = globalName.orElse(null);
            return this;
        }

        @JsonProperty(value="username")
        public final Builder username(String username) {
            this.username = Objects.requireNonNull(username, "username");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="discriminator")
        @Deprecated
        public final Builder discriminator(String discriminator) {
            this.discriminator = Objects.requireNonNull(discriminator, "discriminator");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder avatar(String avatar) {
            this.avatar = Objects.requireNonNull(avatar, "avatar");
            return this;
        }

        @JsonProperty(value="avatar")
        public final Builder avatar(Optional<String> avatar) {
            this.avatar = avatar.orElse(null);
            return this;
        }

        @JsonProperty(value="banner")
        public Builder banner(Possible<Optional<String>> value) {
            this.banner_possible = value;
            return this;
        }

        @Deprecated
        public Builder banner(@Nullable String value) {
            this.banner_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public Builder bannerOrNull(@Nullable String value) {
            this.banner_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @JsonProperty(value="accent_color")
        public Builder accentColor(Possible<Optional<Integer>> value) {
            this.accentColor_possible = value;
            return this;
        }

        @Deprecated
        public Builder accentColor(@Nullable Integer value) {
            this.accentColor_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public Builder accentColorOrNull(@Nullable Integer value) {
            this.accentColor_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @JsonProperty(value="bot")
        public Builder bot(Possible<Boolean> value) {
            this.bot_possible = value;
            return this;
        }

        public Builder bot(Boolean value) {
            this.bot_possible = Possible.of((Object)value);
            return this;
        }

        @JsonProperty(value="system")
        public Builder system(Possible<Boolean> value) {
            this.system_possible = value;
            return this;
        }

        public Builder system(Boolean value) {
            this.system_possible = Possible.of((Object)value);
            return this;
        }

        @JsonProperty(value="mfa_enabled")
        public Builder mfaEnabled(Possible<Boolean> value) {
            this.mfaEnabled_possible = value;
            return this;
        }

        public Builder mfaEnabled(Boolean value) {
            this.mfaEnabled_possible = Possible.of((Object)value);
            return this;
        }

        @JsonProperty(value="locale")
        public Builder locale(Possible<String> value) {
            this.locale_possible = value;
            return this;
        }

        public Builder locale(String value) {
            this.locale_possible = Possible.of((Object)value);
            return this;
        }

        @JsonProperty(value="verified")
        public Builder verified(Possible<Boolean> value) {
            this.verified_possible = value;
            return this;
        }

        public Builder verified(Boolean value) {
            this.verified_possible = Possible.of((Object)value);
            return this;
        }

        @JsonProperty(value="email")
        public Builder email(Possible<Optional<String>> value) {
            this.email_possible = value;
            return this;
        }

        @Deprecated
        public Builder email(@Nullable String value) {
            this.email_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public Builder emailOrNull(@Nullable String value) {
            this.email_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @JsonProperty(value="flags")
        public Builder flags(Possible<Long> value) {
            this.flags_possible = value;
            return this;
        }

        public Builder flags(Long value) {
            this.flags_possible = Possible.of((Object)value);
            return this;
        }

        @JsonProperty(value="premium_type")
        public Builder premiumType(Possible<Integer> value) {
            this.premiumType_possible = value;
            return this;
        }

        public Builder premiumType(Integer value) {
            this.premiumType_possible = Possible.of((Object)value);
            return this;
        }

        @JsonProperty(value="public_flags")
        public Builder publicFlags(Possible<Long> value) {
            this.publicFlags_possible = value;
            return this;
        }

        public Builder publicFlags(Long value) {
            this.publicFlags_possible = Possible.of((Object)value);
            return this;
        }

        @JsonProperty(value="avatar_decoration_data")
        public Builder avatarDecoration(Possible<Optional<AvatarDecorationData>> value) {
            this.avatarDecoration_possible = value;
            return this;
        }

        @Deprecated
        public Builder avatarDecoration(@Nullable AvatarDecorationData value) {
            this.avatarDecoration_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public Builder avatarDecorationOrNull(@Nullable AvatarDecorationData value) {
            this.avatarDecoration_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public ImmutableUserData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUserData(null, this.id_build(), this.globalName, this.username, this.discriminator, this.avatar, this.banner_build(), this.accentColor_build(), this.bot_build(), this.system_build(), this.mfaEnabled_build(), this.locale_build(), this.verified_build(), this.email_build(), this.flags_build(), this.premiumType_build(), this.publicFlags_build(), this.avatarDecoration_build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("username");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("discriminator");
            }
            return "Cannot build UserData, some of required attributes are not set " + attributes;
        }

        private Id id_build() {
            return this.id_id;
        }

        private Possible<Optional<String>> banner_build() {
            return this.banner_possible;
        }

        private Possible<Optional<Integer>> accentColor_build() {
            return this.accentColor_possible;
        }

        private Possible<Boolean> bot_build() {
            return this.bot_possible;
        }

        private Possible<Boolean> system_build() {
            return this.system_possible;
        }

        private Possible<Boolean> mfaEnabled_build() {
            return this.mfaEnabled_possible;
        }

        private Possible<String> locale_build() {
            return this.locale_possible;
        }

        private Possible<Boolean> verified_build() {
            return this.verified_possible;
        }

        private Possible<Optional<String>> email_build() {
            return this.email_possible;
        }

        private Possible<Long> flags_build() {
            return this.flags_possible;
        }

        private Possible<Integer> premiumType_build() {
            return this.premiumType_possible;
        }

        private Possible<Long> publicFlags_build() {
            return this.publicFlags_possible;
        }

        private Possible<Optional<AvatarDecorationData>> avatarDecoration_build() {
            return this.avatarDecoration_possible;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements UserData {
        @Nullable
        Id id;
        @Nullable
        Optional<String> globalName = Optional.empty();
        @Nullable
        String username;
        @Nullable
        String discriminator;
        @Nullable
        Optional<String> avatar = Optional.empty();
        Possible<Optional<String>> banner = Possible.absent();
        Possible<Optional<Integer>> accentColor = Possible.absent();
        Possible<Boolean> bot = Possible.absent();
        Possible<Boolean> system = Possible.absent();
        Possible<Boolean> mfaEnabled = Possible.absent();
        Possible<String> locale = Possible.absent();
        Possible<Boolean> verified = Possible.absent();
        Possible<Optional<String>> email = Possible.absent();
        Possible<Long> flags = Possible.absent();
        Possible<Integer> premiumType = Possible.absent();
        Possible<Long> publicFlags = Possible.absent();
        Possible<Optional<AvatarDecorationData>> avatarDecoration = Possible.absent();

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(Id id) {
            this.id = id;
        }

        @JsonProperty(value="global_name")
        public void setGlobalName(Optional<String> globalName) {
            this.globalName = globalName;
        }

        @JsonProperty(value="username")
        public void setUsername(String username) {
            this.username = username;
        }

        @JsonProperty(value="discriminator")
        public void setDiscriminator(String discriminator) {
            this.discriminator = discriminator;
        }

        @JsonProperty(value="avatar")
        public void setAvatar(Optional<String> avatar) {
            this.avatar = avatar;
        }

        @JsonProperty(value="banner")
        public void setBanner(Possible<Optional<String>> banner) {
            this.banner = banner;
        }

        @JsonProperty(value="accent_color")
        public void setAccentColor(Possible<Optional<Integer>> accentColor) {
            this.accentColor = accentColor;
        }

        @JsonProperty(value="bot")
        public void setBot(Possible<Boolean> bot) {
            this.bot = bot;
        }

        @JsonProperty(value="system")
        public void setSystem(Possible<Boolean> system) {
            this.system = system;
        }

        @JsonProperty(value="mfa_enabled")
        public void setMfaEnabled(Possible<Boolean> mfaEnabled) {
            this.mfaEnabled = mfaEnabled;
        }

        @JsonProperty(value="locale")
        public void setLocale(Possible<String> locale) {
            this.locale = locale;
        }

        @JsonProperty(value="verified")
        public void setVerified(Possible<Boolean> verified) {
            this.verified = verified;
        }

        @JsonProperty(value="email")
        public void setEmail(Possible<Optional<String>> email) {
            this.email = email;
        }

        @JsonProperty(value="flags")
        public void setFlags(Possible<Long> flags) {
            this.flags = flags;
        }

        @JsonProperty(value="premium_type")
        public void setPremiumType(Possible<Integer> premiumType) {
            this.premiumType = premiumType;
        }

        @JsonProperty(value="public_flags")
        public void setPublicFlags(Possible<Long> publicFlags) {
            this.publicFlags = publicFlags;
        }

        @JsonProperty(value="avatar_decoration_data")
        public void setAvatarDecoration(Possible<Optional<AvatarDecorationData>> avatarDecoration) {
            this.avatarDecoration = avatarDecoration;
        }

        @Override
        public Id id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> globalName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String username() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String discriminator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> avatar() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Optional<String>> banner() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Optional<Integer>> accentColor() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Boolean> bot() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Boolean> system() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Boolean> mfaEnabled() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<String> locale() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Boolean> verified() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Optional<String>> email() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Long> flags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Integer> premiumType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Long> publicFlags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Optional<AvatarDecorationData>> avatarDecoration() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build UserData, attribute initializers form cycle " + attributes;
        }
    }
}

