/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.UpdateCurrentUserVoiceStateRequest;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class ImmutableUpdateCurrentUserVoiceStateRequest
implements UpdateCurrentUserVoiceStateRequest {
    private final String channelId;
    private final Boolean suppress_value;
    private final boolean suppress_absent;
    private final String requestToSpeakTimestamp_value;
    private final boolean requestToSpeakTimestamp_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableUpdateCurrentUserVoiceStateRequest(String channelId, Possible<Boolean> suppress, Possible<Optional<String>> requestToSpeakTimestamp) {
        this.channelId = Objects.requireNonNull(channelId, "channelId");
        Possible<Boolean> suppress$impl = suppress;
        Possible<Optional<String>> requestToSpeakTimestamp$impl = requestToSpeakTimestamp;
        this.suppress_value = suppress$impl.toOptional().orElse(null);
        this.suppress_absent = suppress$impl.isAbsent();
        this.requestToSpeakTimestamp_value = Possible.flatOpt(requestToSpeakTimestamp$impl).orElse(null);
        this.requestToSpeakTimestamp_absent = requestToSpeakTimestamp$impl.isAbsent();
        this.initShim = null;
    }

    private ImmutableUpdateCurrentUserVoiceStateRequest(ImmutableUpdateCurrentUserVoiceStateRequest original, String channelId, Possible<Boolean> suppress, Possible<Optional<String>> requestToSpeakTimestamp) {
        this.channelId = channelId;
        Possible<Boolean> suppress$impl = suppress;
        Possible<Optional<String>> requestToSpeakTimestamp$impl = requestToSpeakTimestamp;
        this.suppress_value = suppress$impl.toOptional().orElse(null);
        this.suppress_absent = suppress$impl.isAbsent();
        this.requestToSpeakTimestamp_value = Possible.flatOpt(requestToSpeakTimestamp$impl).orElse(null);
        this.requestToSpeakTimestamp_absent = requestToSpeakTimestamp$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="channel_id")
    public String channelId() {
        return this.channelId;
    }

    @Override
    @JsonProperty(value="suppress")
    public Possible<Boolean> suppress() {
        return this.suppress_absent ? Possible.absent() : Possible.of((Object)this.suppress_value);
    }

    @Override
    @JsonProperty(value="request_to_speak_timestamp")
    public Possible<Optional<String>> requestToSpeakTimestamp() {
        return this.requestToSpeakTimestamp_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.requestToSpeakTimestamp_value));
    }

    public final ImmutableUpdateCurrentUserVoiceStateRequest withChannelId(String value) {
        String newValue = Objects.requireNonNull(value, "channelId");
        if (this.channelId.equals(newValue)) {
            return this;
        }
        return new ImmutableUpdateCurrentUserVoiceStateRequest(this, newValue, this.suppress(), this.requestToSpeakTimestamp());
    }

    public ImmutableUpdateCurrentUserVoiceStateRequest withSuppress(Possible<Boolean> value) {
        Possible<Boolean> newValue = Objects.requireNonNull(value);
        return new ImmutableUpdateCurrentUserVoiceStateRequest(this, this.channelId, newValue, this.requestToSpeakTimestamp());
    }

    public ImmutableUpdateCurrentUserVoiceStateRequest withSuppress(Boolean value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableUpdateCurrentUserVoiceStateRequest(this, this.channelId, (Possible<Boolean>)newValue, this.requestToSpeakTimestamp());
    }

    public ImmutableUpdateCurrentUserVoiceStateRequest withRequestToSpeakTimestamp(Possible<Optional<String>> value) {
        Possible<Optional<String>> newValue = Objects.requireNonNull(value);
        return new ImmutableUpdateCurrentUserVoiceStateRequest(this, this.channelId, this.suppress(), newValue);
    }

    @Deprecated
    public ImmutableUpdateCurrentUserVoiceStateRequest withRequestToSpeakTimestamp(@Nullable String value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutableUpdateCurrentUserVoiceStateRequest(this, this.channelId, this.suppress(), (Possible<Optional<String>>)newValue);
    }

    public ImmutableUpdateCurrentUserVoiceStateRequest withRequestToSpeakTimestampOrNull(@Nullable String value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutableUpdateCurrentUserVoiceStateRequest(this, this.channelId, this.suppress(), (Possible<Optional<String>>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateCurrentUserVoiceStateRequest && this.equalTo(0, (ImmutableUpdateCurrentUserVoiceStateRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateCurrentUserVoiceStateRequest another) {
        return this.channelId.equals(another.channelId) && this.suppress().equals(another.suppress()) && this.requestToSpeakTimestamp().equals(another.requestToSpeakTimestamp());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.channelId.hashCode();
        h += (h << 5) + this.suppress().hashCode();
        h += (h << 5) + this.requestToSpeakTimestamp().hashCode();
        return h;
    }

    public String toString() {
        return "UpdateCurrentUserVoiceStateRequest{channelId=" + this.channelId + ", suppress=" + this.suppress().toString() + ", requestToSpeakTimestamp=" + this.requestToSpeakTimestamp().toString() + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableUpdateCurrentUserVoiceStateRequest fromJson(Json json) {
        Builder builder = ImmutableUpdateCurrentUserVoiceStateRequest.builder();
        if (json.channelId != null) {
            builder.channelId(json.channelId);
        }
        if (json.suppress != null) {
            builder.suppress(json.suppress);
        }
        if (json.requestToSpeakTimestamp != null) {
            builder.requestToSpeakTimestamp(json.requestToSpeakTimestamp);
        }
        return builder.build();
    }

    public static ImmutableUpdateCurrentUserVoiceStateRequest of(String channelId, Possible<Boolean> suppress, Possible<Optional<String>> requestToSpeakTimestamp) {
        return new ImmutableUpdateCurrentUserVoiceStateRequest(channelId, suppress, requestToSpeakTimestamp);
    }

    public static ImmutableUpdateCurrentUserVoiceStateRequest copyOf(UpdateCurrentUserVoiceStateRequest instance) {
        if (instance instanceof ImmutableUpdateCurrentUserVoiceStateRequest) {
            return (ImmutableUpdateCurrentUserVoiceStateRequest)instance;
        }
        return ImmutableUpdateCurrentUserVoiceStateRequest.builder().from(instance).build();
    }

    public boolean isSuppressPresent() {
        return !this.suppress_absent;
    }

    public Boolean suppressOrElse(Boolean defaultValue) {
        return !this.suppress_absent ? this.suppress_value : defaultValue;
    }

    public boolean isRequestToSpeakTimestampPresent() {
        return !this.requestToSpeakTimestamp_absent;
    }

    public String requestToSpeakTimestampOrElse(String defaultValue) {
        return !this.requestToSpeakTimestamp_absent ? this.requestToSpeakTimestamp_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CHANNEL_ID = 1L;
        private long initBits = 1L;
        private Possible<Boolean> suppress_possible = Possible.absent();
        private Possible<Optional<String>> requestToSpeakTimestamp_possible = Possible.absent();
        @Nullable
        private String channelId;

        private Builder() {
        }

        public final Builder from(UpdateCurrentUserVoiceStateRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.channelId(instance.channelId());
            this.suppress(instance.suppress());
            this.requestToSpeakTimestamp(instance.requestToSpeakTimestamp());
            return this;
        }

        @JsonProperty(value="channel_id")
        public final Builder channelId(String channelId) {
            this.channelId = Objects.requireNonNull(channelId, "channelId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="suppress")
        public Builder suppress(Possible<Boolean> value) {
            this.suppress_possible = value;
            return this;
        }

        public Builder suppress(Boolean value) {
            this.suppress_possible = Possible.of((Object)value);
            return this;
        }

        @JsonProperty(value="request_to_speak_timestamp")
        public Builder requestToSpeakTimestamp(Possible<Optional<String>> value) {
            this.requestToSpeakTimestamp_possible = value;
            return this;
        }

        @Deprecated
        public Builder requestToSpeakTimestamp(@Nullable String value) {
            this.requestToSpeakTimestamp_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public Builder requestToSpeakTimestampOrNull(@Nullable String value) {
            this.requestToSpeakTimestamp_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public ImmutableUpdateCurrentUserVoiceStateRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateCurrentUserVoiceStateRequest(null, this.channelId, this.suppress_build(), this.requestToSpeakTimestamp_build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("channelId");
            }
            return "Cannot build UpdateCurrentUserVoiceStateRequest, some of required attributes are not set " + attributes;
        }

        private Possible<Boolean> suppress_build() {
            return this.suppress_possible;
        }

        private Possible<Optional<String>> requestToSpeakTimestamp_build() {
            return this.requestToSpeakTimestamp_possible;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements UpdateCurrentUserVoiceStateRequest {
        @Nullable
        String channelId;
        Possible<Boolean> suppress = Possible.absent();
        Possible<Optional<String>> requestToSpeakTimestamp = Possible.absent();

        Json() {
        }

        @JsonProperty(value="channel_id")
        public void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @JsonProperty(value="suppress")
        public void setSuppress(Possible<Boolean> suppress) {
            this.suppress = suppress;
        }

        @JsonProperty(value="request_to_speak_timestamp")
        public void setRequestToSpeakTimestamp(Possible<Optional<String>> requestToSpeakTimestamp) {
            this.requestToSpeakTimestamp = requestToSpeakTimestamp;
        }

        @Override
        public String channelId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Boolean> suppress() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Optional<String>> requestToSpeakTimestamp() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build UpdateCurrentUserVoiceStateRequest, attribute initializers form cycle " + attributes;
        }
    }
}

