/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.RolePositionModifyRequest;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class ImmutableRolePositionModifyRequest
implements RolePositionModifyRequest {
    private final String id;
    private final Integer position_value;
    private final boolean position_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableRolePositionModifyRequest(String id, Possible<Optional<Integer>> position) {
        this.id = Objects.requireNonNull(id, "id");
        Possible<Optional<Integer>> position$impl = position;
        this.position_value = Possible.flatOpt(position$impl).orElse(null);
        this.position_absent = position$impl.isAbsent();
        this.initShim = null;
    }

    private ImmutableRolePositionModifyRequest(ImmutableRolePositionModifyRequest original, String id, Possible<Optional<Integer>> position) {
        this.id = id;
        Possible<Optional<Integer>> position$impl = position;
        this.position_value = Possible.flatOpt(position$impl).orElse(null);
        this.position_absent = position$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="id")
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="position")
    public Possible<Optional<Integer>> position() {
        return this.position_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.position_value));
    }

    public final ImmutableRolePositionModifyRequest withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableRolePositionModifyRequest(this, newValue, this.position());
    }

    public ImmutableRolePositionModifyRequest withPosition(Possible<Optional<Integer>> value) {
        Possible<Optional<Integer>> newValue = Objects.requireNonNull(value);
        return new ImmutableRolePositionModifyRequest(this, this.id, newValue);
    }

    @Deprecated
    public ImmutableRolePositionModifyRequest withPosition(@Nullable Integer value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutableRolePositionModifyRequest(this, this.id, (Possible<Optional<Integer>>)newValue);
    }

    public ImmutableRolePositionModifyRequest withPositionOrNull(@Nullable Integer value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutableRolePositionModifyRequest(this, this.id, (Possible<Optional<Integer>>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRolePositionModifyRequest && this.equalTo(0, (ImmutableRolePositionModifyRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutableRolePositionModifyRequest another) {
        return this.id.equals(another.id) && this.position().equals(another.position());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.position().hashCode();
        return h;
    }

    public String toString() {
        return "RolePositionModifyRequest{id=" + this.id + ", position=" + this.position().toString() + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableRolePositionModifyRequest fromJson(Json json) {
        Builder builder = ImmutableRolePositionModifyRequest.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.position != null) {
            builder.position(json.position);
        }
        return builder.build();
    }

    public static ImmutableRolePositionModifyRequest of(String id, Possible<Optional<Integer>> position) {
        return new ImmutableRolePositionModifyRequest(id, position);
    }

    public static ImmutableRolePositionModifyRequest copyOf(RolePositionModifyRequest instance) {
        if (instance instanceof ImmutableRolePositionModifyRequest) {
            return (ImmutableRolePositionModifyRequest)instance;
        }
        return ImmutableRolePositionModifyRequest.builder().from(instance).build();
    }

    public boolean isPositionPresent() {
        return !this.position_absent;
    }

    public Integer positionOrElse(Integer defaultValue) {
        return !this.position_absent ? this.position_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private long initBits = 1L;
        private Possible<Optional<Integer>> position_possible = Possible.absent();
        @Nullable
        private String id;

        private Builder() {
        }

        public final Builder from(RolePositionModifyRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.id());
            this.position(instance.position());
            return this;
        }

        @JsonProperty(value="id")
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="position")
        public Builder position(Possible<Optional<Integer>> value) {
            this.position_possible = value;
            return this;
        }

        @Deprecated
        public Builder position(@Nullable Integer value) {
            this.position_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public Builder positionOrNull(@Nullable Integer value) {
            this.position_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public ImmutableRolePositionModifyRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRolePositionModifyRequest(null, this.id, this.position_build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            return "Cannot build RolePositionModifyRequest, some of required attributes are not set " + attributes;
        }

        private Possible<Optional<Integer>> position_build() {
            return this.position_possible;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements RolePositionModifyRequest {
        @Nullable
        String id;
        Possible<Optional<Integer>> position = Possible.absent();

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="position")
        public void setPosition(Possible<Optional<Integer>> position) {
            this.position = position;
        }

        @Override
        public String id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Optional<Integer>> position() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build RolePositionModifyRequest, attribute initializers form cycle " + attributes;
        }
    }
}

