/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.PollAnswerObject;
import discord4j.discordjson.json.PollMediaObject;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ImmutablePollAnswerObject
implements PollAnswerObject {
    private final Integer answerId_value;
    private final boolean answerId_absent;
    private final PollMediaObject data;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutablePollAnswerObject(Possible<Integer> answerId, PollMediaObject data) {
        Possible<Integer> answerId$impl = answerId;
        this.data = Objects.requireNonNull(data, "data");
        this.answerId_value = answerId$impl.toOptional().orElse(null);
        this.answerId_absent = answerId$impl.isAbsent();
        this.initShim = null;
    }

    private ImmutablePollAnswerObject(ImmutablePollAnswerObject original, Possible<Integer> answerId, PollMediaObject data) {
        Possible<Integer> answerId$impl = answerId;
        this.data = data;
        this.answerId_value = answerId$impl.toOptional().orElse(null);
        this.answerId_absent = answerId$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="answer_id")
    public Possible<Integer> answerId() {
        return this.answerId_absent ? Possible.absent() : Possible.of((Object)this.answerId_value);
    }

    @Override
    @JsonProperty(value="poll_media")
    public PollMediaObject data() {
        return this.data;
    }

    public ImmutablePollAnswerObject withAnswerId(Possible<Integer> value) {
        Possible<Integer> newValue = Objects.requireNonNull(value);
        return new ImmutablePollAnswerObject(this, newValue, this.data);
    }

    public ImmutablePollAnswerObject withAnswerId(Integer value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutablePollAnswerObject(this, (Possible<Integer>)newValue, this.data);
    }

    public final ImmutablePollAnswerObject withData(PollMediaObject value) {
        if (this.data == value) {
            return this;
        }
        PollMediaObject newValue = Objects.requireNonNull(value, "data");
        return new ImmutablePollAnswerObject(this, this.answerId(), newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePollAnswerObject && this.equalTo(0, (ImmutablePollAnswerObject)another);
    }

    private boolean equalTo(int synthetic, ImmutablePollAnswerObject another) {
        return this.answerId().equals(another.answerId()) && this.data.equals(another.data);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.answerId().hashCode();
        h += (h << 5) + this.data.hashCode();
        return h;
    }

    public String toString() {
        return "PollAnswerObject{answerId=" + this.answerId().toString() + ", data=" + this.data + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutablePollAnswerObject fromJson(Json json) {
        Builder builder = ImmutablePollAnswerObject.builder();
        if (json.answerId != null) {
            builder.answerId(json.answerId);
        }
        if (json.data != null) {
            builder.data(json.data);
        }
        return builder.build();
    }

    public static ImmutablePollAnswerObject of(Possible<Integer> answerId, PollMediaObject data) {
        return new ImmutablePollAnswerObject(answerId, data);
    }

    public static ImmutablePollAnswerObject copyOf(PollAnswerObject instance) {
        if (instance instanceof ImmutablePollAnswerObject) {
            return (ImmutablePollAnswerObject)instance;
        }
        return ImmutablePollAnswerObject.builder().from(instance).build();
    }

    public boolean isAnswerIdPresent() {
        return !this.answerId_absent;
    }

    public Integer answerIdOrElse(Integer defaultValue) {
        return !this.answerId_absent ? this.answerId_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_DATA = 1L;
        private long initBits = 1L;
        private Possible<Integer> answerId_possible = Possible.absent();
        @Nullable
        private PollMediaObject data;

        private Builder() {
        }

        public final Builder from(PollAnswerObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.answerId(instance.answerId());
            this.data(instance.data());
            return this;
        }

        @JsonProperty(value="answer_id")
        public Builder answerId(Possible<Integer> value) {
            this.answerId_possible = value;
            return this;
        }

        public Builder answerId(Integer value) {
            this.answerId_possible = Possible.of((Object)value);
            return this;
        }

        @JsonProperty(value="poll_media")
        public final Builder data(PollMediaObject data) {
            this.data = Objects.requireNonNull(data, "data");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutablePollAnswerObject build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePollAnswerObject(null, this.answerId_build(), this.data);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("data");
            }
            return "Cannot build PollAnswerObject, some of required attributes are not set " + attributes;
        }

        private Possible<Integer> answerId_build() {
            return this.answerId_possible;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements PollAnswerObject {
        Possible<Integer> answerId = Possible.absent();
        @Nullable
        PollMediaObject data;

        Json() {
        }

        @JsonProperty(value="answer_id")
        public void setAnswerId(Possible<Integer> answerId) {
            this.answerId = answerId;
        }

        @JsonProperty(value="poll_media")
        public void setData(PollMediaObject data) {
            this.data = data;
        }

        @Override
        public Possible<Integer> answerId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public PollMediaObject data() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build PollAnswerObject, attribute initializers form cycle " + attributes;
        }
    }
}

