/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.DMCreateRequest;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ImmutableDMCreateRequest
implements DMCreateRequest {
    private final String recipientId;

    private ImmutableDMCreateRequest(String recipientId) {
        this.recipientId = Objects.requireNonNull(recipientId, "recipientId");
    }

    private ImmutableDMCreateRequest(ImmutableDMCreateRequest original, String recipientId) {
        this.recipientId = recipientId;
    }

    @Override
    @JsonProperty(value="recipient_id")
    public String recipientId() {
        return this.recipientId;
    }

    public final ImmutableDMCreateRequest withRecipientId(String value) {
        String newValue = Objects.requireNonNull(value, "recipientId");
        if (this.recipientId.equals(newValue)) {
            return this;
        }
        return new ImmutableDMCreateRequest(this, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDMCreateRequest && this.equalTo(0, (ImmutableDMCreateRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutableDMCreateRequest another) {
        return this.recipientId.equals(another.recipientId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.recipientId.hashCode();
        return h;
    }

    public String toString() {
        return "DMCreateRequest{recipientId=" + this.recipientId + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableDMCreateRequest fromJson(Json json) {
        Builder builder = ImmutableDMCreateRequest.builder();
        if (json.recipientId != null) {
            builder.recipientId(json.recipientId);
        }
        return builder.build();
    }

    public static ImmutableDMCreateRequest of(String recipientId) {
        return new ImmutableDMCreateRequest(recipientId);
    }

    public static ImmutableDMCreateRequest copyOf(DMCreateRequest instance) {
        if (instance instanceof ImmutableDMCreateRequest) {
            return (ImmutableDMCreateRequest)instance;
        }
        return ImmutableDMCreateRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_RECIPIENT_ID = 1L;
        private long initBits = 1L;
        @Nullable
        private String recipientId;

        private Builder() {
        }

        public final Builder from(DMCreateRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.recipientId(instance.recipientId());
            return this;
        }

        @JsonProperty(value="recipient_id")
        public final Builder recipientId(String recipientId) {
            this.recipientId = Objects.requireNonNull(recipientId, "recipientId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableDMCreateRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDMCreateRequest(null, this.recipientId);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("recipientId");
            }
            return "Cannot build DMCreateRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements DMCreateRequest {
        @Nullable
        String recipientId;

        Json() {
        }

        @JsonProperty(value="recipient_id")
        public void setRecipientId(String recipientId) {
            this.recipientId = recipientId;
        }

        @Override
        public String recipientId() {
            throw new UnsupportedOperationException();
        }
    }
}

