/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.interaction;

import discord4j.common.annotations.Experimental;
import discord4j.rest.interaction.DirectInteraction;
import discord4j.rest.interaction.GuildInteraction;
import discord4j.rest.interaction.InteractionHandler;
import discord4j.rest.interaction.RestInteraction;
import java.util.function.Function;

@Experimental
public final class InteractionHandlerSpec {
    private final Function<GuildInteraction, InteractionHandler> guildInteractionHandlerFunction;
    private final Function<DirectInteraction, InteractionHandler> directInteractionHandlerFunction;

    InteractionHandlerSpec(Function<GuildInteraction, InteractionHandler> guildInteractionHandlerFunction, Function<DirectInteraction, InteractionHandler> directInteractionHandlerFunction) {
        this.guildInteractionHandlerFunction = guildInteractionHandlerFunction;
        this.directInteractionHandlerFunction = directInteractionHandlerFunction;
    }

    public InteractionHandlerSpec guild(Function<GuildInteraction, InteractionHandler> guildInteractionHandlerFunction) {
        return new InteractionHandlerSpec(guildInteractionHandlerFunction, this.directInteractionHandlerFunction);
    }

    public InteractionHandlerSpec direct(Function<DirectInteraction, InteractionHandler> directInteractionHandlerFunction) {
        return new InteractionHandlerSpec(this.guildInteractionHandlerFunction, directInteractionHandlerFunction);
    }

    public Function<RestInteraction, InteractionHandler> build() {
        return interaction -> {
            if (interaction.getData().guildId().isAbsent()) {
                return this.directInteractionHandlerFunction.apply((DirectInteraction)interaction);
            }
            return this.guildInteractionHandlerFunction.apply((GuildInteraction)interaction);
        };
    }
}

